/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.parser;

import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class HiveLexer
extends Lexer {
    public static final Keywords DEFAULT_HIVE_KEYWORDS;

    public HiveLexer(char[] input, int inputLength, boolean skipComment) {
        super(input, inputLength, skipComment);
        this.keywods = DEFAULT_HIVE_KEYWORDS;
    }

    public HiveLexer(String input) {
        super(input);
        this.keywods = DEFAULT_HIVE_KEYWORDS;
    }

    @Override
    public void scanComment() {
        if (this.ch != '/') {
            throw new IllegalStateException();
        }
        this.np = this.bp;
        this.sp = 0;
        this.scanChar();
        ++this.sp;
        if (this.ch == '*') {
            this.scanChar();
            ++this.sp;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.sp;
            }
            boolean isHint = false;
            int startHintSp = this.sp + 1;
            if (this.ch == '+') {
                isHint = true;
                this.scanChar();
                ++this.sp;
            }
            while (true) {
                if (this.ch == '*' && this.buf[this.bp + 1] == '/') {
                    this.sp += 2;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.scanChar();
            this.scanChar();
            if (isHint) {
                this.stringVal = new String(this.buf, this.np + startHintSp, this.sp - startHintSp - 2).trim();
                this.token = Token.HINT;
            } else {
                this.stringVal = new String(this.buf, this.np, this.sp);
                this.token = Token.MULTI_LINE_COMMENT;
            }
            if (this.token != Token.HINT && !this.isAllowComment()) {
                throw new NotAllowCommentException();
            }
            return;
        }
        if (!this.isAllowComment()) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/') {
            this.scanChar();
            ++this.sp;
            while (true) {
                if (this.ch == '\r') {
                    if (this.buf[this.bp + 1] == '\n') {
                        this.sp += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.sp;
                    break;
                }
                if (this.ch == '\r') {
                    this.scanChar();
                    ++this.sp;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.stringVal = new String(this.buf, this.np + 1, this.sp);
            this.token = Token.LINE_COMMENT;
            return;
        }
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("WITH", Token.WITH);
        DEFAULT_HIVE_KEYWORDS = new Keywords(map);
    }
}

