/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class OracleLexer
extends Lexer {
    public static final Keywords DEFAULT_ORACLE_KEYWORDS;

    public OracleLexer(char[] input, int inputLength, boolean skipComment) {
        super(input, inputLength, skipComment);
        this.keywods = DEFAULT_ORACLE_KEYWORDS;
    }

    public OracleLexer(String input) {
        super(input);
        this.keywods = DEFAULT_ORACLE_KEYWORDS;
    }

    @Override
    public void scanVariable() {
        char ch;
        if (this.ch == '@') {
            this.scanChar();
            this.token = Token.MONKEYS_AT;
            return;
        }
        if (this.ch != ':' && this.ch != '#') {
            throw new SQLParseException("illegal variable");
        }
        int hash = this.ch;
        this.np = this.bp;
        this.sp = 1;
        boolean quoteFlag = false;
        if (this.buf[this.bp + 1] == '\"') {
            hash = 31 * hash + 34;
            ++this.bp;
            ++this.sp;
            quoteFlag = true;
        }
        while (CharTypes.isIdentifierChar(ch = this.buf[++this.bp])) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        if (quoteFlag) {
            if (ch != '\"') {
                throw new SQLParseException("syntax error");
            }
            hash = 31 * hash + 34;
            ++this.bp;
            ++this.sp;
        }
        this.ch = this.buf[this.bp];
        this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
        Token tok = this.keywods.getKeyword(this.stringVal);
        this.token = tok != null ? tok : Token.VARIANT;
    }

    @Override
    public void scanComment() {
        if (this.ch != '/' && this.ch != '-') {
            throw new IllegalStateException();
        }
        this.np = this.bp;
        this.sp = 0;
        this.scanChar();
        if (this.ch == '*') {
            this.scanChar();
            ++this.sp;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.sp;
            }
            boolean isHint = false;
            int startHintSp = this.sp + 1;
            if (this.ch == '+') {
                isHint = true;
                this.scanChar();
                ++this.sp;
            }
            while (true) {
                if (this.ch == '*' && this.buf[this.bp + 1] == '/') {
                    this.sp += 2;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.scanChar();
            this.scanChar();
            if (isHint) {
                this.stringVal = new String(this.buf, this.np + startHintSp, this.sp - startHintSp - 1);
                this.token = Token.HINT;
            } else {
                this.stringVal = new String(this.buf, this.np, this.sp);
                this.token = Token.MULTI_LINE_COMMENT;
            }
            if (this.token != Token.HINT && !this.isAllowComment()) {
                throw new NotAllowCommentException();
            }
            return;
        }
        if (!this.isAllowComment()) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/' || this.ch == '-') {
            this.scanChar();
            ++this.sp;
            while (true) {
                if (this.ch == '\r') {
                    if (this.buf[this.bp + 1] == '\n') {
                        this.sp += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.sp;
                    break;
                }
                if (this.ch == '\u001a') break;
                if (this.ch == '\n') {
                    this.scanChar();
                    ++this.sp;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.stringVal = new String(this.buf, this.np + 1, this.sp);
            this.token = Token.LINE_COMMENT;
            return;
        }
    }

    @Override
    public void scanNumber() {
        this.np = this.bp++;
        if (this.ch == '-') {
            ++this.sp;
            this.ch = this.buf[this.bp];
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            if (this.buf[this.bp + 1] == '.') {
                this.token = Token.LITERAL_INT;
                return;
            }
            ++this.sp;
            this.ch = this.buf[++this.bp];
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            isDouble = true;
        }
        if (this.ch == 'f' || this.ch == 'F') {
            this.token = Token.BINARY_FLOAT;
            this.scanChar();
            return;
        }
        if (this.ch == 'd' || this.ch == 'D') {
            this.token = Token.BINARY_DOUBLE;
            this.scanChar();
            return;
        }
        this.token = isDouble ? Token.LITERAL_FLOAT : Token.LITERAL_INT;
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("BEGIN", Token.BEGIN);
        map.put("COLUMN", Token.COLUMN);
        map.put("COMMENT", Token.COMMENT);
        map.put("COMMIT", Token.COMMIT);
        map.put("CONNECT", Token.CONNECT);
        map.put("CROSS", Token.CROSS);
        map.put("CURSOR", Token.CURSOR);
        map.put("DECLARE", Token.DECLARE);
        map.put("ERRORS", Token.ERRORS);
        map.put("EXCEPTION", Token.EXCEPTION);
        map.put("EXCLUSIVE", Token.EXCLUSIVE);
        map.put("EXTRACT", Token.EXTRACT);
        map.put("GOTO", Token.GOTO);
        map.put("GRANT", Token.GRANT);
        map.put("IF", Token.IF);
        map.put("LIMIT", Token.LIMIT);
        map.put("LOCAL", Token.LOCAL);
        map.put("LOOP", Token.LOOP);
        map.put("MATCHED", Token.MATCHED);
        map.put("MERGE", Token.MERGE);
        map.put("MODE", Token.MODE);
        map.put("MODEL", Token.MODEL);
        map.put("NOWAIT", Token.NOWAIT);
        map.put("OF", Token.OF);
        map.put("PRIOR", Token.PRIOR);
        map.put("PROCEDURE", Token.PROCEDURE);
        map.put("REJECT", Token.REJECT);
        map.put("RETURNING", Token.RETURNING);
        map.put("SAVEPOINT", Token.SAVEPOINT);
        map.put("SESSION", Token.SESSION);
        map.put("SHARE", Token.SHARE);
        map.put("START", Token.START);
        map.put("SYSDATE", Token.SYSDATE);
        map.put("UNLIMITED", Token.UNLIMITED);
        map.put("USING", Token.USING);
        map.put("WAIT", Token.WAIT);
        map.put("WITH", Token.WITH);
        DEFAULT_ORACLE_KEYWORDS = new Keywords(map);
    }
}

