/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorUtils;
import com.alibaba.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaStatVisitor
extends SQLASTVisitorAdapter {
    protected final HashMap<TableStat.Name, TableStat> tableStats = new LinkedHashMap<TableStat.Name, TableStat>();
    protected final Set<TableStat.Column> columns = new LinkedHashSet<TableStat.Column>();
    protected final List<TableStat.Condition> conditions = new ArrayList<TableStat.Condition>();
    protected final Set<TableStat.Relationship> relationships = new LinkedHashSet<TableStat.Relationship>();
    protected final List<TableStat.Column> orderByColumns = new ArrayList<TableStat.Column>();
    protected final Set<TableStat.Column> groupByColumns = new LinkedHashSet<TableStat.Column>();
    protected final Map<String, SQLObject> subQueryMap = new LinkedHashMap<String, SQLObject>();
    protected final Map<String, SQLObject> variants = new LinkedHashMap<String, SQLObject>();
    protected Map<String, String> aliasMap = new HashMap<String, String>();
    protected String currentTable;
    public static final String ATTR_TABLE = "_table_";
    public static final String ATTR_COLUMN = "_column_";
    private List<Object> parameters;
    private TableStat.Mode mode;

    public SchemaStatVisitor() {
        this(new ArrayList<Object>());
    }

    public SchemaStatVisitor(List<Object> parameters) {
        this.parameters = parameters;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public TableStat getTableStat(String ident) {
        return this.getTableStat(ident, null);
    }

    public TableStat.Column addColumn(String tableName, String columnName) {
        tableName = this.handleName(tableName);
        columnName = this.handleName(columnName);
        TableStat.Column column = new TableStat.Column(tableName, columnName);
        this.columns.add(column);
        return column;
    }

    public TableStat getTableStat(String tableName, String alias) {
        if (this.variants.containsKey(tableName)) {
            return null;
        }
        TableStat stat = this.tableStats.get(tableName = this.handleName(tableName));
        if (stat == null) {
            stat = new TableStat();
            this.tableStats.put(new TableStat.Name(tableName), stat);
            if (alias != null) {
                this.aliasMap.put(alias, tableName);
            }
        }
        return stat;
    }

    private String handleName(String ident) {
        ident = ident.replaceAll("\"", "");
        ident = ident.replaceAll(" ", "");
        ident = this.aliasWrap(ident);
        return ident;
    }

    public Map<String, SQLObject> getVariants() {
        return this.variants;
    }

    public void setAliasMap() {
        this.setAliasMap(new HashMap<String, String>());
    }

    public void clearAliasMap() {
        this.aliasMap = null;
    }

    public void setAliasMap(Map<String, String> aliasMap) {
        this.aliasMap = aliasMap;
    }

    public Map<String, String> getAliasMap() {
        return this.aliasMap;
    }

    public void setCurrentTable(String table) {
        this.currentTable = table;
    }

    public void setCurrentTable(SQLObject x) {
        x.putAttribute("_old_local_", this.currentTable);
    }

    public void restoreCurrentTable(SQLObject x) {
        String table;
        this.currentTable = table = (String)x.getAttribute("_old_local_");
    }

    public void setCurrentTable(SQLObject x, String table) {
        x.putAttribute("_old_local_", this.currentTable);
        this.currentTable = table;
    }

    public String getCurrentTable() {
        return this.currentTable;
    }

    protected TableStat.Mode getMode() {
        return this.mode;
    }

    protected void setModeOrigin(SQLObject x) {
        TableStat.Mode originalMode;
        this.mode = originalMode = (TableStat.Mode)((Object)x.getAttribute("_original_use_mode"));
    }

    protected TableStat.Mode setMode(SQLObject x, TableStat.Mode mode) {
        TableStat.Mode oldMode = this.mode;
        x.putAttribute("_original_use_mode", (Object)oldMode);
        this.mode = mode;
        return oldMode;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        OrderByStatVisitor orderByVisitor = new OrderByStatVisitor(x);
        SQLSelectQueryBlock query = null;
        if (x.getParent() instanceof SQLSelectQueryBlock) {
            query = (SQLSelectQueryBlock)x.getParent();
        }
        if (query != null) {
            for (SQLSelectOrderByItem item : x.getItems()) {
                int intValue;
                SQLExpr expr = item.getExpr();
                if (!(expr instanceof SQLIntegerExpr) || (intValue = ((SQLIntegerExpr)expr).getNumber().intValue() - 1) >= query.getSelectList().size()) continue;
                SQLSelectItem selectItem = query.getSelectList().get(intValue);
                selectItem.getExpr().accept(orderByVisitor);
            }
        }
        x.accept(orderByVisitor);
        return true;
    }

    public Set<TableStat.Relationship> getRelationships() {
        return this.relationships;
    }

    public List<TableStat.Column> getOrderByColumns() {
        return this.orderByColumns;
    }

    public Set<TableStat.Column> getGroupByColumns() {
        return this.groupByColumns;
    }

    public List<TableStat.Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        x.getLeft().setParent(x);
        x.getRight().setParent(x);
        switch (x.getOperator()) {
            case Equality: 
            case NotEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case LessThan: 
            case LessThanOrEqual: 
            case LessThanOrEqualOrGreaterThan: 
            case Like: 
            case NotLike: 
            case Is: 
            case IsNot: {
                this.handleCondition(x.getLeft(), x.getOperator().name, x.getRight());
                this.handleCondition(x.getRight(), x.getOperator().name, x.getLeft());
                this.handleRelationship(x.getLeft(), x.getOperator().name, x.getRight());
                break;
            }
        }
        return true;
    }

    protected void handleRelationship(SQLExpr left, String operator, SQLExpr right) {
        TableStat.Column leftColumn = this.getColumn(left);
        if (leftColumn == null) {
            return;
        }
        TableStat.Column rightColumn = this.getColumn(right);
        if (rightColumn == null) {
            return;
        }
        TableStat.Relationship relationship = new TableStat.Relationship();
        relationship.setLeft(leftColumn);
        relationship.setRight(rightColumn);
        relationship.setOperator(operator);
        this.relationships.add(relationship);
    }

    protected void handleCondition(SQLExpr expr, String operator, List<SQLExpr> values) {
        this.handleCondition(expr, operator, values.toArray(new SQLExpr[values.size()]));
    }

    protected void handleCondition(SQLExpr expr, String operator, SQLExpr ... valueExprs) {
        TableStat.Column column = this.getColumn(expr);
        if (column == null) {
            return;
        }
        TableStat.Condition condition = null;
        for (TableStat.Condition item : this.getConditions()) {
            if (!item.getColumn().equals(column) || !item.getOperator().equals(operator)) continue;
            condition = item;
            break;
        }
        if (condition == null) {
            condition = new TableStat.Condition();
            condition.setColumn(column);
            condition.setOperator(operator);
            this.conditions.add(condition);
        }
        for (SQLExpr item : valueExprs) {
            Object value = SQLEvalVisitorUtils.eval(this.getDbType(), (SQLObject)item, this.parameters, false);
            condition.getValues().add(value);
        }
    }

    public String getDbType() {
        return null;
    }

    protected TableStat.Column getColumn(SQLExpr expr) {
        Map<String, String> aliasMap = this.getAliasMap();
        if (aliasMap == null) {
            return null;
        }
        if (expr instanceof SQLPropertyExpr) {
            SQLExpr owner = ((SQLPropertyExpr)expr).getOwner();
            String column = ((SQLPropertyExpr)expr).getName();
            if (owner instanceof SQLIdentifierExpr) {
                String tableName = ((SQLIdentifierExpr)owner).getName();
                String table = tableName;
                if (aliasMap.containsKey(table)) {
                    table = aliasMap.get(table);
                }
                if (this.variants.containsKey(table)) {
                    return null;
                }
                if (table != null) {
                    return new TableStat.Column(table, column);
                }
                return this.handleSubQueryColumn(tableName, column);
            }
            return null;
        }
        if (expr instanceof SQLIdentifierExpr) {
            TableStat.Column attrColumn = (TableStat.Column)expr.getAttribute(ATTR_COLUMN);
            if (attrColumn != null) {
                return attrColumn;
            }
            String column = ((SQLIdentifierExpr)expr).getName();
            String table = this.getCurrentTable();
            if (table != null && aliasMap.containsKey(table) && (table = aliasMap.get(table)) == null) {
                return null;
            }
            if (table != null) {
                return new TableStat.Column(table, column);
            }
            if (this.variants.containsKey(column)) {
                return null;
            }
            return new TableStat.Column("UNKNOWN", column);
        }
        return null;
    }

    @Override
    public boolean visit(SQLTruncateStatement x) {
        this.setMode(x, TableStat.Mode.Delete);
        this.setAliasMap();
        String originalTable = this.getCurrentTable();
        for (SQLExprTableSource tableSource : x.getTableSources()) {
            SQLName name = (SQLName)tableSource.getExpr();
            String ident = name.toString();
            this.setCurrentTable(ident);
            x.putAttribute("_old_local_", originalTable);
            TableStat stat = this.getTableStat(ident);
            stat.incrementDeleteCount();
            Map<String, String> aliasMap = this.getAliasMap();
            if (aliasMap == null) continue;
            aliasMap.put(ident, ident);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropTableStatement x) {
        this.setMode(x, TableStat.Mode.Insert);
        this.setAliasMap();
        String originalTable = this.getCurrentTable();
        for (SQLExprTableSource tableSource : x.getTableSources()) {
            SQLName name = (SQLName)tableSource.getExpr();
            String ident = name.toString();
            this.setCurrentTable(ident);
            x.putAttribute("_old_local_", originalTable);
            TableStat stat = this.getTableStat(ident);
            stat.incrementDropCount();
            Map<String, String> aliasMap = this.getAliasMap();
            if (aliasMap == null) continue;
            aliasMap.put(ident, ident);
        }
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        this.setMode(x, TableStat.Mode.Insert);
        this.setAliasMap();
        String originalTable = this.getCurrentTable();
        if (x.getTableName() instanceof SQLName) {
            String ident = x.getTableName().toString();
            this.setCurrentTable(ident);
            x.putAttribute("_old_local_", originalTable);
            TableStat stat = this.getTableStat(ident);
            stat.incrementInsertCount();
            Map<String, String> aliasMap = this.getAliasMap();
            if (aliasMap != null) {
                if (x.getAlias() != null) {
                    aliasMap.put(x.getAlias(), ident);
                }
                aliasMap.put(ident, ident);
            }
        }
        this.accept(x.getColumns());
        this.accept(x.getQuery());
        return false;
    }

    protected void accept(SQLObject x) {
        if (x != null) {
            x.accept(this);
        }
    }

    protected void accept(List<? extends SQLObject> nodes) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            this.accept(nodes.get(i));
        }
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        SQLExprTableSource tableSource;
        SQLName into;
        String ident;
        TableStat stat;
        this.setMode(x, TableStat.Mode.Select);
        if (x.getFrom() instanceof SQLSubqueryTableSource) {
            x.getFrom().accept(this);
            return false;
        }
        if (x.getInto() != null && x.getInto().getExpr() instanceof SQLName && (stat = this.getTableStat(ident = (into = (SQLName)x.getInto().getExpr()).toString())) != null) {
            stat.incrementInsertCount();
        }
        String originalTable = this.getCurrentTable();
        if (x.getFrom() instanceof SQLExprTableSource && (tableSource = (SQLExprTableSource)x.getFrom()).getExpr() instanceof SQLName) {
            String ident2 = tableSource.getExpr().toString();
            this.setCurrentTable(x, ident2);
            x.putAttribute(ATTR_TABLE, ident2);
            if (x.getParent() instanceof SQLSelect) {
                x.getParent().putAttribute(ATTR_TABLE, ident2);
            }
            x.putAttribute("_old_local_", originalTable);
        }
        if (x.getFrom() != null) {
            x.getFrom().accept(this);
            String table = (String)x.getFrom().getAttribute(ATTR_TABLE);
            if (table != null) {
                x.putAttribute(ATTR_TABLE, table);
            }
        }
        if (x.getWhere() != null) {
            x.getWhere().setParent(x);
        }
        return true;
    }

    @Override
    public void endVisit(SQLSelectQueryBlock x) {
        String originalTable = (String)x.getAttribute("_old_local_");
        x.putAttribute("table", this.getCurrentTable());
        this.setCurrentTable(originalTable);
        this.setModeOrigin(x);
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        return true;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        if (x.getOwner() instanceof SQLIdentifierExpr) {
            String owner = ((SQLIdentifierExpr)x.getOwner()).getName();
            if (this.subQueryMap.containsKey(owner)) {
                return false;
            }
            if ((owner = this.aliasWrap(owner)) != null) {
                TableStat.Column column = this.addColumn(owner, x.getName());
                x.putAttribute(ATTR_COLUMN, column);
            }
        }
        return false;
    }

    protected String aliasWrap(String name) {
        Map<String, String> aliasMap = this.getAliasMap();
        if (aliasMap != null) {
            for (Map.Entry<String, String> entry : aliasMap.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().equalsIgnoreCase(name)) continue;
                return entry.getValue();
            }
        }
        return name;
    }

    protected TableStat.Column handleSubQueryColumn(String owner, String alias) {
        SQLObject query = this.subQueryMap.get(owner);
        if (query == null) {
            return null;
        }
        List<SQLSelectItem> selectList = null;
        if (query instanceof SQLSelectQueryBlock) {
            selectList = ((SQLSelectQueryBlock)query).getSelectList();
        }
        if (selectList != null) {
            for (SQLSelectItem item : selectList) {
                String itemAlias = item.getAlias();
                SQLExpr itemExpr = item.getExpr();
                if (itemAlias == null) {
                    if (itemExpr instanceof SQLIdentifierExpr) {
                        itemAlias = itemExpr.toString();
                    } else if (itemExpr instanceof SQLPropertyExpr) {
                        itemAlias = ((SQLPropertyExpr)itemExpr).getName();
                    }
                }
                if (!alias.equalsIgnoreCase(itemAlias)) continue;
                TableStat.Column column = (TableStat.Column)itemExpr.getAttribute(ATTR_COLUMN);
                return column;
            }
        }
        return null;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String currentTable = this.getCurrentTable();
        if (this.subQueryMap.containsKey(currentTable)) {
            return false;
        }
        String ident = x.toString();
        if (this.variants.containsKey(ident)) {
            return false;
        }
        if (currentTable != null) {
            TableStat.Column column = this.addColumn(currentTable, ident);
            x.putAttribute(ATTR_COLUMN, column);
        } else {
            TableStat.Column column = this.handleUnkownColumn(ident);
            if (column != null) {
                x.putAttribute(ATTR_COLUMN, column);
            }
        }
        return false;
    }

    protected TableStat.Column handleUnkownColumn(String columnName) {
        return this.addColumn("UNKNOWN", columnName);
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        String currentTable = this.getCurrentTable();
        if (this.subQueryMap.containsKey(currentTable)) {
            return false;
        }
        if (currentTable != null) {
            this.addColumn(currentTable, "*");
        }
        return false;
    }

    public Map<TableStat.Name, TableStat> getTables() {
        return this.tableStats;
    }

    public boolean containsTable(String tableName) {
        return this.tableStats.containsKey(new TableStat.Name(tableName));
    }

    public Set<TableStat.Column> getColumns() {
        return this.columns;
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        this.setAliasMap();
        return true;
    }

    @Override
    public void endVisit(SQLSelectStatement x) {
        this.clearAliasMap();
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        x.getSelect().accept(this);
        SQLSelectQuery query = x.getSelect().getQuery();
        Map<String, String> aliasMap = this.getAliasMap();
        if (aliasMap != null && x.getAlias() != null) {
            aliasMap.put(x.getAlias(), null);
            this.subQueryMap.put(x.getAlias(), query);
        }
        return false;
    }

    protected boolean isSimpleExprTableSource(SQLExprTableSource x) {
        return x.getExpr() instanceof SQLName;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        if (this.isSimpleExprTableSource(x)) {
            String ident = x.getExpr().toString();
            if (this.variants.containsKey(ident)) {
                return false;
            }
            if (this.subQueryMap.containsKey(ident)) {
                return false;
            }
            Map<String, String> aliasMap = this.getAliasMap();
            TableStat stat = this.getTableStat(ident);
            TableStat.Mode mode = this.getMode();
            switch (mode) {
                case Delete: {
                    stat.incrementDeleteCount();
                    break;
                }
                case Insert: {
                    stat.incrementInsertCount();
                    break;
                }
                case Update: {
                    stat.incrementUpdateCount();
                    break;
                }
                case Select: {
                    stat.incrementSelectCount();
                    break;
                }
                case Merge: {
                    stat.incrementMergeCount();
                    break;
                }
            }
            if (aliasMap != null) {
                String alias = x.getAlias();
                if (alias != null && !aliasMap.containsKey(alias)) {
                    aliasMap.put(alias, ident);
                }
                if (!aliasMap.containsKey(ident)) {
                    aliasMap.put(ident, ident);
                }
            }
        } else {
            this.accept(x.getExpr());
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        x.getExpr().setParent(x);
        return true;
    }

    @Override
    public void endVisit(SQLSelect x) {
        this.restoreCurrentTable(x);
    }

    @Override
    public boolean visit(SQLSelect x) {
        this.setCurrentTable(x);
        if (x.getOrderBy() != null) {
            x.getOrderBy().setParent(x);
        }
        this.accept(x.getQuery());
        String originalTable = this.getCurrentTable();
        this.setCurrentTable((String)x.getQuery().getAttribute("table"));
        x.putAttribute("_old_local_", originalTable);
        this.accept(x.getOrderBy());
        this.setCurrentTable(originalTable);
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        this.accept(x.getArguments());
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        this.accept(x.getParameters());
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        this.setAliasMap();
        String ident = x.getTableName().toString();
        this.setCurrentTable(ident);
        TableStat stat = this.getTableStat(ident);
        stat.incrementUpdateCount();
        Map<String, String> aliasMap = this.getAliasMap();
        aliasMap.put(ident, ident);
        this.accept(x.getItems());
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        this.setAliasMap();
        this.setMode(x, TableStat.Mode.Delete);
        String tableName = x.getTableName().toString();
        this.setCurrentTable(tableName);
        if (x.getAlias() != null) {
            this.aliasMap.put(x.getAlias(), tableName);
        }
        TableStat stat = this.getTableStat(tableName);
        stat.incrementDeleteCount();
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        if (x.isNot()) {
            this.handleCondition(x.getExpr(), "NOT IN", x.getTargetList());
        } else {
            this.handleCondition(x.getExpr(), "IN", x.getTargetList());
        }
        return true;
    }

    @Override
    public boolean visit(SQLInSubQueryExpr x) {
        if (x.isNot()) {
            this.handleCondition(x.getExpr(), "NOT IN", new SQLExpr[0]);
        } else {
            this.handleCondition(x.getExpr(), "IN", new SQLExpr[0]);
        }
        return true;
    }

    @Override
    public void endVisit(SQLDeleteStatement x) {
        this.clearAliasMap();
    }

    @Override
    public void endVisit(SQLUpdateStatement x) {
        this.clearAliasMap();
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        for (SQLTableElement e : x.getTableElementList()) {
            e.setParent(x);
        }
        String tableName = x.getName().toString();
        TableStat stat = this.getTableStat(tableName);
        stat.incrementCreateCount();
        this.setCurrentTable(x, tableName);
        this.accept(x.getTableElementList());
        this.restoreCurrentTable(x);
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        String tableName = null;
        SQLObject parent = x.getParent();
        if (parent instanceof SQLCreateTableStatement) {
            tableName = ((SQLCreateTableStatement)parent).getName().toString();
        }
        if (tableName == null) {
            return true;
        }
        String columnName = x.getName().toString();
        this.addColumn(tableName, columnName);
        return false;
    }

    @Override
    public boolean visit(SQLCallStatement x) {
        return false;
    }

    @Override
    public void endVisit(SQLCommentStatement x) {
    }

    @Override
    public boolean visit(SQLCommentStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCurrentOfCursorExpr x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        String table = stmt.getName().toString();
        for (SQLColumnDefinition column : x.getColumns()) {
            String columnName = column.getName().toString();
            this.addColumn(table, columnName);
        }
        return false;
    }

    @Override
    public void endVisit(SQLAlterTableAddColumn x) {
    }

    public class OrderByStatVisitor
    extends SQLASTVisitorAdapter {
        private final SQLOrderBy orderBy;

        public OrderByStatVisitor(SQLOrderBy orderBy) {
            this.orderBy = orderBy;
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                item.getExpr().setParent(item);
            }
        }

        public SQLOrderBy getOrderBy() {
            return this.orderBy;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            String currentTable = SchemaStatVisitor.this.getCurrentTable();
            if (SchemaStatVisitor.this.subQueryMap.containsKey(currentTable)) {
                return false;
            }
            if (currentTable != null) {
                this.addOrderByColumn(currentTable, x.getName(), x);
            } else {
                this.addOrderByColumn("UNKOWN", x.getName(), x);
            }
            return false;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            if (x.getOwner() instanceof SQLIdentifierExpr) {
                String owner = ((SQLIdentifierExpr)x.getOwner()).getName();
                if (SchemaStatVisitor.this.subQueryMap.containsKey(owner)) {
                    return false;
                }
                if ((owner = SchemaStatVisitor.this.aliasWrap(owner)) != null) {
                    this.addOrderByColumn(owner, x.getName(), x);
                }
            }
            return false;
        }

        public void addOrderByColumn(String table, String columnName, SQLObject expr) {
            TableStat.Column column = new TableStat.Column(table, columnName);
            SQLObject parent = expr.getParent();
            if (parent instanceof SQLSelectOrderByItem) {
                SQLOrderingSpecification type = ((SQLSelectOrderByItem)parent).getType();
                column.getAttributes().put("orderBy.type", (Object)type);
            }
            SchemaStatVisitor.this.orderByColumns.add(column);
        }
    }
}

