/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall.spi;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlBooleanExpr;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;

public class WallVisitorUtils {
    private static final Log LOG = LogFactory.getLog(WallVisitorUtils.class);

    public static void check(WallVisitor visitor, SQLInListExpr x) {
    }

    public static void check(WallVisitor visitor, SQLBinaryOpExpr x) {
    }

    public static void check(WallVisitor visitor, SQLPropertyExpr x) {
        WallVisitorUtils.checkSchema(visitor, x.getOwner());
    }

    public static void checkInsert(WallVisitor visitor, SQLInsertInto x) {
        WallVisitorUtils.checkReadOnly(visitor, x.getTableSource());
        if (!visitor.getConfig().isInsertAllow()) {
            visitor.getViolations().add(new IllegalSQLObjectViolation(visitor.toSQL(x)));
        }
    }

    public static void checkSelelct(WallVisitor visitor, SQLSelectQueryBlock x) {
        if (x.getInto() != null) {
            WallVisitorUtils.checkReadOnly(visitor, x.getInto());
        }
        if (!visitor.getConfig().isSelectIntoAllow() && x.getInto() != null) {
            WallVisitorUtils.addViolation(visitor, x);
            return;
        }
        if (!visitor.getConfig().isSelectWhereAlwayTrueCheck()) {
            return;
        }
        SQLExpr where = x.getWhere();
        if (where != null) {
            WallVisitorUtils.checkCondition(visitor, x.getWhere());
            if (Boolean.TRUE == WallVisitorUtils.getValue(where)) {
                SQLBinaryOpExpr binaryOpExpr;
                if (where instanceof SQLBinaryOpExpr && ((binaryOpExpr = (SQLBinaryOpExpr)where).getOperator() == SQLBinaryOperator.Equality || binaryOpExpr.getOperator() == SQLBinaryOperator.NotEqual) && binaryOpExpr.getLeft() instanceof SQLIntegerExpr && binaryOpExpr.getRight() instanceof SQLIntegerExpr) {
                    return;
                }
                WallVisitorUtils.addViolation(visitor, x);
            }
        }
    }

    public static void checkHaving(WallVisitor visitor, SQLExpr x) {
        if (x == null) {
            return;
        }
        if (!visitor.getConfig().isSelectHavingAlwayTrueCheck()) {
            return;
        }
        if (Boolean.TRUE == WallVisitorUtils.getValue(x)) {
            WallVisitorUtils.addViolation(visitor, x);
        }
    }

    public static void checkDelete(WallVisitor visitor, SQLDeleteStatement x) {
        WallVisitorUtils.checkReadOnly(visitor, x.getExprTableSource());
        if (!visitor.getConfig().isDeleteAllow()) {
            WallVisitorUtils.addViolation(visitor, x);
            return;
        }
        if (!visitor.getConfig().isDeleteWhereAlwayTrueCheck()) {
            return;
        }
        if (x.getWhere() == null || Boolean.TRUE == WallVisitorUtils.getValue(x.getWhere())) {
            WallVisitorUtils.addViolation(visitor, x);
            return;
        }
        WallVisitorUtils.checkCondition(visitor, x.getWhere());
    }

    private static void checkCondition(WallVisitor visitor, SQLExpr x) {
        if (x == null) {
            return;
        }
        if (visitor.getConfig().isMustParameterized()) {
            ExportParameterVisitor exportParameterVisitor = visitor.getProvider().createExportParameterVisitor();
            x.accept(exportParameterVisitor);
            if (exportParameterVisitor.getParameters().size() > 0) {
                WallVisitorUtils.addViolation(visitor, x);
                return;
            }
        }
    }

    public static void checkReadOnly(WallVisitor visitor, SQLTableSource tableSource) {
        if (tableSource instanceof SQLExprTableSource) {
            String tableName = null;
            SQLExpr tableNameExpr = ((SQLExprTableSource)tableSource).getExpr();
            if (tableNameExpr instanceof SQLName) {
                tableName = ((SQLName)tableNameExpr).getSimleName();
            }
            if (tableName != null) {
                tableName = WallVisitorUtils.form(tableName);
                if (visitor.getConfig().getReadOnlyTables().contains(tableName)) {
                    WallVisitorUtils.addViolation(visitor, tableSource);
                }
            }
        } else if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
            WallVisitorUtils.checkReadOnly(visitor, join.getLeft());
            WallVisitorUtils.checkReadOnly(visitor, join.getRight());
        }
    }

    public static void checkUpdate(WallVisitor visitor, SQLUpdateStatement x) {
        WallVisitorUtils.checkReadOnly(visitor, x.getTableSource());
        if (!visitor.getConfig().isUpdateAllow()) {
            WallVisitorUtils.addViolation(visitor, x);
            return;
        }
        if (!visitor.getConfig().isUpdateWhereAlayTrueCheck()) {
            return;
        }
        if (x.getWhere() == null || Boolean.TRUE == WallVisitorUtils.getValue(x.getWhere())) {
            WallVisitorUtils.addViolation(visitor, x);
            return;
        }
        WallVisitorUtils.checkCondition(visitor, x.getWhere());
    }

    public static Object getValue(SQLBinaryOpExpr x) {
        String text;
        x.getLeft().setParent(x);
        x.getRight().setParent(x);
        if (x.getLeft() instanceof SQLName && x.getRight() instanceof SQLName && x.getLeft().toString().equalsIgnoreCase(x.getRight().toString())) {
            if (x.getOperator() == SQLBinaryOperator.Equality) {
                return Boolean.TRUE;
            }
            if (x.getOperator() == SQLBinaryOperator.NotEqual) {
                return Boolean.FALSE;
            }
            switch (x.getOperator()) {
                case Equality: 
                case Like: {
                    return Boolean.TRUE;
                }
                case NotEqual: 
                case GreaterThan: 
                case GreaterThanOrEqual: 
                case LessThan: 
                case LessThanOrEqual: 
                case LessThanOrGreater: 
                case NotLike: {
                    return Boolean.FALSE;
                }
            }
        }
        Object leftResult = WallVisitorUtils.getValue(x.getLeft());
        Object rightResult = WallVisitorUtils.getValue(x.getRight());
        if (x.getOperator() == SQLBinaryOperator.BooleanOr && (Boolean.TRUE == leftResult || Boolean.TRUE == rightResult)) {
            return true;
        }
        if (x.getOperator() == SQLBinaryOperator.BooleanAnd) {
            if (Boolean.FALSE == leftResult || Boolean.FALSE == rightResult) {
                return false;
            }
            if (Boolean.TRUE == leftResult && Boolean.TRUE == rightResult) {
                return true;
            }
        }
        if (x.getOperator() == SQLBinaryOperator.Like && x.getRight() instanceof SQLCharExpr && (text = ((SQLCharExpr)x.getRight()).getText()).length() >= 0) {
            for (char ch : text.toCharArray()) {
                if (ch == '%') continue;
                return null;
            }
            return true;
        }
        if (leftResult == null || rightResult == null) {
            return null;
        }
        if (x.getOperator() == SQLBinaryOperator.Equality) {
            if (x.getLeft() instanceof SQLNullExpr && x.getRight() instanceof SQLNullExpr) {
                return true;
            }
            return leftResult.equals(rightResult);
        }
        if (x.getOperator() == SQLBinaryOperator.NotEqual || x.getOperator() == SQLBinaryOperator.LessThanOrGreater) {
            if (x.getLeft() instanceof SQLNullExpr && x.getRight() instanceof SQLNullExpr) {
                return false;
            }
            if (leftResult == null || rightResult == null) {
                return null;
            }
            return !leftResult.equals(rightResult);
        }
        if (x.getOperator() == SQLBinaryOperator.GreaterThan) {
            if (x.getLeft() instanceof SQLNullExpr && x.getRight() instanceof SQLNullExpr) {
                return false;
            }
            if (leftResult == null || rightResult == null) {
                return null;
            }
            if (leftResult instanceof Comparable) {
                return ((Comparable)leftResult).compareTo(rightResult) > 0;
            }
        }
        if (x.getOperator() == SQLBinaryOperator.GreaterThanOrEqual) {
            if (x.getLeft() instanceof SQLNullExpr && x.getRight() instanceof SQLNullExpr) {
                return false;
            }
            if (leftResult == null || rightResult == null) {
                return null;
            }
            if (leftResult instanceof Comparable) {
                return ((Comparable)leftResult).compareTo(rightResult) >= 0;
            }
        }
        if (x.getOperator() == SQLBinaryOperator.LessThan) {
            if (x.getLeft() instanceof SQLNullExpr && x.getRight() instanceof SQLNullExpr) {
                return false;
            }
            if (leftResult == null || rightResult == null) {
                return null;
            }
            if (leftResult instanceof Comparable) {
                return ((Comparable)leftResult).compareTo(rightResult) < 0;
            }
        }
        if (x.getOperator() == SQLBinaryOperator.LessThanOrEqual) {
            if (x.getLeft() instanceof SQLNullExpr && x.getRight() instanceof SQLNullExpr) {
                return false;
            }
            if (leftResult == null || rightResult == null) {
                return null;
            }
            if (leftResult instanceof Comparable) {
                return ((Comparable)leftResult).compareTo(rightResult) <= 0;
            }
        }
        if (x.getOperator() == SQLBinaryOperator.Concat) {
            return leftResult.toString() + rightResult.toString();
        }
        if (x.getOperator() == SQLBinaryOperator.Add) {
            if (leftResult == null || rightResult == null) {
                return null;
            }
            if (leftResult instanceof String || rightResult instanceof String) {
                return leftResult.toString() + rightResult.toString();
            }
            if (leftResult instanceof Number || rightResult instanceof Number) {
                return WallVisitorUtils.add((Number)leftResult, (Number)rightResult);
            }
        }
        return null;
    }

    private static Number add(Number a, Number b) {
        if (a instanceof BigDecimal) {
            return ((BigDecimal)a).add(new BigDecimal(b.toString()));
        }
        return a.longValue() + b.longValue();
    }

    public static Object getValue(SQLExpr x) {
        Object result;
        if (x instanceof SQLBinaryOpExpr) {
            return WallVisitorUtils.getValue((SQLBinaryOpExpr)x);
        }
        if (x instanceof MySqlBooleanExpr) {
            return ((MySqlBooleanExpr)x).getValue();
        }
        if (x instanceof SQLNumericLiteralExpr) {
            return ((SQLNumericLiteralExpr)x).getNumber();
        }
        if (x instanceof SQLCharExpr) {
            return ((SQLCharExpr)x).getText();
        }
        if (x instanceof SQLNCharExpr) {
            return ((SQLNCharExpr)x).getText();
        }
        if (x instanceof SQLNotExpr && (result = WallVisitorUtils.getValue(((SQLNotExpr)x).getExpr())) != null && result instanceof Boolean) {
            return (Boolean)result == false;
        }
        if (x instanceof SQLQueryExpr && WallVisitorUtils.isSimpleCountTableSource(((SQLQueryExpr)x).getSubQuery())) {
            return 1;
        }
        if (x instanceof SQLMethodInvokeExpr) {
            return WallVisitorUtils.getValue((SQLMethodInvokeExpr)x);
        }
        return null;
    }

    public static Object getValue(SQLMethodInvokeExpr x) {
        Object firstResult;
        SQLExpr first;
        String methodName = x.getMethodName();
        if ("len".equalsIgnoreCase(methodName) || "length".equalsIgnoreCase(methodName)) {
            Object firstValue = null;
            if (x.getParameters().size() > 0) {
                firstValue = WallVisitorUtils.getValue(x.getParameters().get(0));
            }
            if (firstValue instanceof String) {
                return ((String)firstValue).length();
            }
        }
        if ("if".equalsIgnoreCase(methodName) && x.getParameters().size() == 3) {
            first = x.getParameters().get(0);
            firstResult = WallVisitorUtils.getValue(first);
            if (Boolean.TRUE == firstResult) {
                return WallVisitorUtils.getValue(x.getParameters().get(1));
            }
            if (Boolean.FALSE == firstResult) {
                WallVisitorUtils.getValue(x.getParameters().get(2));
            }
        }
        if ("chr".equalsIgnoreCase(methodName) && x.getParameters().size() == 1 && (firstResult = WallVisitorUtils.getValue(first = x.getParameters().get(0))) instanceof Number) {
            int intValue = ((Number)firstResult).intValue();
            char ch = (char)intValue;
            return "" + ch;
        }
        if ("concat".equalsIgnoreCase(methodName)) {
            StringBuffer buf = new StringBuffer();
            for (SQLExpr expr : x.getParameters()) {
                Object value = WallVisitorUtils.getValue(expr);
                if (value == null) {
                    return null;
                }
                buf.append(value.toString());
            }
            return buf.toString();
        }
        return null;
    }

    public static boolean isSimpleCountTableSource(SQLTableSource tableSource) {
        if (!(tableSource instanceof SQLSubqueryTableSource)) {
            return false;
        }
        SQLSubqueryTableSource subQuery = (SQLSubqueryTableSource)tableSource;
        return WallVisitorUtils.isSimpleCountTableSource(subQuery.getSelect());
    }

    public static boolean isSimpleCountTableSource(SQLSelect select) {
        SQLSelectQuery query = select.getQuery();
        if (query instanceof SQLSelectQueryBlock) {
            SQLExpr selectItemExpr;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            boolean allawTrueWhere = false;
            if (queryBlock.getWhere() == null) {
                allawTrueWhere = true;
            } else {
                Object whereValue = WallVisitorUtils.getValue(queryBlock.getWhere());
                if (whereValue == Boolean.TRUE) {
                    allawTrueWhere = true;
                } else if (whereValue == Boolean.FALSE) {
                    return false;
                }
            }
            boolean simpleCount = false;
            if (queryBlock.getSelectList().size() == 1 && (selectItemExpr = queryBlock.getSelectList().get(0).getExpr()) instanceof SQLAggregateExpr && ((SQLAggregateExpr)selectItemExpr).getMethodName().equalsIgnoreCase("COUNT")) {
                simpleCount = true;
            }
            if (allawTrueWhere && simpleCount) {
                return true;
            }
        }
        return false;
    }

    public static void checkFunction(WallVisitor visitor, SQLMethodInvokeExpr x) {
        WallVisitorUtils.checkSchema(visitor, x.getOwner());
        if (!visitor.getConfig().isFunctionCheck()) {
            return;
        }
        String methodName = x.getMethodName();
        if (visitor.getConfig().isPermitFunction(methodName.toLowerCase())) {
            WallVisitorUtils.addViolation(visitor, x);
        }
    }

    private static void checkSchema(WallVisitor visitor, SQLExpr x) {
        if (x instanceof SQLName) {
            String owner = ((SQLName)x).getSimleName();
            owner = WallVisitorUtils.form(owner);
            if (visitor.getConfig().isPermitSchema(owner)) {
                WallVisitorUtils.addViolation(visitor, x);
            }
            if (visitor.getConfig().isPermitObjects(owner)) {
                WallVisitorUtils.addViolation(visitor, x);
            }
        }
        if (x instanceof SQLPropertyExpr) {
            WallVisitorUtils.checkSchema(visitor, ((SQLPropertyExpr)x).getOwner());
        }
    }

    public static void check(WallVisitor visitor, SQLExprTableSource x) {
        String tableName;
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLPropertyExpr) {
            WallVisitorUtils.checkSchema(visitor, ((SQLPropertyExpr)expr).getOwner());
        }
        if (expr instanceof SQLName && visitor.isPermitTable(tableName = ((SQLName)expr).getSimleName())) {
            WallVisitorUtils.addViolation(visitor, x);
        }
    }

    private static void addViolation(WallVisitor visitor, SQLObject x) {
        visitor.getViolations().add(new IllegalSQLObjectViolation(visitor.toSQL(x)));
    }

    public static void checkUnion(WallVisitor visitor, SQLUnionQuery x) {
        if (!visitor.getConfig().isSelectUnionCheck()) {
            return;
        }
        if (WallVisitorUtils.queryBlockFromIsNull(x.getLeft()) || WallVisitorUtils.queryBlockFromIsNull(x.getRight())) {
            WallVisitorUtils.addViolation(visitor, x);
        }
    }

    public static boolean queryBlockFromIsNull(SQLSelectQuery query) {
        if (query instanceof SQLSelectQueryBlock) {
            SQLSelectQuery subQuery;
            SQLExpr fromExpr;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            SQLTableSource from = queryBlock.getFrom();
            if (from == null) {
                return true;
            }
            if (from instanceof SQLExprTableSource && (fromExpr = ((SQLExprTableSource)from).getExpr()) instanceof SQLName) {
                String name = fromExpr.toString();
                if ((name = WallVisitorUtils.form(name)).equalsIgnoreCase("DUAL")) {
                    return true;
                }
            }
            if (queryBlock.getSelectList().size() == 1 && queryBlock.getSelectList().get(0).getExpr() instanceof SQLAllColumnExpr && from instanceof SQLSubqueryTableSource && WallVisitorUtils.queryBlockFromIsNull(subQuery = ((SQLSubqueryTableSource)from).getSelect().getQuery())) {
                return true;
            }
            boolean allIsConst = true;
            for (SQLSelectItem item : queryBlock.getSelectList()) {
                if (WallVisitorUtils.getValue(item.getExpr()) != null) continue;
                allIsConst = false;
                break;
            }
            if (allIsConst) {
                return true;
            }
        }
        return false;
    }

    public static String form(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.startsWith("`") && name.endsWith("`")) {
            name = name.substring(1, name.length() - 1);
        }
        name = name.toLowerCase();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadResource(Set<String> names, String resource) {
        try {
            Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources(resource);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                InputStream in = null;
                BufferedReader reader = null;
                try {
                    String line;
                    in = url.openStream();
                    reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        line = line.toLowerCase();
                        names.add(line);
                    }
                    url.openStream();
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(reader);
                    JdbcUtils.close(in);
                    throw throwable;
                    return;
                }
                JdbcUtils.close(reader);
                JdbcUtils.close(in);
            }
        }
        catch (IOException e) {
            LOG.error("load oracle permit tables errror", e);
        }
    }
}

