/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy.jdbc;

import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.proxy.jdbc.WrapperProxyImpl;
import com.alibaba.druid.stat.JdbcSqlStat;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class ResultSetProxyImpl
extends WrapperProxyImpl
implements ResultSetProxy {
    private final ResultSet resultSet;
    private final StatementProxy statement;
    private final String sql;
    protected int cursorIndex = 0;
    protected int fetchRowCount = 0;
    protected long constructNano;
    protected final JdbcSqlStat sqlStat;
    private int closeCount = 0;
    private long readStringLength = 0L;
    private long readBytesLength = 0L;
    private int openInputStreamCount = 0;
    private int openReaderCount = 0;
    private FilterChainImpl filterChain = null;

    public ResultSetProxyImpl(StatementProxy statement, ResultSet resultSet, long id, String sql) {
        super(resultSet, id);
        this.statement = statement;
        this.resultSet = resultSet;
        this.sql = sql;
        this.sqlStat = this.statement.getSqlStat();
    }

    @Override
    public long getConstructNano() {
        return this.constructNano;
    }

    @Override
    public void setConstructNano(long constructNano) {
        this.constructNano = constructNano;
    }

    @Override
    public void setConstructNano() {
        if (this.constructNano <= 0L) {
            this.constructNano = System.nanoTime();
        }
    }

    @Override
    public int getCursorIndex() {
        return this.cursorIndex;
    }

    @Override
    public int getFetchRowCount() {
        return this.fetchRowCount;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public JdbcSqlStat getSqlStat() {
        return this.sqlStat;
    }

    @Override
    public ResultSet getResultSetRaw() {
        return this.resultSet;
    }

    @Override
    public StatementProxy getStatementProxy() {
        return this.statement;
    }

    @Override
    public FilterChainImpl createChain() {
        FilterChainImpl chain = this.filterChain;
        if (chain == null) {
            chain = new FilterChainImpl(this.statement.getConnectionProxy().getDirectDataSource());
        } else {
            this.filterChain = null;
        }
        return chain;
    }

    public void recycleFilterChain(FilterChainImpl chain) {
        chain.reset();
        this.filterChain = chain;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_absolute(this, row);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public void afterLast() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_afterLast(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public void beforeFirst() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_beforeFirst(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_cancelRowUpdates(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public void clearWarnings() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_clearWarnings(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public void close() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_close(this);
        ++this.closeCount;
        this.recycleFilterChain(chain);
    }

    @Override
    public void deleteRow() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_deleteRow(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.resultSet_findColumn(this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean first() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_first(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Array value = chain.resultSet_getArray((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Array value = chain.resultSet_getArray((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        InputStream value = chain.resultSet_getAsciiStream((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        InputStream value = chain.resultSet_getAsciiStream((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        BigDecimal value = chain.resultSet_getBigDecimal((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        BigDecimal value = chain.resultSet_getBigDecimal((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        FilterChainImpl chain = this.createChain();
        BigDecimal value = chain.resultSet_getBigDecimal((ResultSetProxy)this, columnIndex, scale);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        FilterChainImpl chain = this.createChain();
        BigDecimal value = chain.resultSet_getBigDecimal((ResultSetProxy)this, columnLabel, scale);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        InputStream value = chain.resultSet_getBinaryStream((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        InputStream value = chain.resultSet_getBinaryStream((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Blob value = chain.resultSet_getBlob((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Blob value = chain.resultSet_getBlob((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_getBoolean((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_getBoolean((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        byte value = chain.resultSet_getByte((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        byte value = chain.resultSet_getByte((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        byte[] value = chain.resultSet_getBytes((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        byte[] value = chain.resultSet_getBytes((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Reader value = chain.resultSet_getCharacterStream((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Reader value = chain.resultSet_getCharacterStream((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Clob value = chain.resultSet_getClob((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Clob value = chain.resultSet_getClob((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getConcurrency() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.resultSet_getConcurrency(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public String getCursorName() throws SQLException {
        FilterChainImpl chain = this.createChain();
        String value = chain.resultSet_getCursorName(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Date value = chain.resultSet_getDate((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Date value = chain.resultSet_getDate((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Date value = chain.resultSet_getDate((ResultSetProxy)this, columnIndex, cal);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Date value = chain.resultSet_getDate((ResultSetProxy)this, columnLabel, cal);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        double value = chain.resultSet_getDouble((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        double value = chain.resultSet_getDouble((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.resultSet_getFetchDirection(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getFetchSize() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.resultSet_getFetchSize(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        float value = chain.resultSet_getFloat((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        float value = chain.resultSet_getFloat((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getHoldability() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.resultSet_getHoldability(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.resultSet_getInt((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.resultSet_getInt((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        long value = chain.resultSet_getLong((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        long value = chain.resultSet_getLong((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        FilterChainImpl chain = this.createChain();
        ResultSetMetaData value = chain.resultSet_getMetaData(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Reader value = chain.resultSet_getNCharacterStream((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Reader value = chain.resultSet_getNCharacterStream((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        NClob value = chain.resultSet_getNClob((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        NClob value = chain.resultSet_getNClob((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        String value = chain.resultSet_getNString((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        String value = chain.resultSet_getNString((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Object value = chain.resultSet_getObject((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Object value = chain.resultSet_getObject((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Object value = chain.resultSet_getObject((ResultSetProxy)this, columnIndex, map);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Object value = chain.resultSet_getObject((ResultSetProxy)this, columnLabel, map);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Ref value = chain.resultSet_getRef((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Ref value = chain.resultSet_getRef((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getRow() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.resultSet_getRow(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        RowId value = chain.resultSet_getRowId((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        RowId value = chain.resultSet_getRowId((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        SQLXML value = chain.resultSet_getSQLXML((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        SQLXML value = chain.resultSet_getSQLXML((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        short value = chain.resultSet_getShort((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        short value = chain.resultSet_getShort((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Statement getStatement() throws SQLException {
        FilterChainImpl chain = this.createChain();
        Statement stmt = chain.resultSet_getStatement(this);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        String value = chain.resultSet_getString((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        String value = chain.resultSet_getString((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Time value = chain.resultSet_getTime((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Time value = chain.resultSet_getTime((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Time value = chain.resultSet_getTime((ResultSetProxy)this, columnIndex, cal);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Time value = chain.resultSet_getTime((ResultSetProxy)this, columnLabel, cal);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Timestamp value = chain.resultSet_getTimestamp((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Timestamp value = chain.resultSet_getTimestamp((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Timestamp value = chain.resultSet_getTimestamp((ResultSetProxy)this, columnIndex, cal);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Timestamp value = chain.resultSet_getTimestamp((ResultSetProxy)this, columnLabel, cal);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getType() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.resultSet_getType(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        URL value = chain.resultSet_getURL((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        URL value = chain.resultSet_getURL((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        InputStream value = chain.resultSet_getUnicodeStream((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        InputStream value = chain.resultSet_getUnicodeStream((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        FilterChainImpl chain = this.createChain();
        SQLWarning value = chain.resultSet_getWarnings(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public void insertRow() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_insertRow(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_isAfterLast(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_isBeforeFirst(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean isClosed() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_isClosed(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean isFirst() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_isFirst(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean isLast() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_isLast(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean last() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_last(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_moveToCurrentRow(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_moveToInsertRow(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public boolean next() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean moreRows = chain.resultSet_next(this);
        if (moreRows) {
            ++this.cursorIndex;
            if (this.cursorIndex > this.fetchRowCount) {
                this.fetchRowCount = this.cursorIndex;
            }
        }
        this.recycleFilterChain(chain);
        return moreRows;
    }

    @Override
    public boolean previous() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean moreRows = chain.resultSet_previous(this);
        if (moreRows) {
            --this.cursorIndex;
        }
        this.recycleFilterChain(chain);
        return moreRows;
    }

    @Override
    public void refreshRow() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_refreshRow(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_relative(this, rows);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_rowDeleted(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_rowInserted(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.resultSet_rowUpdated(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_setFetchDirection(this, direction);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_setFetchSize(this, rows);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateArray((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateArray((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateAsciiStream((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateAsciiStream((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateAsciiStream((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateAsciiStream((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateAsciiStream((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateAsciiStream((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBigDecimal((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBigDecimal((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBinaryStream((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBinaryStream((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBinaryStream((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBinaryStream((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBinaryStream((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBinaryStream((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBlob((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBlob((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBlob((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBlob((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBlob((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBlob((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBoolean((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBoolean((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateByte((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateByte((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBytes((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateBytes((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateCharacterStream((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateCharacterStream((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateCharacterStream((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateCharacterStream((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateCharacterStream((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateCharacterStream((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateClob((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateClob((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateClob((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateClob((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateClob((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateClob((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateDate((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateDate((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateDouble((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateDouble((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateFloat((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateFloat((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateInt((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateInt((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateLong((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateLong((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNCharacterStream((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNCharacterStream((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNCharacterStream((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNCharacterStream((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNClob((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNClob((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNClob((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNClob((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNClob((ResultSetProxy)this, columnIndex, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNClob((ResultSetProxy)this, columnLabel, x, length);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNString((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNString((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNull((ResultSetProxy)this, columnIndex);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateNull((ResultSetProxy)this, columnLabel);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateObject((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateObject((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateObject((ResultSetProxy)this, columnIndex, x, scaleOrLength);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateObject((ResultSetProxy)this, columnLabel, x, scaleOrLength);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateRef((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateRef((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateRow() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateRow(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateRowId((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateRowId((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateSQLXML((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateSQLXML((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateShort((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateShort((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateString((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateString((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateTime((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateTime((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateTimestamp((ResultSetProxy)this, columnIndex, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.resultSet_updateTimestamp((ResultSetProxy)this, columnLabel, x);
        this.recycleFilterChain(chain);
    }

    @Override
    public boolean wasNull() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean result = chain.resultSet_wasNull(this);
        this.recycleFilterChain(chain);
        return result;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getCloseCount() {
        return this.closeCount;
    }

    @Override
    public void addReadStringLength(int length) {
        this.readStringLength += (long)length;
    }

    @Override
    public long getReadStringLength() {
        return this.readStringLength;
    }

    @Override
    public void addReadBytesLength(int length) {
        this.readBytesLength += (long)length;
    }

    @Override
    public long getReadBytesLength() {
        return this.readBytesLength;
    }

    @Override
    public void incrementOpenInputStreamCount() {
        ++this.openInputStreamCount;
    }

    @Override
    public int getOpenInputStreamCount() {
        return this.openInputStreamCount;
    }

    @Override
    public void incrementOpenReaderCount() {
        ++this.openReaderCount;
    }

    @Override
    public int getOpenReaderCount() {
        return this.openReaderCount;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == ResultSetProxy.class || iface == ResultSetProxyImpl.class) {
            return (T)this;
        }
        return super.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == ResultSetProxy.class || iface == ResultSetProxyImpl.class) {
            return true;
        }
        return super.isWrapperFor(iface);
    }
}

