/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.visitor;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLStartTransactionStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerOutput;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.ast.expr.SQLServerObjectReferenceExpr;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerExecStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerRollbackStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerSetStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerSetTransactionIsolationLevelStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerWaitForStatement;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class SQLServerOutputVisitor
extends SQLASTOutputVisitor
implements SQLServerASTVisitor {
    public SQLServerOutputVisitor(Appendable appender) {
        super(appender, "sqlserver");
    }

    public SQLServerOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = "sqlserver";
    }

    @Override
    public boolean visit(SQLServerSelectQueryBlock x) {
        this.print0(this.ucase ? "SELECT " : "select ");
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (3 == x.getDistionOption()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        if (x.getTop() != null) {
            x.getTop().accept(this);
            this.print(' ');
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        this.printFetchFirst(x);
        return false;
    }

    @Override
    public void endVisit(SQLServerSelectQueryBlock x) {
    }

    @Override
    public boolean visit(SQLServerTop x) {
        this.print0(this.ucase ? "TOP " : "top ");
        boolean paren = false;
        if (x.getParent() instanceof SQLServerUpdateStatement || x.getParent() instanceof SQLServerInsertStatement) {
            paren = true;
            this.print('(');
        }
        x.getExpr().accept(this);
        if (paren) {
            this.print(')');
        }
        if (x.isPercent()) {
            this.print0(this.ucase ? " PERCENT" : " percent");
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerTop x) {
    }

    @Override
    public boolean visit(SQLServerObjectReferenceExpr x) {
        this.print0(x.toString());
        return false;
    }

    @Override
    public void endVisit(SQLServerObjectReferenceExpr x) {
    }

    @Override
    public boolean visit(SQLServerInsertStatement x) {
        this.print0(this.ucase ? "INSERT " : "insert ");
        if (x.getTop() != null) {
            x.getTop().setParent(x);
            x.getTop().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "INTO " : "into ");
        x.getTableSource().accept(this);
        this.printInsertColumns(x.getColumns());
        if (x.getOutput() != null) {
            this.println();
            x.getOutput().setParent(x);
            x.getOutput().accept(this);
        }
        if (x.getValuesList().size() != 0) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            int size = x.getValuesList().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(',');
                    this.println();
                }
                x.getValuesList().get(i).accept(this);
            }
        }
        if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        if (x.isDefaultValues()) {
            this.print0(this.ucase ? " DEFAULT VALUES" : " default values");
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerInsertStatement x) {
    }

    @Override
    public boolean visit(SQLServerUpdateStatement x) {
        this.print0(this.ucase ? "UPDATE " : "update ");
        if (x.getTop() != null) {
            x.getTop().setParent(x);
            x.getTop().accept(this);
            this.print(' ');
        }
        x.getTableSource().accept(this);
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getOutput() != null) {
            this.println();
            x.getOutput().setParent(x);
            x.getOutput().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().setParent(x);
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            this.incrementIndent();
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerUpdateStatement x) {
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        this.printTableSourceExpr(x.getExpr());
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print0(this.ucase ? " WITH (" : " with (");
            this.printAndAccept(x.getHints(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        x.getName().accept(this);
        if (x.getDataType() != null) {
            this.print(' ');
            x.getDataType().accept(this);
        }
        if (x.getDefaultExpr() != null) {
            this.visitColumnDefault(x);
        }
        for (SQLColumnConstraint item : x.getConstraints()) {
            this.print(' ');
            item.accept(this);
        }
        if (x.getIdentity() != null) {
            this.print(' ');
            x.getIdentity().accept(this);
        }
        if (x.getEnable() != null && x.getEnable().booleanValue()) {
            this.print0(this.ucase ? " ENABLE" : " enable");
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerExecStatement x) {
        SQLName moduleName;
        this.print0(this.ucase ? "EXEC " : "exec ");
        SQLName returnStatus = x.getReturnStatus();
        if (returnStatus != null) {
            returnStatus.accept(this);
            this.print0(" = ");
        }
        if ((moduleName = x.getModuleName()) != null) {
            moduleName.accept(this);
            this.print(' ');
        } else {
            this.print0(" (");
        }
        this.printAndAccept(x.getParameters(), ", ");
        if (moduleName == null) {
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerExecStatement x) {
    }

    @Override
    public boolean visit(SQLServerSetTransactionIsolationLevelStatement x) {
        this.print0(this.ucase ? "SET TRANSACTION ISOLATION LEVEL " : "set transaction isolation level ");
        this.print0(x.getLevel());
        return false;
    }

    @Override
    public void endVisit(SQLServerSetTransactionIsolationLevelStatement x) {
    }

    @Override
    public boolean visit(SQLServerSetStatement x) {
        this.print0(this.ucase ? "SET " : "set ");
        SQLAssignItem item = x.getItem();
        item.getTarget().accept(this);
        this.print(' ');
        item.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(SQLServerSetStatement x) {
    }

    @Override
    public boolean visit(SQLServerOutput x) {
        this.print0(this.ucase ? "OUTPUT " : "output ");
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept(this);
            if (x.getColumns().size() > 0) {
                this.incrementIndent();
                this.println();
                this.print('(');
                int size = x.getColumns().size();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        if (i % 5 == 0) {
                            this.println();
                        }
                        this.print0(", ");
                    }
                    x.getColumns().get(i).accept(this);
                }
                this.print(')');
                this.decrementIndent();
            }
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(SQLServerOutput x) {
    }

    @Override
    public boolean visit(SQLBlockStatement x) {
        this.print0(this.ucase ? "BEGIN" : "begin");
        this.incrementIndent();
        this.println();
        int size = x.getStatementList().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement stmt = x.getStatementList().get(i);
            stmt.setParent(x);
            stmt.accept(this);
            this.print(';');
        }
        this.decrementIndent();
        this.println();
        this.print0(this.ucase ? "END" : "end");
        return false;
    }

    @Override
    protected void printGrantOn(SQLGrantStatement x) {
        if (x.getOn() != null) {
            this.print0(this.ucase ? " ON " : " on ");
            if (x.getObjectType() != null) {
                this.print0(x.getObjectType().name());
                this.print0("::");
            }
            x.getOn().accept(this);
        }
    }

    @Override
    public boolean visit(SQLSelect x) {
        super.visit(x);
        if (x.isForBrowse()) {
            this.println();
            this.print0(this.ucase ? "FOR BROWSE" : "for browse");
        }
        if (x.getForXmlOptionsSize() > 0) {
            this.println();
            this.print0(this.ucase ? "FOR XML " : "for xml ");
            for (int i = 0; i < x.getForXmlOptions().size(); ++i) {
                if (i == 0) continue;
                this.print0(", ");
                this.print0(x.getForXmlOptions().get(i));
            }
        }
        if (x.getXmlPath() != null) {
            this.println();
            this.print0(this.ucase ? "FOR XML " : "for xml ");
            x.getXmlPath().accept(this);
        }
        if (x.getOffset() != null) {
            this.println();
            this.print0(this.ucase ? "OFFSET " : "offset ");
            x.getOffset().accept(this);
            this.print0(this.ucase ? " ROWS" : " rows");
            if (x.getRowCount() != null) {
                this.print0(this.ucase ? " FETCH NEXT " : " fetch next ");
                x.getRowCount().accept(this);
                this.print0(this.ucase ? " ROWS ONLY" : " rows only");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCommitStatement x) {
        this.print0(this.ucase ? "COMMIT" : "commit");
        if (x.isWork()) {
            this.print0(this.ucase ? " WORK" : " work");
        } else {
            this.print0(this.ucase ? " TRANSACTION" : " transaction");
            if (x.getTransactionName() != null) {
                this.print(' ');
                x.getTransactionName().accept(this);
            }
            if (x.getDelayedDurability() != null) {
                this.print0(this.ucase ? " WITH ( DELAYED_DURABILITY = " : " with ( delayed_durability = ");
                x.getDelayedDurability().accept(this);
                this.print0(" )");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerRollbackStatement x) {
        this.print0(this.ucase ? "ROLLBACK" : "rollback");
        if (x.isWork()) {
            this.print0(this.ucase ? " WORK" : " work");
        } else {
            this.print0(this.ucase ? " TRANSACTION" : " transaction");
            if (x.getName() != null) {
                this.print(' ');
                x.getName().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerRollbackStatement x) {
    }

    @Override
    public boolean visit(SQLServerWaitForStatement x) {
        this.print0(this.ucase ? "WAITFOR" : "waitfor");
        if (x.getDelay() != null) {
            this.print0(this.ucase ? " DELAY " : " delay ");
            x.getDelay().accept(this);
        } else if (x.getTime() != null) {
            this.print0(this.ucase ? " TIME " : " time ");
            x.getTime().accept(this);
        }
        if (x.getStatement() != null) {
            this.print0(this.ucase ? " DELAY " : " delay ");
            x.getStatement().accept(this);
        }
        if (x.getTimeout() != null) {
            this.print0(this.ucase ? " ,TIMEOUT " : " ,timeout ");
            x.getTimeout().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerWaitForStatement x) {
    }

    @Override
    public boolean visit(SQLServerExecStatement.SQLServerParameter x) {
        x.getExpr().accept(this);
        if (x.getType()) {
            this.print0(this.ucase ? " OUT" : " out");
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerExecStatement.SQLServerParameter x) {
    }

    @Override
    public boolean visit(SQLStartTransactionStatement x) {
        this.print0(this.ucase ? "BEGIN TRANSACTION" : "begin transaction");
        if (x.getName() != null) {
            this.print(' ');
            x.getName().accept(this);
        }
        return false;
    }
}

