/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ExportParameterVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlExportParameterVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleExportParameterVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGExportParameterVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.MSSQLServerExportParameterVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterizedOutputVisitor;
import java.util.ArrayList;
import java.util.List;

public final class ExportParameterVisitorUtils {
    private ExportParameterVisitorUtils() {
    }

    public static ExportParameterVisitor createExportParameterVisitor(Appendable out, String dbType) {
        if ("mysql".equals(dbType)) {
            return new MySqlExportParameterVisitor(out);
        }
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleExportParameterVisitor(out);
        }
        if ("db2".equals(dbType)) {
            return new DB2ExportParameterVisitor(out);
        }
        if ("mariadb".equals(dbType)) {
            return new MySqlExportParameterVisitor(out);
        }
        if ("h2".equals(dbType)) {
            return new MySqlExportParameterVisitor(out);
        }
        if ("postgresql".equals(dbType) || "edb".equals(dbType)) {
            return new PGExportParameterVisitor(out);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new MSSQLServerExportParameterVisitor(out);
        }
        return new ExportParameterizedOutputVisitor(out);
    }

    public static boolean exportParamterAndAccept(List<Object> parameters, List<SQLExpr> list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            SQLExpr param = list.get(i);
            SQLExpr result = ExportParameterVisitorUtils.exportParameter(parameters, param);
            if (result == param) continue;
            list.set(i, result);
        }
        return false;
    }

    public static SQLExpr exportParameter(List<Object> parameters, SQLExpr param) {
        ArrayList<Object> value = null;
        boolean replace = false;
        if (param instanceof SQLCharExpr) {
            value = ((SQLCharExpr)param).getText();
            replace = true;
        }
        if (param instanceof SQLBooleanExpr) {
            value = ((SQLBooleanExpr)param).getValue();
            replace = true;
        }
        if (param instanceof SQLNumericLiteralExpr) {
            value = ((SQLNumericLiteralExpr)param).getNumber();
            replace = true;
        }
        if (param instanceof SQLHexExpr) {
            value = (ArrayList<Object>)((SQLHexExpr)param).toBytes();
            replace = true;
        }
        if (replace) {
            List mergedList;
            SQLObject parent = param.getParent();
            if (parent != null && (mergedList = (List)parent.getAttribute("parameterized.mergedList")) != null) {
                ArrayList<Object> mergedListParams = new ArrayList<Object>(mergedList.size() + 1);
                for (int i = 0; i < mergedList.size(); ++i) {
                    SQLObject item = (SQLObject)mergedList.get(i);
                    if (!(item instanceof SQLBinaryOpExpr)) continue;
                    SQLBinaryOpExpr binaryOpItem = (SQLBinaryOpExpr)item;
                    ExportParameterVisitorUtils.exportParameter(mergedListParams, binaryOpItem.getRight());
                }
                if (mergedListParams.size() > 0) {
                    mergedListParams.add(0, value);
                    value = mergedListParams;
                }
            }
            parameters.add(value);
            return new SQLVariantRefExpr("?");
        }
        return param;
    }

    public static void exportParameter(List<Object> parameters, SQLBinaryOpExpr x) {
        SQLExpr rightResult;
        if (x.getLeft() instanceof SQLLiteralExpr && x.getRight() instanceof SQLLiteralExpr && x.getOperator().isRelational()) {
            return;
        }
        SQLExpr leftResult = ExportParameterVisitorUtils.exportParameter(parameters, x.getLeft());
        if (leftResult != x.getLeft()) {
            x.setLeft(leftResult);
        }
        if ((rightResult = ExportParameterVisitorUtils.exportParameter(parameters, x.getRight())) != x.getRight()) {
            x.setRight(rightResult);
        }
    }

    public static void exportParameter(List<Object> parameters, SQLBetweenExpr x) {
        SQLExpr result = ExportParameterVisitorUtils.exportParameter(parameters, x.getBeginExpr());
        if (result != x.getBeginExpr()) {
            x.setBeginExpr(result);
        }
        if ((result = ExportParameterVisitorUtils.exportParameter(parameters, x.getEndExpr())) != x.getBeginExpr()) {
            x.setEndExpr(result);
        }
    }
}

