/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.selector;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.ha.HighAvailableDataSource;
import com.alibaba.druid.pool.ha.selector.DataSourceSelector;
import com.alibaba.druid.pool.ha.selector.DataSourceSelectorEnum;
import com.alibaba.druid.pool.ha.selector.RandomDataSourceRecoverThread;
import com.alibaba.druid.pool.ha.selector.RandomDataSourceValidateThread;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;

public class RandomDataSourceSelector
implements DataSourceSelector {
    private static final String PROP_PREFIX = "druid.ha.random.";
    public static final String PROP_CHECKING_INTERVAL = "druid.ha.random.checkingIntervalSeconds";
    public static final String PROP_RECOVERY_INTERVAL = "druid.ha.random.recoveryIntervalSeconds";
    public static final String PROP_VALIDATION_SLEEP = "druid.ha.random.validationSleepSeconds";
    public static final String PROP_BLACKLIST_THRESHOLD = "druid.ha.random.blacklistThreshold";
    private static final Log LOG = LogFactory.getLog(RandomDataSourceSelector.class);
    private Random random = new Random();
    private List<DataSource> blacklist = new CopyOnWriteArrayList<DataSource>();
    private HighAvailableDataSource highAvailableDataSource;
    private RandomDataSourceValidateThread validateThread;
    private RandomDataSourceRecoverThread recoverThread;
    private Thread runningValidateThread;
    private Thread runningRecoverThread;
    private int checkingIntervalSeconds = 10;
    private int recoveryIntervalSeconds = 120;
    private int validationSleepSeconds;
    private int blacklistThreshold = 3;

    public RandomDataSourceSelector(HighAvailableDataSource highAvailableDataSource) {
        this.highAvailableDataSource = highAvailableDataSource;
    }

    @Override
    public void init() {
        if (this.highAvailableDataSource == null) {
            LOG.warn("highAvailableDataSource is NULL!");
            return;
        }
        if (!this.highAvailableDataSource.isTestOnBorrow() && !this.highAvailableDataSource.isTestOnReturn()) {
            this.loadProperties();
            this.initThreads();
        } else {
            LOG.info("testOnBorrow or testOnReturn has been set to true, ignore validateThread");
        }
    }

    @Override
    public void destroy() {
        if (this.runningValidateThread != null) {
            this.runningValidateThread.interrupt();
            this.validateThread.setSelector(null);
        }
        if (this.runningRecoverThread != null) {
            this.runningRecoverThread.interrupt();
            this.recoverThread.setSelector(null);
        }
    }

    @Override
    public String getName() {
        return DataSourceSelectorEnum.RANDOM.getName();
    }

    @Override
    public DataSource get() {
        Map<String, DataSource> dataSourceMap = this.getDataSourceMap();
        if (dataSourceMap == null || dataSourceMap.isEmpty()) {
            return null;
        }
        Collection<DataSource> targetDataSourceSet = this.removeBlackList(dataSourceMap);
        this.removeBusyDataSource(targetDataSourceSet);
        DataSource dataSource = this.getRandomDataSource(targetDataSourceSet);
        return dataSource;
    }

    @Override
    public void setTarget(String name) {
    }

    public Map<String, DataSource> getFullDataSourceMap() {
        if (this.highAvailableDataSource != null) {
            return this.highAvailableDataSource.getDataSourceMap();
        }
        return new HashMap<String, DataSource>();
    }

    public Map<String, DataSource> getDataSourceMap() {
        if (this.highAvailableDataSource != null) {
            return this.highAvailableDataSource.getAvailableDataSourceMap();
        }
        return new HashMap<String, DataSource>();
    }

    public List<DataSource> getBlacklist() {
        return this.blacklist;
    }

    public boolean containInBlacklist(DataSource dataSource) {
        return dataSource != null && this.blacklist.contains(dataSource);
    }

    public void addBlacklist(DataSource dataSource) {
        if (dataSource != null && !this.blacklist.contains(dataSource)) {
            this.blacklist.add(dataSource);
            if (dataSource instanceof DruidDataSource) {
                ((DruidDataSource)dataSource).setTestOnReturn(true);
            }
        }
    }

    public void removeBlacklist(DataSource dataSource) {
        if (this.containInBlacklist(dataSource)) {
            this.blacklist.remove(dataSource);
            if (dataSource instanceof DruidDataSource) {
                ((DruidDataSource)dataSource).setTestOnReturn(this.highAvailableDataSource.isTestOnReturn());
            }
        }
    }

    private void loadProperties() {
        this.checkingIntervalSeconds = this.loadInteger(PROP_CHECKING_INTERVAL, this.checkingIntervalSeconds);
        this.recoveryIntervalSeconds = this.loadInteger(PROP_RECOVERY_INTERVAL, this.recoveryIntervalSeconds);
        this.validationSleepSeconds = this.loadInteger(PROP_VALIDATION_SLEEP, this.validationSleepSeconds);
        this.blacklistThreshold = this.loadInteger(PROP_BLACKLIST_THRESHOLD, this.blacklistThreshold);
    }

    private int loadInteger(String name, int defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        Properties properties = this.highAvailableDataSource.getConnectProperties();
        int value = defaultValue;
        try {
            if (properties.containsKey(name)) {
                value = Integer.parseInt(properties.getProperty(name));
            }
        }
        catch (Exception e) {
            LOG.error("Exception occurred while parsing " + name, e);
        }
        return value;
    }

    private void initThreads() {
        if (this.validateThread == null) {
            this.validateThread = new RandomDataSourceValidateThread(this);
            this.validateThread.setCheckingIntervalSeconds(this.checkingIntervalSeconds);
            this.validateThread.setValidationSleepSeconds(this.validationSleepSeconds);
            this.validateThread.setBlacklistThreshold(this.blacklistThreshold);
        } else {
            this.validateThread.setSelector(this);
        }
        if (this.runningValidateThread != null) {
            this.runningValidateThread.interrupt();
        }
        this.runningValidateThread = new Thread((Runnable)this.validateThread, "RandomDataSourceSelector-validate-thread");
        this.runningValidateThread.start();
        if (this.recoverThread == null) {
            this.recoverThread = new RandomDataSourceRecoverThread(this);
            this.recoverThread.setRecoverIntervalSeconds(this.recoveryIntervalSeconds);
            this.recoverThread.setValidationSleepSeconds(this.validationSleepSeconds);
        } else {
            this.recoverThread.setSelector(this);
        }
        if (this.runningRecoverThread != null) {
            this.runningRecoverThread.interrupt();
        }
        this.runningRecoverThread = new Thread((Runnable)this.recoverThread, "RandomDataSourceSelector-recover-thread");
        this.runningRecoverThread.start();
    }

    private Collection<DataSource> removeBlackList(Map<String, DataSource> dataSourceMap) {
        Collection<DataSource> dataSourceSet;
        if (this.blacklist == null || this.blacklist.isEmpty() || this.blacklist.size() >= dataSourceMap.size()) {
            dataSourceSet = dataSourceMap.values();
        } else {
            dataSourceSet = new HashSet<DataSource>(dataSourceMap.values());
            for (DataSource b : this.blacklist) {
                dataSourceSet.remove(b);
            }
            LOG.info(this.blacklist.size() + " Blacklist DataSource removed, return " + dataSourceSet.size() + " DataSource(s).");
        }
        return dataSourceSet;
    }

    private void removeBusyDataSource(Collection<DataSource> dataSourceSet) {
        HashSet<DataSource> busyDataSourceSet = new HashSet<DataSource>();
        for (DataSource ds : dataSourceSet) {
            if (!(ds instanceof DruidDataSource) || ((DruidDataSource)ds).getPoolingCount() > 0) continue;
            busyDataSourceSet.add(ds);
        }
        if (!busyDataSourceSet.isEmpty() && busyDataSourceSet.size() < dataSourceSet.size()) {
            LOG.info("Busy DataSouces: " + busyDataSourceSet.size() + "/" + dataSourceSet.size());
            for (DataSource ds : busyDataSourceSet) {
                dataSourceSet.remove(ds);
            }
        }
    }

    private DataSource getRandomDataSource(Collection<DataSource> dataSourceSet) {
        DataSource[] dataSources = dataSourceSet.toArray(new DataSource[0]);
        if (dataSources != null && dataSources.length > 0) {
            return dataSources[this.random.nextInt(dataSourceSet.size())];
        }
        return null;
    }

    public HighAvailableDataSource getHighAvailableDataSource() {
        return this.highAvailableDataSource;
    }

    public RandomDataSourceValidateThread getValidateThread() {
        return this.validateThread;
    }

    public void setValidateThread(RandomDataSourceValidateThread validateThread) {
        this.validateThread = validateThread;
    }

    public RandomDataSourceRecoverThread getRecoverThread() {
        return this.recoverThread;
    }

    public void setRecoverThread(RandomDataSourceRecoverThread recoverThread) {
        this.recoverThread = recoverThread;
    }

    public int getCheckingIntervalSeconds() {
        return this.checkingIntervalSeconds;
    }

    public void setCheckingIntervalSeconds(int checkingIntervalSeconds) {
        this.checkingIntervalSeconds = checkingIntervalSeconds;
    }

    public int getRecoveryIntervalSeconds() {
        return this.recoveryIntervalSeconds;
    }

    public void setRecoveryIntervalSeconds(int recoveryIntervalSeconds) {
        this.recoveryIntervalSeconds = recoveryIntervalSeconds;
    }

    public int getValidationSleepSeconds() {
        return this.validationSleepSeconds;
    }

    public void setValidationSleepSeconds(int validationSleepSeconds) {
        this.validationSleepSeconds = validationSleepSeconds;
    }

    public int getBlacklistThreshold() {
        return this.blacklistThreshold;
    }

    public void setBlacklistThreshold(int blacklistThreshold) {
        this.blacklistThreshold = blacklistThreshold;
    }
}

