/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import com.alibaba.druid.pool.DruidDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxoolDataSource
implements DataSource,
ObjectFactory {
    private DruidDataSource druid = new DruidDataSource();
    private Properties delegateProperties = new Properties();

    public ProxoolDataSource() {
    }

    public ProxoolDataSource(String alias) {
        this.druid.setName(alias);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.druid.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.druid.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.druid.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.druid.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.druid.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.druid.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.druid.isWrapperFor(iface);
    }

    public Object getObjectInstance(Object refObject, Name name, Context context, Hashtable hashtable) throws Exception {
        if (!(refObject instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)refObject;
        this.populatePropertiesFromReference(reference);
        return this;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.druid.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.druid.getConnection(username, password);
    }

    public String getAlias() {
        return this.druid.getName();
    }

    public void setAlias(String alias) {
        this.druid.setName(alias);
    }

    public String getDriverUrl() {
        return this.druid.getUrl();
    }

    public void setDriverUrl(String url) {
        this.druid.setUrl(url);
    }

    public String getDriver() {
        return this.druid.getDriverClassName();
    }

    public void setDriver(String driver) {
        this.druid.setDriverClassName(driver);
    }

    public long getMaximumConnectionLifetime() {
        return Long.MAX_VALUE;
    }

    @Deprecated
    public void setMaximumConnectionLifetime(int maximumConnectionLifetime) {
    }

    @Deprecated
    public int getPrototypeCount() {
        return 0;
    }

    @Deprecated
    public void setPrototypeCount(int prototypeCount) {
    }

    public int getMinimumConnectionCount() {
        return this.druid.getMinIdle();
    }

    public void setMinimumConnectionCount(int minimumConnectionCount) {
        this.druid.setMinIdle(minimumConnectionCount);
    }

    public int getMaximumConnectionCount() {
        return this.druid.getMaxActive();
    }

    public void setMaximumConnectionCount(int maximumConnectionCount) {
        this.druid.setMaxActive(maximumConnectionCount);
    }

    public long getHouseKeepingSleepTime() {
        return this.druid.getTimeBetweenEvictionRunsMillis();
    }

    public void setHouseKeepingSleepTime(int houseKeepingSleepTime) {
        this.druid.setTimeBetweenEvictionRunsMillis((long)houseKeepingSleepTime);
    }

    public int getSimultaneousBuildThrottle() {
        return 0;
    }

    public void setSimultaneousBuildThrottle(int simultaneousBuildThrottle) {
    }

    public long getRecentlyStartedThreshold() {
        return 0L;
    }

    public void setRecentlyStartedThreshold(int recentlyStartedThreshold) {
    }

    public long getOverloadWithoutRefusalLifetime() {
        return 0L;
    }

    public void setOverloadWithoutRefusalLifetime(int overloadWithoutRefusalLifetime) {
    }

    public long getMaximumActiveTime() {
        return this.druid.getRemoveAbandonedTimeoutMillis();
    }

    public void setMaximumActiveTime(long maximumActiveTime) {
        this.druid.setRemoveAbandonedTimeoutMillis(maximumActiveTime);
    }

    public boolean isVerbose() {
        return false;
    }

    @Deprecated
    public void setVerbose(boolean verbose) {
    }

    public boolean isTrace() {
        return false;
    }

    @Deprecated
    public void setTrace(boolean trace) {
    }

    public String getStatistics() {
        return "";
    }

    public void setStatistics(String statistics) {
    }

    public String getStatisticsLogLevel() {
        return "";
    }

    public void setStatisticsLogLevel(String statisticsLogLevel) {
    }

    public String getFatalSqlExceptionsAsString() {
        return null;
    }

    @Deprecated
    public void setFatalSqlExceptionsAsString(String fatalSqlExceptionsAsString) {
    }

    public String getFatalSqlExceptionWrapperClass() {
        return null;
    }

    public void setFatalSqlExceptionWrapperClass(String fatalSqlExceptionWrapperClass) {
    }

    public String getHouseKeepingTestSql() {
        return this.druid.getValidationQuery();
    }

    public void setHouseKeepingTestSql(String houseKeepingTestSql) {
        this.druid.setValidationQuery(houseKeepingTestSql);
    }

    public String getUser() {
        return this.druid.getUsername();
    }

    public void setUser(String user) {
        this.druid.setUsername(user);
    }

    public String getPassword() {
        return this.druid.getPassword();
    }

    public void setPassword(String password) {
        this.druid.setPassword(password);
    }

    public boolean isJmx() {
        return true;
    }

    public void setJmx(boolean jmx) {
    }

    @Deprecated
    public String getJmxAgentId() {
        return "";
    }

    @Deprecated
    public void setJmxAgentId(String jmxAgentId) {
    }

    public boolean isTestBeforeUse() {
        return this.druid.isTestOnBorrow();
    }

    public void setTestBeforeUse(boolean testBeforeUse) {
        this.druid.setTestOnBorrow(testBeforeUse);
    }

    public boolean isTestAfterUse() {
        return this.druid.isTestOnReturn();
    }

    public void setTestAfterUse(boolean testAfterUse) {
        this.druid.setTestOnReturn(testAfterUse);
    }

    private void populatePropertiesFromReference(Reference reference) {
        RefAddr property = reference.get("proxool.alias");
        if (property != null) {
            this.setAlias(property.getContent().toString());
        }
        if ((property = reference.get("proxool.driver-class")) != null) {
            this.setDriver(property.getContent().toString());
        }
        if ((property = reference.get("proxool.fatal-sql-exception-wrapper-class")) != null) {
            this.setFatalSqlExceptionWrapperClass(property.getContent().toString());
        }
        if ((property = reference.get("proxool.house-keeping-sleep-time")) != null) {
            this.setHouseKeepingSleepTime(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.house-keeping-test-sql")) != null) {
            this.setHouseKeepingTestSql(property.getContent().toString());
        }
        if ((property = reference.get("proxool.maximum-connection-count")) != null) {
            this.setMaximumConnectionCount(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.maximum-connection-lifetime")) != null) {
            this.setMaximumConnectionLifetime(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.maximum-active-time")) != null) {
            this.setMaximumActiveTime(Long.valueOf(property.getContent().toString()).intValue());
        }
        if ((property = reference.get("proxool.minimum-connection-count")) != null) {
            this.setMinimumConnectionCount(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.overload-without-refusal-lifetime")) != null) {
            this.setOverloadWithoutRefusalLifetime(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("password")) != null) {
            this.setPassword(property.getContent().toString());
        }
        if ((property = reference.get("proxool.prototype-count")) != null) {
            this.setPrototypeCount(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.recently-started-threshold")) != null) {
            this.setRecentlyStartedThreshold(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.simultaneous-build-throttle")) != null) {
            this.setSimultaneousBuildThrottle(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.statistics")) != null) {
            this.setStatistics(property.getContent().toString());
        }
        if ((property = reference.get("proxool.statistics-log-level")) != null) {
            this.setStatisticsLogLevel(property.getContent().toString());
        }
        if ((property = reference.get("proxool.trace")) != null) {
            this.setTrace("true".equalsIgnoreCase(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.driver-url")) != null) {
            this.setDriverUrl(property.getContent().toString());
        }
        if ((property = reference.get("user")) != null) {
            this.setUser(property.getContent().toString());
        }
        if ((property = reference.get("proxool.verbose")) != null) {
            this.setVerbose("true".equalsIgnoreCase(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.jmx")) != null) {
            this.setJmx("true".equalsIgnoreCase(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.jmx-agent-id")) != null) {
            this.setJmxAgentId(property.getContent().toString());
        }
        if ((property = reference.get("proxool.test-before-use")) != null) {
            this.setTestBeforeUse("true".equalsIgnoreCase(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.test-after-use")) != null) {
            this.setTestAfterUse("true".equalsIgnoreCase(property.getContent().toString()));
        }
        Enumeration<RefAddr> e = reference.getAll();
        while (e.hasMoreElements()) {
            StringRefAddr stringRefAddr = (StringRefAddr)e.nextElement();
            String name = stringRefAddr.getType();
            String content = stringRefAddr.getContent().toString();
            if (name.indexOf("proxool.") == 0) continue;
            this.delegateProperties.put(name, content);
        }
    }

    public void setDelegateProperties(String properties) {
        StringTokenizer stOuter = new StringTokenizer(properties, ",");
        while (stOuter.hasMoreTokens()) {
            StringTokenizer stInner = new StringTokenizer(stOuter.nextToken(), "=");
            if (stInner.countTokens() == 1) {
                this.delegateProperties.put(stInner.nextToken().trim(), "");
                continue;
            }
            if (stInner.countTokens() == 2) {
                this.delegateProperties.put(stInner.nextToken().trim(), stInner.nextToken().trim());
                continue;
            }
            throw new IllegalArgumentException("Unexpected delegateProperties value: '" + properties + "'. Expected 'name=value'");
        }
    }
}

