/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read.builder;

import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.read.builder.AbstractExcelReaderParameterBuilder;
import com.alibaba.excel.read.metadata.ReadSheet;
import java.util.List;

public class ExcelReaderSheetBuilder
extends AbstractExcelReaderParameterBuilder<ExcelReaderSheetBuilder, ReadSheet> {
    private ExcelReader excelReader;
    private final ReadSheet readSheet = new ReadSheet();

    public ExcelReaderSheetBuilder() {
    }

    public ExcelReaderSheetBuilder(ExcelReader excelReader) {
        this.excelReader = excelReader;
    }

    public ExcelReaderSheetBuilder sheetNo(Integer sheetNo) {
        this.readSheet.setSheetNo(sheetNo);
        return this;
    }

    public ExcelReaderSheetBuilder sheetName(String sheetName) {
        this.readSheet.setSheetName(sheetName);
        return this;
    }

    public ReadSheet build() {
        return this.readSheet;
    }

    public void doRead() {
        if (this.excelReader == null) {
            throw new ExcelGenerateException("Must use 'EasyExcelFactory.read().sheet()' to call this method");
        }
        this.excelReader.read(this.build());
        this.excelReader.finish();
    }

    public <T> List<T> doReadSync() {
        if (this.excelReader == null) {
            throw new ExcelAnalysisException("Must use 'EasyExcelFactory.read().sheet()' to call this method");
        }
        SyncReadListener syncReadListener = new SyncReadListener();
        this.registerReadListener(syncReadListener);
        this.excelReader.read(this.build());
        this.excelReader.finish();
        return syncReadListener.getList();
    }

    @Override
    protected ReadSheet parameter() {
        return this.readSheet;
    }
}

