/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v03.handlers;

import com.alibaba.excel.analysis.v03.IgnorableXlsRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.AbstractXlsRecordHandler;
import com.alibaba.excel.constant.BuiltinFormats;
import com.alibaba.excel.constant.EasyExcelConstants;
import com.alibaba.excel.context.xls.XlsReadContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.enums.RowTypeEnum;
import com.alibaba.excel.metadata.Cell;
import com.alibaba.excel.metadata.data.DataFormatData;
import com.alibaba.excel.metadata.data.FormulaData;
import com.alibaba.excel.metadata.data.ReadCellData;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.CellType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormulaRecordHandler
extends AbstractXlsRecordHandler
implements IgnorableXlsRecordHandler {
    private static final Logger log = LoggerFactory.getLogger(FormulaRecordHandler.class);
    private static final String ERROR = "#VALUE!";

    @Override
    public void processRecord(XlsReadContext xlsReadContext, Record record) {
        FormulaRecord frec = (FormulaRecord)record;
        Map<Integer, Cell> cellMap = xlsReadContext.xlsReadSheetHolder().getCellMap();
        ReadCellData tempCellData = new ReadCellData();
        tempCellData.setRowIndex(frec.getRow());
        tempCellData.setColumnIndex(Integer.valueOf(frec.getColumn()));
        CellType cellType = CellType.forInt((int)frec.getCachedResultType());
        String formulaValue = null;
        try {
            formulaValue = HSSFFormulaParser.toFormulaString((HSSFWorkbook)xlsReadContext.xlsReadWorkbookHolder().getHssfWorkbook(), (Ptg[])frec.getParsedExpression());
        }
        catch (Exception e) {
            log.debug("Get formula value error.", (Throwable)e);
        }
        FormulaData formulaData = new FormulaData();
        formulaData.setFormulaValue(formulaValue);
        tempCellData.setFormulaData(formulaData);
        xlsReadContext.xlsReadSheetHolder().setTempRowType(RowTypeEnum.DATA);
        switch (cellType) {
            case STRING: {
                tempCellData.setType(CellDataTypeEnum.STRING);
                xlsReadContext.xlsReadSheetHolder().setTempCellData(tempCellData);
                break;
            }
            case NUMERIC: {
                tempCellData.setType(CellDataTypeEnum.NUMBER);
                tempCellData.setOriginalNumberValue(BigDecimal.valueOf(frec.getValue()));
                tempCellData.setNumberValue(tempCellData.getOriginalNumberValue().round(EasyExcelConstants.EXCEL_MATH_CONTEXT));
                int dataFormat = xlsReadContext.xlsReadWorkbookHolder().getFormatTrackingHSSFListener().getFormatIndex((CellValueRecordInterface)frec);
                DataFormatData dataFormatData = new DataFormatData();
                dataFormatData.setIndex((short)dataFormat);
                dataFormatData.setFormat(BuiltinFormats.getBuiltinFormat(dataFormatData.getIndex(), xlsReadContext.xlsReadWorkbookHolder().getFormatTrackingHSSFListener().getFormatString((CellValueRecordInterface)frec), xlsReadContext.readSheetHolder().getGlobalConfiguration().getLocale()));
                tempCellData.setDataFormatData(dataFormatData);
                cellMap.put(Integer.valueOf(frec.getColumn()), tempCellData);
                break;
            }
            case ERROR: {
                tempCellData.setType(CellDataTypeEnum.ERROR);
                tempCellData.setStringValue(ERROR);
                cellMap.put(Integer.valueOf(frec.getColumn()), tempCellData);
                break;
            }
            case BOOLEAN: {
                tempCellData.setType(CellDataTypeEnum.BOOLEAN);
                tempCellData.setBooleanValue(frec.getCachedBooleanValue());
                cellMap.put(Integer.valueOf(frec.getColumn()), tempCellData);
                break;
            }
            default: {
                tempCellData.setType(CellDataTypeEnum.EMPTY);
                cellMap.put(Integer.valueOf(frec.getColumn()), tempCellData);
            }
        }
    }
}

