/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.csv;

import com.alibaba.excel.constant.BuiltinFormats;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.util.MapUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.DataFormat;

public class CsvDataFormat
implements DataFormat {
    private final Map<String, Short> formatMap = MapUtils.newHashMap();
    private final List<String> formatList = ListUtils.newArrayList();
    private final Map<String, Short> builtinFormatsMap;
    private final String[] builtinFormats;

    public CsvDataFormat(Locale locale) {
        this.builtinFormatsMap = BuiltinFormats.switchBuiltinFormatsMap(locale);
        this.builtinFormats = BuiltinFormats.switchBuiltinFormats(locale);
    }

    public short getFormat(String format) {
        Short index = this.builtinFormatsMap.get(format);
        if (index != null) {
            return index;
        }
        index = this.formatMap.get(format);
        if (index != null) {
            return index;
        }
        short indexPrimitive = (short)(this.formatList.size() + 82);
        index = indexPrimitive;
        this.formatList.add(format);
        this.formatMap.put(format, index);
        return indexPrimitive;
    }

    public String getFormat(short index) {
        if (index < 82) {
            return this.builtinFormats[index];
        }
        int actualIndex = index - 82;
        if (actualIndex < this.formatList.size()) {
            return this.formatList.get(actualIndex);
        }
        return null;
    }
}

