/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel;

import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.read.ExcelAnalyser;
import com.alibaba.excel.read.ExcelAnalyserImpl;
import com.alibaba.excel.read.event.AnalysisEventListener;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.List;

public class ExcelReader {
    private ExcelAnalyser analyser = new ExcelAnalyserImpl();

    public ExcelReader(InputStream in, ExcelTypeEnum excelTypeEnum, Object customContent, AnalysisEventListener eventListener) {
        this(in, excelTypeEnum, customContent, eventListener, true);
    }

    public ExcelReader(InputStream in, ExcelTypeEnum excelTypeEnum, Object customContent, AnalysisEventListener eventListener, boolean trim) {
        this.validateParam(in, excelTypeEnum, eventListener);
        this.analyser.init(in, excelTypeEnum, customContent, eventListener, trim);
    }

    public void read() {
        this.analyser.analysis();
    }

    public void read(Sheet sheet) {
        this.analyser.analysis(sheet);
    }

    public List<Sheet> getSheets() {
        return this.analyser.getSheets();
    }

    public void finish() {
        this.analyser.stop();
    }

    private void validateParam(InputStream in, ExcelTypeEnum excelTypeEnum, AnalysisEventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("AnalysisEventListener can not null");
        }
        if (in == null) {
            throw new IllegalArgumentException("InputStream can not null");
        }
        if (excelTypeEnum == null) {
            throw new IllegalArgumentException("excelTypeEnum can not null");
        }
    }
}

