/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read;

import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.read.ExcelAnalyser;
import com.alibaba.excel.read.context.AnalysisContext;
import com.alibaba.excel.read.event.AnalysisEventListener;
import com.alibaba.excel.read.event.AnalysisEventRegisterCenter;
import com.alibaba.excel.read.event.OneRowAnalysisFinishEvent;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseSaxAnalyser
implements AnalysisEventRegisterCenter,
ExcelAnalyser {
    protected AnalysisContext analysisContext;
    private LinkedHashMap<String, AnalysisEventListener> listeners = new LinkedHashMap();

    protected abstract void execute();

    @Override
    public void init(InputStream inputStream, ExcelTypeEnum excelTypeEnum, Object custom, AnalysisEventListener eventListener, boolean trim) {
    }

    @Override
    public void appendLister(String name, AnalysisEventListener listener) {
        if (!this.listeners.containsKey(name)) {
            this.listeners.put(name, listener);
        }
    }

    @Override
    public void analysis(Sheet sheetParam) {
        this.execute();
    }

    @Override
    public void analysis() {
        this.execute();
    }

    @Override
    public void cleanAllListeners() {
        this.listeners = new LinkedHashMap();
    }

    @Override
    public void notifyListeners(OneRowAnalysisFinishEvent event) {
        this.analysisContext.setCurrentRowAnalysisResult(event.getData());
        if (this.analysisContext.getCurrentRowNum() < this.analysisContext.getCurrentSheet().getHeadLineMun()) {
            if (this.analysisContext.getCurrentRowNum() <= this.analysisContext.getCurrentSheet().getHeadLineMun() - 1) {
                this.analysisContext.buildExcelHeadProperty(null, (List)this.analysisContext.getCurrentRowAnalysisResult());
            }
        } else {
            this.analysisContext.setCurrentRowAnalysisResult(event.getData());
            for (Map.Entry<String, AnalysisEventListener> entry : this.listeners.entrySet()) {
                entry.getValue().invoke(this.analysisContext.getCurrentRowAnalysisResult(), this.analysisContext);
            }
        }
    }
}

