/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.cache;

import com.alibaba.excel.cache.ReadCache;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ehcache
implements ReadCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ehcache.class);
    private static final int BATCH_COUNT = 1000;
    private static final int DEBUG_WRITE_SIZE = 1000000;
    private static final int DEBUG_CACHE_MISS_SIZE = 1000;
    private int index = 0;
    private HashMap<Integer, String> dataMap = new HashMap(1334);
    private static CacheManager fileCacheManager;
    private static CacheConfiguration<Integer, HashMap> fileCacheConfiguration;
    private static CacheManager activeCacheManager;
    private CacheConfiguration<Integer, HashMap> activeCacheConfiguration;
    private Cache<Integer, HashMap> fileCache;
    private Cache<Integer, HashMap> activeCache;
    private String cacheAlias;
    private int cacheMiss = 0;

    public Ehcache(int maxCacheActivateSize) {
        this.activeCacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(Integer.class, HashMap.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)maxCacheActivateSize, (ResourceUnit)MemoryUnit.MB)).withSizeOfMaxObjectGraph(1000000L).withSizeOfMaxObjectSize((long)maxCacheActivateSize, MemoryUnit.MB).build();
    }

    @Override
    public void init(AnalysisContext analysisContext) {
        this.cacheAlias = UUID.randomUUID().toString();
        this.fileCache = fileCacheManager.createCache(this.cacheAlias, fileCacheConfiguration);
        this.activeCache = activeCacheManager.createCache(this.cacheAlias, this.activeCacheConfiguration);
    }

    @Override
    public void put(String value) {
        this.dataMap.put(this.index, value);
        if ((this.index + 1) % 1000 == 0) {
            this.fileCache.put((Object)(this.index / 1000), this.dataMap);
            this.dataMap = new HashMap(1334);
        }
        ++this.index;
        if (LOGGER.isDebugEnabled() && this.index % 1000000 == 0) {
            LOGGER.debug("Already put :{}", (Object)this.index);
        }
    }

    @Override
    public String get(Integer key) {
        if (key == null || key < 0) {
            return null;
        }
        int route = key / 1000;
        HashMap dataMap = (HashMap)this.activeCache.get((Object)route);
        if (dataMap == null) {
            dataMap = (HashMap)this.fileCache.get((Object)route);
            this.activeCache.put((Object)route, (Object)dataMap);
            if (LOGGER.isDebugEnabled() && this.cacheMiss++ % 1000 == 0) {
                LOGGER.debug("Cache misses count:{}", (Object)this.cacheMiss);
            }
        }
        return (String)dataMap.get(key);
    }

    @Override
    public void putFinished() {
        if (CollectionUtils.isEmpty(this.dataMap)) {
            return;
        }
        this.fileCache.put((Object)(this.index / 1000), this.dataMap);
    }

    @Override
    public void destroy() {
        fileCacheManager.removeCache(this.cacheAlias);
        activeCacheManager.removeCache(this.cacheAlias);
    }

    static {
        File cacheFile = FileUtils.createCacheTmpFile();
        fileCacheManager = CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((File)cacheFile)).build(true);
        activeCacheManager = CacheManagerBuilder.newCacheManagerBuilder().build(true);
        fileCacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(Integer.class, HashMap.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().disk(10L, MemoryUnit.GB)).withSizeOfMaxObjectGraph(1000000L).withSizeOfMaxObjectSize(10L, MemoryUnit.GB).build();
    }
}

