/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.context;

import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.WriteTypeEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.CellRange;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.util.WorkBookUtil;
import com.alibaba.excel.util.WriteHandlerUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.metadata.WriteWorkbook;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.alibaba.excel.write.property.ExcelWriteHeadProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteContextImpl
implements WriteContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteContextImpl.class);
    private WriteWorkbookHolder writeWorkbookHolder;
    private WriteSheetHolder writeSheetHolder;
    private WriteTableHolder writeTableHolder;
    private WriteHolder currentWriteHolder;
    private boolean finished = false;

    public WriteContextImpl(WriteWorkbook writeWorkbook) {
        if (writeWorkbook == null) {
            throw new IllegalArgumentException("Workbook argument cannot be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Begin to Initialization 'WriteContextImpl'");
        }
        this.initCurrentWorkbookHolder(writeWorkbook);
        WriteHandlerUtils.beforeWorkbookCreate(this);
        try {
            WorkBookUtil.createWorkBook(this.writeWorkbookHolder);
        }
        catch (Exception e) {
            throw new ExcelGenerateException("Create workbook failure", e);
        }
        WriteHandlerUtils.afterWorkbookCreate(this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialization 'WriteContextImpl' complete");
        }
    }

    private void initCurrentWorkbookHolder(WriteWorkbook writeWorkbook) {
        this.writeWorkbookHolder = new WriteWorkbookHolder(writeWorkbook);
        this.currentWriteHolder = this.writeWorkbookHolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CurrentConfiguration is writeWorkbookHolder");
        }
    }

    @Override
    public void currentSheet(WriteSheet writeSheet, WriteTypeEnum writeType) {
        if (writeSheet == null) {
            throw new IllegalArgumentException("Sheet argument cannot be null");
        }
        if (writeSheet.getSheetNo() == null || writeSheet.getSheetNo() <= 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sheet number is null");
            }
            writeSheet.setSheetNo(0);
        }
        if (this.writeWorkbookHolder.getHasBeenInitializedSheet().containsKey(writeSheet.getSheetNo())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sheet:{} is already existed", (Object)writeSheet.getSheetNo());
            }
            this.writeSheetHolder = this.writeWorkbookHolder.getHasBeenInitializedSheet().get(writeSheet.getSheetNo());
            this.writeSheetHolder.setNewInitialization(Boolean.FALSE);
            this.writeTableHolder = null;
            this.currentWriteHolder = this.writeSheetHolder;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("CurrentConfiguration is writeSheetHolder");
            }
            return;
        }
        this.initCurrentSheetHolder(writeSheet);
        WriteHandlerUtils.beforeSheetCreate(this);
        this.initSheet(writeType);
    }

    private void initCurrentSheetHolder(WriteSheet writeSheet) {
        this.writeSheetHolder = new WriteSheetHolder(writeSheet, this.writeWorkbookHolder);
        this.writeWorkbookHolder.getHasBeenInitializedSheet().put(writeSheet.getSheetNo(), this.writeSheetHolder);
        this.writeTableHolder = null;
        this.currentWriteHolder = this.writeSheetHolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CurrentConfiguration is writeSheetHolder");
        }
    }

    private void initSheet(WriteTypeEnum writeType) {
        Sheet currentSheet;
        try {
            currentSheet = this.writeWorkbookHolder.getWorkbook().getSheetAt(this.writeSheetHolder.getSheetNo().intValue());
            this.writeSheetHolder.setCachedSheet(this.writeWorkbookHolder.getCachedWorkbook().getSheetAt(this.writeSheetHolder.getSheetNo().intValue()));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Can not find sheet:{} ,now create it", (Object)this.writeSheetHolder.getSheetNo());
            }
            currentSheet = WorkBookUtil.createSheet(this.writeWorkbookHolder.getWorkbook(), this.writeSheetHolder.getSheetName());
            this.writeSheetHolder.setCachedSheet(currentSheet);
        }
        this.writeSheetHolder.setSheet(currentSheet);
        WriteHandlerUtils.afterSheetCreate(this);
        if (WriteTypeEnum.ADD.equals((Object)writeType)) {
            this.initHead(this.writeSheetHolder.excelWriteHeadProperty());
        }
    }

    public void initHead(ExcelWriteHeadProperty excelWriteHeadProperty) {
        if (!this.currentWriteHolder.needHead() || !this.currentWriteHolder.excelWriteHeadProperty().hasHead()) {
            return;
        }
        int newRowIndex = this.writeSheetHolder.getNewRowIndexAndStartDoWrite();
        newRowIndex += this.currentWriteHolder.relativeHeadRowIndex();
        if (this.currentWriteHolder.automaticMergeHead()) {
            this.addMergedRegionToCurrentSheet(excelWriteHeadProperty, newRowIndex);
        }
        int relativeRowIndex = 0;
        int i = newRowIndex;
        while (i < excelWriteHeadProperty.getHeadRowNumber() + newRowIndex) {
            WriteHandlerUtils.beforeRowCreate(this, newRowIndex, relativeRowIndex, Boolean.TRUE);
            Row row = WorkBookUtil.createRow(this.writeSheetHolder.getSheet(), i);
            WriteHandlerUtils.afterRowCreate(this, row, relativeRowIndex, Boolean.TRUE);
            this.addOneRowOfHeadDataToExcel(row, excelWriteHeadProperty.getHeadMap(), relativeRowIndex);
            WriteHandlerUtils.afterRowDispose(this, row, relativeRowIndex, Boolean.TRUE);
            ++i;
            ++relativeRowIndex;
        }
    }

    private void addMergedRegionToCurrentSheet(ExcelWriteHeadProperty excelWriteHeadProperty, int rowIndex) {
        for (CellRange cellRangeModel : excelWriteHeadProperty.headCellRangeList()) {
            this.writeSheetHolder.getSheet().addMergedRegionUnsafe(new CellRangeAddress(cellRangeModel.getFirstRow() + rowIndex, cellRangeModel.getLastRow() + rowIndex, cellRangeModel.getFirstCol(), cellRangeModel.getLastCol()));
        }
    }

    private void addOneRowOfHeadDataToExcel(Row row, Map<Integer, Head> headMap, int relativeRowIndex) {
        for (Map.Entry<Integer, Head> entry : headMap.entrySet()) {
            Head head = entry.getValue();
            int columnIndex = entry.getKey();
            WriteHandlerUtils.beforeCellCreate(this, row, head, columnIndex, relativeRowIndex, Boolean.TRUE);
            Cell cell = row.createCell(columnIndex);
            WriteHandlerUtils.afterCellCreate(this, cell, head, relativeRowIndex, Boolean.TRUE);
            cell.setCellValue(head.getHeadNameList().get(relativeRowIndex));
            WriteHandlerUtils.afterCellDispose((WriteContext)this, (CellData)null, cell, head, (Integer)relativeRowIndex, Boolean.TRUE);
        }
    }

    @Override
    public void currentTable(WriteTable writeTable) {
        if (writeTable == null) {
            return;
        }
        if (writeTable.getTableNo() == null || writeTable.getTableNo() <= 0) {
            writeTable.setTableNo(0);
        }
        if (this.writeSheetHolder.getHasBeenInitializedTable().containsKey(writeTable.getTableNo())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Table:{} is already existed", (Object)writeTable.getTableNo());
            }
            this.writeTableHolder = this.writeSheetHolder.getHasBeenInitializedTable().get(writeTable.getTableNo());
            this.writeTableHolder.setNewInitialization(Boolean.FALSE);
            this.currentWriteHolder = this.writeTableHolder;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("CurrentConfiguration is writeTableHolder");
            }
            return;
        }
        this.initCurrentTableHolder(writeTable);
        this.initHead(this.writeTableHolder.excelWriteHeadProperty());
    }

    private void initCurrentTableHolder(WriteTable writeTable) {
        this.writeTableHolder = new WriteTableHolder(writeTable, this.writeSheetHolder, this.writeWorkbookHolder);
        this.writeSheetHolder.getHasBeenInitializedTable().put(writeTable.getTableNo(), this.writeTableHolder);
        this.currentWriteHolder = this.writeTableHolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CurrentConfiguration is writeTableHolder");
        }
    }

    @Override
    public WriteWorkbookHolder writeWorkbookHolder() {
        return this.writeWorkbookHolder;
    }

    @Override
    public WriteSheetHolder writeSheetHolder() {
        return this.writeSheetHolder;
    }

    @Override
    public WriteTableHolder writeTableHolder() {
        return this.writeTableHolder;
    }

    @Override
    public WriteHolder currentWriteHolder() {
        return this.currentWriteHolder;
    }

    @Override
    public void finish(boolean onException) {
        boolean writeExcel;
        if (this.finished) {
            return;
        }
        this.finished = true;
        WriteHandlerUtils.afterWorkbookDispose(this);
        if (this.writeWorkbookHolder == null) {
            return;
        }
        Throwable throwable = null;
        boolean isOutputStreamEncrypt = false;
        boolean bl = writeExcel = !onException;
        if (this.writeWorkbookHolder.getWriteExcelOnException().booleanValue()) {
            writeExcel = Boolean.TRUE;
        }
        if (writeExcel) {
            try {
                isOutputStreamEncrypt = this.doOutputStreamEncrypt07();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (!isOutputStreamEncrypt) {
            try {
                if (writeExcel) {
                    this.writeWorkbookHolder.getWorkbook().write(this.writeWorkbookHolder.getOutputStream());
                }
                this.writeWorkbookHolder.getWorkbook().close();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            Workbook workbook = this.writeWorkbookHolder.getWorkbook();
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (this.writeWorkbookHolder.getAutoCloseStream().booleanValue() && this.writeWorkbookHolder.getOutputStream() != null) {
                this.writeWorkbookHolder.getOutputStream().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (writeExcel && !isOutputStreamEncrypt) {
            try {
                this.doFileEncrypt07();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            if (this.writeWorkbookHolder.getTempTemplateInputStream() != null) {
                this.writeWorkbookHolder.getTempTemplateInputStream().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        this.clearEncrypt03();
        if (throwable != null) {
            throw new ExcelGenerateException("Can not close IO.", throwable);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished write.");
        }
    }

    @Override
    public Sheet getCurrentSheet() {
        return this.writeSheetHolder.getSheet();
    }

    @Override
    public boolean needHead() {
        return this.writeSheetHolder.needHead();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.writeWorkbookHolder.getOutputStream();
    }

    @Override
    public Workbook getWorkbook() {
        return this.writeWorkbookHolder.getWorkbook();
    }

    private void clearEncrypt03() {
        if (StringUtils.isEmpty(this.writeWorkbookHolder.getPassword()) || !ExcelTypeEnum.XLS.equals((Object)this.writeWorkbookHolder.getExcelType())) {
            return;
        }
        Biff8EncryptionKey.setCurrentUserPassword(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOutputStreamEncrypt07() throws Exception {
        if (StringUtils.isEmpty(this.writeWorkbookHolder.getPassword()) || !ExcelTypeEnum.XLSX.equals((Object)this.writeWorkbookHolder.getExcelType())) {
            return false;
        }
        if (this.writeWorkbookHolder.getFile() != null) {
            return false;
        }
        File tempXlsx = FileUtils.createTmpFile(UUID.randomUUID().toString() + ".xlsx");
        FileOutputStream tempFileOutputStream = new FileOutputStream(tempXlsx);
        try {
            this.writeWorkbookHolder.getWorkbook().write((OutputStream)tempFileOutputStream);
        }
        finally {
            try {
                this.writeWorkbookHolder.getWorkbook().close();
                tempFileOutputStream.close();
            }
            catch (Exception e) {
                if (!tempXlsx.delete()) {
                    throw new ExcelGenerateException("Can not delete temp File!");
                }
                throw e;
            }
        }
        POIFSFileSystem fileSystem = null;
        try {
            fileSystem = this.openFileSystemAndEncrypt(tempXlsx);
            fileSystem.writeFilesystem(this.writeWorkbookHolder.getOutputStream());
        }
        finally {
            if (fileSystem != null) {
                fileSystem.close();
            }
            if (!tempXlsx.delete()) {
                throw new ExcelGenerateException("Can not delete temp File!");
            }
        }
        return true;
    }

    private void doFileEncrypt07() throws Exception {
        if (StringUtils.isEmpty(this.writeWorkbookHolder.getPassword()) || !ExcelTypeEnum.XLSX.equals((Object)this.writeWorkbookHolder.getExcelType())) {
            return;
        }
        if (this.writeWorkbookHolder.getFile() == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        POIFSFileSystem fileSystem = null;
        try {
            fileSystem = this.openFileSystemAndEncrypt(this.writeWorkbookHolder.getFile());
            fileOutputStream = new FileOutputStream(this.writeWorkbookHolder.getFile());
            fileSystem.writeFilesystem((OutputStream)fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private POIFSFileSystem openFileSystemAndEncrypt(File file) throws Exception {
        POIFSFileSystem fileSystem = new POIFSFileSystem();
        Encryptor encryptor = new EncryptionInfo(EncryptionMode.standard).getEncryptor();
        encryptor.confirmPassword(this.writeWorkbookHolder.getPassword());
        OPCPackage opcPackage = null;
        try {
            opcPackage = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ_WRITE);
            OutputStream outputStream = encryptor.getDataStream(fileSystem);
            opcPackage.save(outputStream);
        }
        finally {
            opcPackage.close();
        }
        return fileSystem;
    }
}

