/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONLexerBase;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.EnumDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.JavaBeanInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanDeserializer
implements ObjectDeserializer {
    private final FieldDeserializer[] fieldDeserializers;
    protected final FieldDeserializer[] sortedFieldDeserializers;
    protected final Class<?> clazz;
    public final JavaBeanInfo beanInfo;
    private ConcurrentMap<String, Object> extraFieldDeserializers;

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz) {
        this(config, clazz, clazz);
    }

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz, Type type) {
        this(config, JavaBeanInfo.build(clazz, type, config.propertyNamingStrategy));
    }

    public JavaBeanDeserializer(ParserConfig config, JavaBeanInfo beanInfo) {
        FieldDeserializer fieldDeserializer;
        this.clazz = beanInfo.clazz;
        this.beanInfo = beanInfo;
        this.sortedFieldDeserializers = new FieldDeserializer[beanInfo.sortedFields.length];
        for (FieldInfo fieldInfo : beanInfo.sortedFields) {
            this.sortedFieldDeserializers[i] = fieldDeserializer = config.createFieldDeserializer(config, beanInfo, fieldInfo);
        }
        this.fieldDeserializers = new FieldDeserializer[beanInfo.fields.length];
        for (FieldInfo fieldInfo : beanInfo.fields) {
            this.fieldDeserializers[i] = fieldDeserializer = this.getFieldDeserializer(fieldInfo.name);
        }
    }

    public FieldDeserializer getFieldDeserializer(String key) {
        if (key == null) {
            return null;
        }
        int low = 0;
        int high = this.sortedFieldDeserializers.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            String fieldName = this.sortedFieldDeserializers[mid].fieldInfo.name;
            int cmp = fieldName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return this.sortedFieldDeserializers[mid];
        }
        return null;
    }

    public Object createInstance(DefaultJSONParser parser, Type type) {
        Object object;
        block21: {
            if (type instanceof Class && this.clazz.isInterface()) {
                Class clazz = (Class)type;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                JSONObject obj = new JSONObject();
                Object proxy = Proxy.newProxyInstance(loader, new Class[]{clazz}, (InvocationHandler)obj);
                return proxy;
            }
            if (this.beanInfo.defaultConstructor == null) {
                return null;
            }
            try {
                Constructor<?> constructor = this.beanInfo.defaultConstructor;
                if (this.beanInfo.defaultConstructorParameterSize == 0) {
                    object = constructor.newInstance(new Object[0]);
                    break block21;
                }
                ParseContext context = parser.getContext();
                String parentName = context.object.getClass().getName();
                String typeName = "";
                if (type instanceof Class) {
                    typeName = ((Class)type).getName();
                }
                if (parentName.length() != typeName.lastIndexOf(36) - 1) {
                    char[] typeChars = typeName.toCharArray();
                    StringBuilder clsNameBuilder = new StringBuilder();
                    clsNameBuilder.append(parentName).append("$");
                    HashMap<String, Object> outterCached = new HashMap<String, Object>();
                    outterCached.put(parentName, context.object);
                    for (int i = parentName.length() + 1; i <= typeName.lastIndexOf(36); ++i) {
                        char thisChar = typeChars[i];
                        if (thisChar == '$') {
                            String clsName = clsNameBuilder.toString();
                            Object outter = outterCached.get(parentName);
                            try {
                                Class<?> clazz = Class.forName(parentName);
                                if (outter != null) {
                                    Class<?> innerCls = Class.forName(clsName);
                                    Constructor<?> innerClsConstructor = innerCls.getDeclaredConstructor(clazz);
                                    if (!innerClsConstructor.isAccessible()) {
                                        innerClsConstructor.setAccessible(true);
                                    }
                                    Object inner = innerClsConstructor.newInstance(outter);
                                    outterCached.put(clsName, inner);
                                    parentName = clsName;
                                }
                            }
                            catch (ClassNotFoundException e) {
                                throw new JSONException("unable to find class " + parentName);
                            }
                            catch (NoSuchMethodException e) {
                                throw new RuntimeException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException("can not instantiate " + clsName);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        clsNameBuilder.append(thisChar);
                    }
                    object = constructor.newInstance(outterCached.get(parentName));
                    break block21;
                }
                object = constructor.newInstance(context.object);
            }
            catch (Exception e) {
                throw new JSONException("create instance error, class " + this.clazz.getName(), e);
            }
        }
        if (parser != null && parser.lexer.isEnabled(Feature.InitStringFieldAsEmpty)) {
            for (FieldInfo fieldInfo : this.beanInfo.fields) {
                if (fieldInfo.fieldClass != String.class) continue;
                try {
                    fieldInfo.set(object, "");
                }
                catch (Exception e) {
                    throw new JSONException("create instance error, class " + this.clazz.getName(), e);
                }
            }
        }
        return object;
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        return this.deserialze(parser, type, fieldName, 0);
    }

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, int features) {
        return this.deserialze(parser, type, fieldName, null, features, null);
    }

    public <T> T deserialzeArrayMapping(DefaultJSONParser parser, Type type, Object fieldName, Object object) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() != 14) {
            throw new JSONException("error");
        }
        object = this.createInstance(parser, type);
        int size = this.sortedFieldDeserializers.length;
        for (int i = 0; i < size; ++i) {
            char seperator = i == size - 1 ? (char)']' : ',';
            FieldDeserializer fieldDeser = this.sortedFieldDeserializers[i];
            Class<?> fieldClass = fieldDeser.fieldInfo.fieldClass;
            if (fieldClass == Integer.TYPE) {
                int value = lexer.scanInt(seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass == String.class) {
                String value = lexer.scanString(seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass == Long.TYPE) {
                long value = lexer.scanLong(seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass.isEnum()) {
                Enum<?> value;
                char ch = lexer.getCurrent();
                if (ch == '\"' || ch == 'n') {
                    value = lexer.scanEnum(fieldClass, parser.getSymbolTable(), seperator);
                } else if (ch >= '0' && ch <= '9') {
                    int ordinal = lexer.scanInt(seperator);
                    EnumDeserializer enumDeser = (EnumDeserializer)((DefaultFieldDeserializer)fieldDeser).getFieldValueDeserilizer(parser.getConfig());
                    value = enumDeser.valueOf(ordinal);
                } else {
                    value = this.scanEnum(lexer, seperator);
                }
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass == Boolean.TYPE) {
                boolean value = lexer.scanBoolean(seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass == Float.TYPE) {
                float value = lexer.scanFloat(seperator);
                fieldDeser.setValue(object, Float.valueOf(value));
                continue;
            }
            if (fieldClass == Double.TYPE) {
                double value = lexer.scanDouble(seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass == Date.class && lexer.getCurrent() == '1') {
                long longValue = lexer.scanLong(seperator);
                fieldDeser.setValue(object, new Date(longValue));
                continue;
            }
            lexer.nextToken(14);
            Object value = parser.parseObject(fieldDeser.fieldInfo.fieldType);
            fieldDeser.setValue(object, value);
            this.check(lexer, seperator == ']' ? 15 : 16);
        }
        lexer.nextToken(16);
        return (T)object;
    }

    protected void check(JSONLexer lexer, int token) {
        if (lexer.token() != token) {
            throw new JSONException("syntax error");
        }
    }

    protected Enum<?> scanEnum(JSONLexer lexer, char seperator) {
        throw new JSONException("illegal enum. " + lexer.info());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, Object object, int features, int[] setFlags) {
        if (type == JSON.class || type == JSONObject.class) {
            return (T)parser.parse();
        }
        lexer = (JSONLexerBase)parser.lexer;
        token = lexer.token();
        if (token == 8) {
            lexer.nextToken(16);
            return null;
        }
        context = parser.getContext();
        if (object != null && context != null) {
            context = context.parent;
        }
        childContext = null;
        try {
            fieldValues = null;
            if (token == 13) {
                lexer.nextToken(16);
                if (object == null) {
                    object = this.createInstance(parser, type);
                }
                var12_12 = object;
                return (T)var12_12;
            }
            if (token == 14) {
                mask = Feature.SupportArrayToBean.mask;
                v0 = isSupportArrayToBean = (this.beanInfo.parserFeatures & mask) != 0 || lexer.isEnabled(Feature.SupportArrayToBean) != false || (features & mask) != 0;
                if (isSupportArrayToBean) {
                    var14_27 = this.deserialzeArrayMapping(parser, type, fieldName, object);
                    return var14_27;
                }
            }
            if (token != 12 && token != 16) {
                if (lexer.isBlankInput()) {
                    mask = null;
                    return mask;
                }
                if (token == 4 && (strVal = lexer.stringVal()).length() == 0) {
                    lexer.nextToken();
                    isSupportArrayToBean = null;
                    return isSupportArrayToBean;
                }
                if (token == 14 && lexer.getCurrent() == ']') {
                    lexer.next();
                    lexer.nextToken();
                    strVal = null;
                    return strVal;
                }
                buf = new StringBuffer().append("syntax error, expect {, actual ").append(lexer.tokenName()).append(", pos ").append(lexer.pos());
                if (fieldName instanceof String) {
                    buf.append(", fieldName ").append(fieldName);
                }
                throw new JSONException(buf.toString());
            }
            if (parser.resolveStatus == 2) {
                parser.resolveStatus = 0;
            }
            fieldIndex = 0;
            while (true) {
                block93: {
                    block116: {
                        block112: {
                            block114: {
                                block115: {
                                    block113: {
                                        block90: {
                                            block110: {
                                                block111: {
                                                    block108: {
                                                        block109: {
                                                            block106: {
                                                                block107: {
                                                                    block104: {
                                                                        block105: {
                                                                            block102: {
                                                                                block103: {
                                                                                    block100: {
                                                                                        block101: {
                                                                                            block98: {
                                                                                                block99: {
                                                                                                    block96: {
                                                                                                        block97: {
                                                                                                            block94: {
                                                                                                                block95: {
                                                                                                                    block91: {
                                                                                                                        block92: {
                                                                                                                            key = null;
                                                                                                                            fieldDeser = null;
                                                                                                                            fieldInfo = null;
                                                                                                                            fieldClass = null;
                                                                                                                            feildAnnotation = null;
                                                                                                                            if (fieldIndex < this.sortedFieldDeserializers.length) {
                                                                                                                                fieldDeser = this.sortedFieldDeserializers[fieldIndex];
                                                                                                                                fieldInfo = fieldDeser.fieldInfo;
                                                                                                                                fieldClass = fieldInfo.fieldClass;
                                                                                                                                feildAnnotation = fieldInfo.getAnnotation();
                                                                                                                            }
                                                                                                                            matchField = false;
                                                                                                                            valueParsed = false;
                                                                                                                            fieldValue = null;
                                                                                                                            if (fieldDeser == null) break block90;
                                                                                                                            name_chars = fieldInfo.name_chars;
                                                                                                                            if (fieldClass != Integer.TYPE && fieldClass != Integer.class) break block91;
                                                                                                                            fieldValue = lexer.scanFieldInt(name_chars);
                                                                                                                            if (lexer.matchStat <= 0) break block92;
                                                                                                                            matchField = true;
                                                                                                                            valueParsed = true;
                                                                                                                            break block90;
                                                                                                                        }
                                                                                                                        if (lexer.matchStat != -2) break block90;
                                                                                                                        break block93;
                                                                                                                    }
                                                                                                                    if (fieldClass != Long.TYPE && fieldClass != Long.class) break block94;
                                                                                                                    fieldValue = lexer.scanFieldLong(name_chars);
                                                                                                                    if (lexer.matchStat <= 0) break block95;
                                                                                                                    matchField = true;
                                                                                                                    valueParsed = true;
                                                                                                                    break block90;
                                                                                                                }
                                                                                                                if (lexer.matchStat != -2) break block90;
                                                                                                                break block93;
                                                                                                            }
                                                                                                            if (fieldClass != String.class) break block96;
                                                                                                            fieldValue = lexer.scanFieldString(name_chars);
                                                                                                            if (lexer.matchStat <= 0) break block97;
                                                                                                            matchField = true;
                                                                                                            valueParsed = true;
                                                                                                            break block90;
                                                                                                        }
                                                                                                        if (lexer.matchStat != -2) break block90;
                                                                                                        break block93;
                                                                                                    }
                                                                                                    if (fieldClass != Boolean.TYPE && fieldClass != Boolean.class) break block98;
                                                                                                    fieldValue = lexer.scanFieldBoolean(name_chars);
                                                                                                    if (lexer.matchStat <= 0) break block99;
                                                                                                    matchField = true;
                                                                                                    valueParsed = true;
                                                                                                    break block90;
                                                                                                }
                                                                                                if (lexer.matchStat != -2) break block90;
                                                                                                break block93;
                                                                                            }
                                                                                            if (fieldClass != Float.TYPE && fieldClass != Float.class) break block100;
                                                                                            fieldValue = Float.valueOf(lexer.scanFieldFloat(name_chars));
                                                                                            if (lexer.matchStat <= 0) break block101;
                                                                                            matchField = true;
                                                                                            valueParsed = true;
                                                                                            break block90;
                                                                                        }
                                                                                        if (lexer.matchStat != -2) break block90;
                                                                                        break block93;
                                                                                    }
                                                                                    if (fieldClass != Double.TYPE && fieldClass != Double.class) break block102;
                                                                                    fieldValue = lexer.scanFieldDouble(name_chars);
                                                                                    if (lexer.matchStat <= 0) break block103;
                                                                                    matchField = true;
                                                                                    valueParsed = true;
                                                                                    break block90;
                                                                                }
                                                                                if (lexer.matchStat != -2) break block90;
                                                                                break block93;
                                                                            }
                                                                            if (!fieldClass.isEnum() || !(parser.getConfig().getDeserializer(fieldClass) instanceof EnumDeserializer) || feildAnnotation != null && feildAnnotation.deserializeUsing() != Void.class) break block104;
                                                                            if (!(fieldDeser instanceof DefaultFieldDeserializer)) break block90;
                                                                            fieldValueDeserilizer = ((DefaultFieldDeserializer)fieldDeser).fieldValueDeserilizer;
                                                                            fieldValue = this.scanEnum(lexer, name_chars, fieldValueDeserilizer);
                                                                            if (lexer.matchStat <= 0) break block105;
                                                                            matchField = true;
                                                                            valueParsed = true;
                                                                            break block90;
                                                                        }
                                                                        if (lexer.matchStat != -2) break block90;
                                                                        break block93;
                                                                    }
                                                                    if (fieldClass != int[].class) break block106;
                                                                    fieldValue = lexer.scanFieldIntArray(name_chars);
                                                                    if (lexer.matchStat <= 0) break block107;
                                                                    matchField = true;
                                                                    valueParsed = true;
                                                                    break block90;
                                                                }
                                                                if (lexer.matchStat != -2) break block90;
                                                                break block93;
                                                            }
                                                            if (fieldClass != float[].class) break block108;
                                                            fieldValue = lexer.scanFieldFloatArray(name_chars);
                                                            if (lexer.matchStat <= 0) break block109;
                                                            matchField = true;
                                                            valueParsed = true;
                                                            break block90;
                                                        }
                                                        if (lexer.matchStat != -2) break block90;
                                                        break block93;
                                                    }
                                                    if (fieldClass != float[][].class) break block110;
                                                    fieldValue = lexer.scanFieldFloatArray2(name_chars);
                                                    if (lexer.matchStat <= 0) break block111;
                                                    matchField = true;
                                                    valueParsed = true;
                                                    break block90;
                                                }
                                                if (lexer.matchStat != -2) break block90;
                                                break block93;
                                            }
                                            if (!lexer.matchField(name_chars)) break block93;
                                            matchField = true;
                                        }
                                        if (matchField) break block112;
                                        key = lexer.scanSymbol(parser.symbolTable);
                                        if (key != null) break block113;
                                        token = lexer.token();
                                        if (token == 13) {
                                            lexer.nextToken(16);
                                            break;
                                        }
                                        if (token == 16 && lexer.isEnabled(Feature.AllowArbitraryCommas)) break block93;
                                    }
                                    if ("$ref" == key) {
                                        lexer.nextTokenWithColon(4);
                                        token = lexer.token();
                                        if (token == 4) {
                                            ref = lexer.stringVal();
                                            if ("@".equals(ref)) {
                                                object = context.object;
                                            } else if ("..".equals(ref)) {
                                                parentContext = context.parent;
                                                if (parentContext.object != null) {
                                                    object = parentContext.object;
                                                } else {
                                                    parser.addResolveTask(new DefaultJSONParser.ResolveTask(parentContext, (String)ref));
                                                    parser.resolveStatus = 1;
                                                }
                                            } else if ("$".equals(ref)) {
                                                rootContext = context;
                                                while (rootContext.parent != null) {
                                                    rootContext = rootContext.parent;
                                                }
                                                if (rootContext.object != null) {
                                                    object = rootContext.object;
                                                } else {
                                                    parser.addResolveTask(new DefaultJSONParser.ResolveTask(rootContext, (String)ref));
                                                    parser.resolveStatus = 1;
                                                }
                                            } else {
                                                parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                                                parser.resolveStatus = 1;
                                            }
                                        } else {
                                            throw new JSONException("illegal ref, " + JSONToken.name(token));
                                        }
                                        lexer.nextToken(13);
                                        if (lexer.token() != 13) {
                                            throw new JSONException("illegal ref");
                                        }
                                        lexer.nextToken(16);
                                        parser.setContext(context, object, fieldName);
                                        ref = object;
                                        return (T)ref;
                                    }
                                    if (JSON.DEFAULT_TYPE_KEY != key) break block112;
                                    lexer.nextTokenWithColon(4);
                                    if (lexer.token() != 4) break block114;
                                    typeName = lexer.stringVal();
                                    lexer.nextToken(16);
                                    if (!typeName.equals(this.beanInfo.typeName)) break block115;
                                    if (lexer.token() == 13) {
                                        lexer.nextToken();
                                        break;
                                    }
                                    break block93;
                                }
                                config = parser.getConfig();
                                deserizer /* !! */  = this.getSeeAlso(config, this.beanInfo, typeName);
                                userType = null;
                                if (deserizer /* !! */  == null) {
                                    expectClass = TypeUtils.getClass(type);
                                    userType = config.checkAutoType(typeName, expectClass);
                                    deserizer /* !! */  = parser.getConfig().getDeserializer(userType);
                                }
                                var25_46 = deserizer /* !! */ .deserialze(parser, userType, fieldName);
                                return var25_46;
                            }
                            throw new JSONException("syntax error");
                        }
                        if (object == null && fieldValues == null) {
                            object = this.createInstance(parser, type);
                            if (object == null) {
                                fieldValues = new HashMap<String, Integer>(this.fieldDeserializers.length);
                            }
                            childContext = parser.setContext(context, object, fieldName);
                        }
                        if (!matchField) break block116;
                        if (!valueParsed) {
                            fieldDeser.parseField(parser, object, type, fieldValues);
                        } else {
                            if (object == null) {
                                fieldValues.put(fieldInfo.name, (Integer)fieldValue);
                            } else if (fieldValue == null) {
                                if (fieldClass != Integer.TYPE && fieldClass != Long.TYPE && fieldClass != Float.TYPE && fieldClass != Double.TYPE && fieldClass != Boolean.TYPE) {
                                    fieldDeser.setValue(object, fieldValue);
                                }
                            } else {
                                fieldDeser.setValue(object, fieldValue);
                            }
                            if (lexer.matchStat == 4) {
                                break;
                            }
                        }
                        ** GOTO lbl270
                    }
                    match = this.parseField(parser, key, object, type, fieldValues, setFlags);
                    if (!match) {
                        if (lexer.token() == 13) {
                            lexer.nextToken();
                            break;
                        }
                    } else {
                        if (lexer.token() == 17) {
                            throw new JSONException("syntax error, unexpect token ':'");
                        }
lbl270:
                        // 4 sources

                        if (lexer.token() != 16) {
                            if (lexer.token() == 13) {
                                lexer.nextToken(16);
                                break;
                            }
                            if (lexer.token() == 18 || lexer.token() == 1) {
                                throw new JSONException("syntax error, unexpect token " + JSONToken.name(lexer.token()));
                            }
                        }
                    }
                }
                ++fieldIndex;
            }
            if (object == null) {
                if (fieldValues == null) {
                    object = this.createInstance(parser, type);
                    if (childContext == null) {
                        childContext = parser.setContext(context, object, fieldName);
                    }
                    fieldIndex = object;
                    return (T)fieldIndex;
                }
                fieldInfoList = this.beanInfo.fields;
                size = fieldInfoList.length;
                params = new Object[size];
                for (i = 0; i < size; ++i) {
                    fieldInfo = fieldInfoList[i];
                    param /* !! */  = fieldValues.get(fieldInfo.name);
                    if (param /* !! */  == null) {
                        fieldType = fieldInfo.fieldType;
                        if (fieldType == Byte.TYPE) {
                            param /* !! */  = (byte)0;
                        } else if (fieldType == Short.TYPE) {
                            param /* !! */  = (short)0;
                        } else if (fieldType == Integer.TYPE) {
                            param /* !! */  = 0;
                        } else if (fieldType == Long.TYPE) {
                            param /* !! */  = 0L;
                        } else if (fieldType == Float.TYPE) {
                            param /* !! */  = Float.valueOf(0.0f);
                        } else if (fieldType == Double.TYPE) {
                            param /* !! */  = 0.0;
                        } else if (fieldType == Boolean.TYPE) {
                            param /* !! */  = Boolean.FALSE;
                        }
                    }
                    params[i] = param /* !! */ ;
                }
                if (this.beanInfo.creatorConstructor != null) {
                    try {
                        object = this.beanInfo.creatorConstructor.newInstance(params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), e);
                    }
                }
                if (this.beanInfo.factoryMethod != null) {
                    try {
                        object = this.beanInfo.factoryMethod.invoke(null, params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), e);
                    }
                }
            }
            if ((buildMethod = this.beanInfo.buildMethod) == null) {
                size = object;
                return (T)size;
            }
            try {
                builtObj = buildMethod.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new JSONException("build object error", e);
            }
            var14_28 = builtObj;
            return (T)var14_28;
        }
        finally {
            if (childContext != null) {
                childContext.object = object;
            }
            parser.setContext(context);
        }
    }

    protected Enum scanEnum(JSONLexerBase lexer, char[] name_chars, ObjectDeserializer fieldValueDeserilizer) {
        EnumDeserializer enumDeserializer = null;
        if (fieldValueDeserilizer instanceof EnumDeserializer) {
            enumDeserializer = (EnumDeserializer)fieldValueDeserilizer;
        }
        if (enumDeserializer == null) {
            lexer.matchStat = -1;
            return null;
        }
        long enumNameHashCode = lexer.scanFieldSymbol(name_chars);
        if (lexer.matchStat > 0) {
            return enumDeserializer.getEnumByHashCode(enumNameHashCode);
        }
        return null;
    }

    public boolean parseField(DefaultJSONParser parser, String key, Object object, Type objectType, Map<String, Object> fieldValues) {
        return this.parseField(parser, key, object, objectType, fieldValues, null);
    }

    public boolean parseField(DefaultJSONParser parser, String key, Object object, Type objectType, Map<String, Object> fieldValues, int[] setFlags) {
        int flagIndex;
        JSONLexer lexer = parser.lexer;
        FieldDeserializer fieldDeserializer = this.smartMatch(key);
        int mask = Feature.SupportNonPublicField.mask;
        if (fieldDeserializer == null && (parser.lexer.isEnabled(mask) || (this.beanInfo.parserFeatures & mask) != 0)) {
            Object deserOrField;
            if (this.extraFieldDeserializers == null) {
                Field[] fields;
                ConcurrentHashMap<String, Object> extraFieldDeserializers = new ConcurrentHashMap<String, Object>(1, 0.75f, 1);
                for (Field field : fields = this.clazz.getDeclaredFields()) {
                    int fieldModifiers;
                    String fieldName = field.getName();
                    if (this.getFieldDeserializer(fieldName) != null || ((fieldModifiers = field.getModifiers()) & 0x10) != 0 || (fieldModifiers & 8) != 0) continue;
                    extraFieldDeserializers.put(fieldName, field);
                }
                this.extraFieldDeserializers = extraFieldDeserializers;
            }
            if ((deserOrField = this.extraFieldDeserializers.get(key)) != null) {
                if (deserOrField instanceof FieldDeserializer) {
                    fieldDeserializer = (FieldDeserializer)deserOrField;
                } else {
                    Field field = (Field)deserOrField;
                    field.setAccessible(true);
                    FieldInfo fieldInfo = new FieldInfo(key, field.getDeclaringClass(), field.getType(), field.getGenericType(), field, 0, 0, 0);
                    fieldDeserializer = new DefaultFieldDeserializer(parser.getConfig(), this.clazz, fieldInfo);
                    this.extraFieldDeserializers.put(key, fieldDeserializer);
                }
            }
        }
        if (fieldDeserializer == null) {
            if (!lexer.isEnabled(Feature.IgnoreNotMatch)) {
                throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + key);
            }
            parser.parseExtra(object, key);
            return false;
        }
        int fieldIndex = -1;
        for (int i = 0; i < this.sortedFieldDeserializers.length; ++i) {
            if (this.sortedFieldDeserializers[i] != fieldDeserializer) continue;
            fieldIndex = i;
            break;
        }
        if (fieldIndex != -1 && setFlags != null && key.startsWith("_") && (flagIndex = fieldIndex / 32) < setFlags.length && (setFlags[flagIndex] & 1 << flagIndex) != 0) {
            parser.parseExtra(object, key);
            return false;
        }
        lexer.nextTokenWithColon(fieldDeserializer.getFastMatchToken());
        fieldDeserializer.parseField(parser, object, objectType, fieldValues);
        return true;
    }

    public FieldDeserializer smartMatch(String key) {
        if (key == null) {
            return null;
        }
        FieldDeserializer fieldDeserializer = this.getFieldDeserializer(key);
        if (fieldDeserializer == null) {
            boolean startsWithIs = key.startsWith("is");
            for (FieldDeserializer fieldDeser : this.sortedFieldDeserializers) {
                FieldInfo fieldInfo = fieldDeser.fieldInfo;
                Class<?> fieldClass = fieldInfo.fieldClass;
                String fieldName = fieldInfo.name;
                if (fieldName.equalsIgnoreCase(key)) {
                    fieldDeserializer = fieldDeser;
                    break;
                }
                if (!startsWithIs || fieldClass != Boolean.TYPE && fieldClass != Boolean.class || !fieldName.equalsIgnoreCase(key.substring(2))) continue;
                fieldDeserializer = fieldDeser;
                break;
            }
        }
        if (fieldDeserializer == null) {
            boolean snakeOrkebab = false;
            String key2 = null;
            for (int i = 0; i < key.length(); ++i) {
                int ch = key.charAt(i);
                if (ch == 95) {
                    snakeOrkebab = true;
                    key2 = key.replaceAll("_", "");
                    break;
                }
                if (ch != 45) continue;
                snakeOrkebab = true;
                key2 = key.replaceAll("-", "");
                break;
            }
            if (snakeOrkebab && (fieldDeserializer = this.getFieldDeserializer(key2)) == null) {
                for (FieldDeserializer fieldDeser : this.sortedFieldDeserializers) {
                    if (!fieldDeser.fieldInfo.name.equalsIgnoreCase(key2)) continue;
                    fieldDeserializer = fieldDeser;
                    break;
                }
            }
        }
        if (fieldDeserializer == null) {
            for (FieldDeserializer fieldDeser : this.sortedFieldDeserializers) {
                if (!fieldDeser.fieldInfo.alternateName(key)) continue;
                fieldDeserializer = fieldDeser;
                break;
            }
        }
        return fieldDeserializer;
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    public Object createInstance(Map<String, Object> map, ParserConfig config) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object object = null;
        if (this.beanInfo.creatorConstructor == null && this.beanInfo.factoryMethod == null) {
            object = this.createInstance(null, this.clazz);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                FieldDeserializer fieldDeser = this.smartMatch(key);
                if (fieldDeser == null) continue;
                FieldInfo fieldInfo = fieldDeser.fieldInfo;
                Type paramType = fieldInfo.fieldType;
                value = TypeUtils.cast(value, paramType, config);
                fieldDeser.setValue(object, value);
            }
            if (this.beanInfo.buildMethod != null) {
                Object builtObj;
                try {
                    builtObj = this.beanInfo.buildMethod.invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    throw new JSONException("build object error", e);
                }
                return builtObj;
            }
            return object;
        }
        FieldInfo[] fieldInfoList = this.beanInfo.fields;
        int size = fieldInfoList.length;
        Object[] params = new Object[size];
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo = fieldInfoList[i];
            params[i] = map.get(fieldInfo.name);
        }
        if (this.beanInfo.creatorConstructor != null) {
            try {
                object = this.beanInfo.creatorConstructor.newInstance(params);
            }
            catch (Exception e) {
                throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), e);
            }
        }
        if (this.beanInfo.factoryMethod != null) {
            try {
                object = this.beanInfo.factoryMethod.invoke(null, params);
            }
            catch (Exception e) {
                throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), e);
            }
        }
        return object;
    }

    public Type getFieldType(int ordinal) {
        return this.sortedFieldDeserializers[ordinal].fieldInfo.fieldType;
    }

    protected Object parseRest(DefaultJSONParser parser, Type type, Object fieldName, Object instance, int features) {
        return this.parseRest(parser, type, fieldName, instance, features, new int[0]);
    }

    protected Object parseRest(DefaultJSONParser parser, Type type, Object fieldName, Object instance, int features, int[] setFlags) {
        Object value = this.deserialze(parser, type, fieldName, instance, features, setFlags);
        return value;
    }

    protected JavaBeanDeserializer getSeeAlso(ParserConfig config, JavaBeanInfo beanInfo, String typeName) {
        if (beanInfo.jsonType == null) {
            return null;
        }
        for (Class<?> seeAlsoClass : beanInfo.jsonType.seeAlso()) {
            ObjectDeserializer seeAlsoDeser = config.getDeserializer(seeAlsoClass);
            if (!(seeAlsoDeser instanceof JavaBeanDeserializer)) continue;
            JavaBeanDeserializer seeAlsoJavaBeanDeser = (JavaBeanDeserializer)seeAlsoDeser;
            JavaBeanInfo subBeanInfo = seeAlsoJavaBeanDeser.beanInfo;
            if (subBeanInfo.typeName.equals(typeName)) {
                return seeAlsoJavaBeanDeser;
            }
            JavaBeanDeserializer subSeeAlso = this.getSeeAlso(config, subBeanInfo, typeName);
            if (subSeeAlso == null) continue;
            return subSeeAlso;
        }
        return null;
    }

    protected static void parseArray(Collection collection, ObjectDeserializer deser, DefaultJSONParser parser, Type type, Object fieldName) {
        char ch;
        JSONLexerBase lexer = (JSONLexerBase)parser.lexer;
        int token = lexer.token();
        if (token == 8) {
            lexer.nextToken(16);
            token = lexer.token();
            return;
        }
        if (token != 14) {
            parser.throwException(token);
        }
        if ((ch = lexer.getCurrent()) == '[') {
            lexer.next();
            lexer.setToken(14);
        } else {
            lexer.nextToken(14);
        }
        if (lexer.token() == 15) {
            lexer.nextToken();
            return;
        }
        int index = 0;
        while (true) {
            Object item = deser.deserialze(parser, type, index);
            collection.add(item);
            ++index;
            if (lexer.token() != 16) break;
            ch = lexer.getCurrent();
            if (ch == '[') {
                lexer.next();
                lexer.setToken(14);
                continue;
            }
            lexer.nextToken(14);
        }
        token = lexer.token();
        if (token != 15) {
            parser.throwException(token);
        }
        if ((ch = lexer.getCurrent()) == ',') {
            lexer.next();
            lexer.setToken(16);
        } else {
            lexer.nextToken(16);
        }
    }
}

