/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.arrow;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.support.csv.CSVWriter;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;

public class ArrowUtils {
    static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    static final byte DECIMAL_TYPE_WIDTH = 16;

    public static void write(CSVWriter writer, VectorSchemaRoot root) throws IOException {
        List fieldVectors = root.getFieldVectors();
        int rowCount = root.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < fieldVectors.size(); ++j) {
                FieldVector fieldVector;
                if (j != 0) {
                    writer.writeComma();
                }
                if ((fieldVector = (FieldVector)fieldVectors.get(j)).isNull(i)) continue;
                if (fieldVector instanceof IntVector) {
                    int value = ((IntVector)fieldVector).get(i);
                    writer.writeInt32(value);
                    continue;
                }
                if (fieldVector instanceof BigIntVector) {
                    long value = ((BigIntVector)fieldVector).get(i);
                    writer.writeInt64(value);
                    continue;
                }
                if (fieldVector instanceof VarCharVector) {
                    byte[] value = ((VarCharVector)fieldVector).get(i);
                    writer.writeString(value);
                    continue;
                }
                if (fieldVector instanceof DecimalVector) {
                    DecimalVector decimalVector = (DecimalVector)fieldVector;
                    ArrowUtils.writeDecimal(writer, i, decimalVector);
                    continue;
                }
                if (fieldVector instanceof DateMilliVector) {
                    long millis = ((DateMilliVector)fieldVector).get(i);
                    writer.writeDate(millis);
                    continue;
                }
                if (fieldVector instanceof Float8Vector) {
                    double value = ((Float8Vector)fieldVector).get(i);
                    writer.writeDouble(value);
                    continue;
                }
                if (fieldVector instanceof Float4Vector) {
                    float value = ((Float4Vector)fieldVector).get(i);
                    writer.writeFloat(value);
                    continue;
                }
                if (fieldVector instanceof SmallIntVector) {
                    short value = ((SmallIntVector)fieldVector).get(i);
                    writer.writeInt32((int)value);
                    continue;
                }
                if (fieldVector instanceof TinyIntVector) {
                    short value = ((TinyIntVector)fieldVector).get(i);
                    writer.writeInt32((int)value);
                    continue;
                }
                if (fieldVector instanceof BitVector) {
                    int value = ((BitVector)fieldVector).get(i);
                    writer.writeInt32(value);
                    continue;
                }
                if (fieldVector instanceof Decimal256Vector) {
                    Object object = fieldVector.getObject(i);
                    writer.writeString(object.toString());
                    continue;
                }
                throw new JSONException("TODO : " + fieldVector.getClass().getName());
            }
            writer.writeLine();
        }
    }

    private static void writeDecimal(CSVWriter writer, int row, DecimalVector decimalVector) {
        int precision = decimalVector.getPrecision();
        decimalVector.getObject(row);
        if (precision < 20) {
            long unscaleValue;
            long startIndex = (long)row * 16L;
            int scale = decimalVector.getScale();
            ArrowBuf dataBuffer = decimalVector.getDataBuffer();
            if (LITTLE_ENDIAN) {
                unscaleValue = dataBuffer.getLong(startIndex);
            } else {
                long littleEndianValue = dataBuffer.getLong(startIndex + 8L);
                unscaleValue = Long.reverseBytes(littleEndianValue);
            }
            writer.writeDecimal(unscaleValue, scale);
        } else {
            BigDecimal decimal = decimalVector.getObject(row);
            writer.writeDecimal(decimal);
        }
    }

    public static void setValue(FieldVector vector, int row, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (vector instanceof IntVector) {
            ((IntVector)vector).set(row, Integer.parseInt(value));
            return;
        }
        if (vector instanceof BigIntVector) {
            ((BigIntVector)vector).set(row, Long.parseLong(value));
            return;
        }
        if (vector instanceof DecimalVector) {
            DecimalVector decimalVector = (DecimalVector)vector;
            ArrowUtils.setDecimal(decimalVector, row, value);
            return;
        }
        if (vector instanceof DateMilliVector) {
            long millis = DateUtils.parseMillis((String)value);
            ((DateMilliVector)vector).set(row, millis);
            return;
        }
        if (vector instanceof VarCharVector) {
            VarCharVector varCharVector = (VarCharVector)vector;
            ArrowUtils.setString(varCharVector, row, value);
            return;
        }
        if (vector instanceof Float8Vector) {
            double doubleValue = Double.parseDouble(value);
            ((Float8Vector)vector).set(row, doubleValue);
            return;
        }
        if (vector instanceof Float4Vector) {
            float floatValue = Float.parseFloat(value);
            ((Float4Vector)vector).set(row, floatValue);
            return;
        }
        if (vector instanceof TinyIntVector) {
            int intValue = Integer.parseInt(value);
            ((TinyIntVector)vector).set(row, (byte)intValue);
            return;
        }
        if (vector instanceof SmallIntVector) {
            int intValue = Integer.parseInt(value);
            ((SmallIntVector)vector).set(row, (short)intValue);
            return;
        }
        if (vector instanceof TimeStampMilliVector) {
            long millis = DateUtils.parseMillis((String)value);
            ((TimeStampMilliVector)vector).set(row, millis);
            return;
        }
        if (vector instanceof BitVector) {
            boolean booleanValue = Boolean.parseBoolean(value);
            int intValue = booleanValue ? 1 : 0;
            ((BitVector)vector).set(row, intValue);
            return;
        }
        if (vector instanceof Decimal256Vector) {
            BigDecimal decimal = TypeUtils.toBigDecimal((String)value);
            Decimal256Vector decimalVector = (Decimal256Vector)vector;
            int scale = decimalVector.getScale();
            if (decimal.scale() != scale) {
                decimal = decimal.setScale(scale, RoundingMode.CEILING);
            }
            decimalVector.set(row, decimal);
            return;
        }
        throw new JSONException("TODO " + vector.getClass());
    }

    public static void setDecimal(DecimalVector vector, int row, String str) {
        if (str == null || str.isEmpty()) {
            vector.setNull(row);
            return;
        }
        if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            byte[] bytes = (byte[])JDKUtils.STRING_VALUE.apply(str);
            ArrowUtils.setDecimal(vector, row, bytes, 0, bytes.length);
        }
        char[] chars = JDKUtils.getCharArray((String)str);
        ArrowUtils.setDecimal(vector, row, chars, 0, chars.length);
    }

    public static void setString(VarCharVector vector, int row, String str) {
        if (str == null || str.length() == 0) {
            vector.setNull(row);
            return;
        }
        byte[] bytes = JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0 ? (byte[])JDKUtils.STRING_VALUE.apply(str) : str.getBytes(StandardCharsets.UTF_8);
        vector.set(row, bytes);
    }

    public static void setDecimal(DecimalVector vector, int row, char[] bytes, int off, int len) {
        boolean negative = false;
        int j = off;
        if (bytes[off] == '-') {
            negative = true;
            ++j;
        }
        if (len <= 20 || negative && len == 21) {
            int end = off + len;
            int dot = 0;
            int dotIndex = -1;
            long unscaleValue = 0L;
            while (j < end) {
                char b = bytes[j];
                if (b == '.') {
                    if (++dot > 1) break;
                    dotIndex = j;
                } else if (b >= '0' && b <= '9') {
                    unscaleValue = unscaleValue * 10L + (long)(b - 48);
                } else {
                    unscaleValue = -1L;
                    break;
                }
                ++j;
            }
            int scale = 0;
            if (unscaleValue >= 0L && dot <= 1) {
                if (dotIndex != -1) {
                    scale = len - (dotIndex - off) - 1;
                }
                boolean overflow = false;
                long unscaleValueV = unscaleValue;
                int scaleV = vector.getScale();
                if (scaleV > scale) {
                    for (int i = scale; i < scaleV; ++i) {
                        if ((unscaleValueV *= 10L) >= 0L) continue;
                        overflow = true;
                        break;
                    }
                } else if (scaleV < scale) {
                    overflow = true;
                }
                if (!overflow) {
                    if (negative) {
                        unscaleValueV = -unscaleValueV;
                    }
                    BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)row);
                    ArrowBuf dataBuffer = vector.getDataBuffer();
                    long startIndex = (long)row * 16L;
                    if (LITTLE_ENDIAN) {
                        dataBuffer.setLong(startIndex, unscaleValueV);
                    } else {
                        dataBuffer.setLong(startIndex, 0L);
                        long littleEndianValue = Long.reverseBytes(unscaleValueV);
                        dataBuffer.setLong(startIndex + 8L, littleEndianValue);
                    }
                    return;
                }
                if (negative) {
                    unscaleValue = -unscaleValue;
                }
                BigDecimal decimal = BigDecimal.valueOf(unscaleValue, scale);
                if (vector.getScale() != decimal.scale()) {
                    decimal = decimal.setScale(vector.getScale(), RoundingMode.CEILING);
                }
                vector.set(row, decimal);
                return;
            }
        }
        BigDecimal decimal = TypeUtils.parseBigDecimal((char[])bytes, (int)off, (int)len);
        if (vector.getScale() != decimal.scale()) {
            decimal = decimal.setScale(vector.getScale(), RoundingMode.CEILING);
        }
        vector.set(row, decimal);
    }

    public static void setDecimal(DecimalVector vector, int row, byte[] bytes, int off, int len) {
        boolean negative = false;
        int j = off;
        if (bytes[off] == 45) {
            negative = true;
            ++j;
        }
        if (len <= 20 || negative && len == 21) {
            int end = off + len;
            int dot = 0;
            int dotIndex = -1;
            long unscaleValue = 0L;
            while (j < end) {
                byte b = bytes[j];
                if (b == 46) {
                    if (++dot > 1) break;
                    dotIndex = j;
                } else if (b >= 48 && b <= 57) {
                    unscaleValue = unscaleValue * 10L + (long)(b - 48);
                } else {
                    unscaleValue = -1L;
                    break;
                }
                ++j;
            }
            int scale = 0;
            if (unscaleValue >= 0L && dot <= 1) {
                if (dotIndex != -1) {
                    scale = len - (dotIndex - off) - 1;
                }
                boolean overflow = false;
                long unscaleValueV = unscaleValue;
                int scaleV = vector.getScale();
                if (scaleV > scale) {
                    for (int i = scale; i < scaleV; ++i) {
                        if ((unscaleValueV *= 10L) >= 0L) continue;
                        overflow = true;
                        break;
                    }
                } else if (scaleV < scale) {
                    overflow = true;
                }
                if (!overflow) {
                    if (negative) {
                        unscaleValueV = -unscaleValueV;
                    }
                    BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)row);
                    ArrowBuf dataBuffer = vector.getDataBuffer();
                    long startIndex = (long)row * 16L;
                    if (LITTLE_ENDIAN) {
                        dataBuffer.setLong(startIndex, unscaleValueV);
                    } else {
                        dataBuffer.setLong(startIndex, 0L);
                        long littleEndianValue = Long.reverseBytes(unscaleValueV);
                        dataBuffer.setLong(startIndex + 8L, littleEndianValue);
                    }
                    return;
                }
                if (negative) {
                    unscaleValue = -unscaleValue;
                }
                BigDecimal decimal = BigDecimal.valueOf(unscaleValue, scale);
                if (vector.getScale() != decimal.scale()) {
                    decimal = decimal.setScale(vector.getScale(), RoundingMode.CEILING);
                }
                vector.set(row, decimal);
                return;
            }
        }
        BigDecimal decimal = TypeUtils.parseBigDecimal((byte[])bytes, (int)off, (int)len);
        if (vector.getScale() != decimal.scale()) {
            decimal = decimal.setScale(vector.getScale(), RoundingMode.CEILING);
        }
        vector.set(row, decimal);
    }

    public static void setDecimal(DecimalVector vector, int row, BigDecimal decimal) {
        long unscaleValue;
        int precision;
        int scale = vector.getScale();
        if (decimal.scale() != scale) {
            decimal = decimal.setScale(scale, RoundingMode.CEILING);
        }
        if ((precision = decimal.precision()) < 19 && JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET != -1L && (unscaleValue = JDKUtils.UNSAFE.getLong(decimal, JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET)) != Long.MIN_VALUE) {
            BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)row);
            ArrowBuf dataBuffer = vector.getDataBuffer();
            long startIndex = (long)row * 16L;
            if (LITTLE_ENDIAN) {
                dataBuffer.setLong(startIndex, unscaleValue);
            } else {
                dataBuffer.setLong(startIndex, 0L);
                long littleEndianValue = Long.reverseBytes(unscaleValue);
                dataBuffer.setLong(startIndex + 8L, littleEndianValue);
            }
            return;
        }
        vector.set(row, decimal);
    }
}

