/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import org.postgresql.util.PSQLException;

public class ExceptionLineAnnotator {
    private static final int DISPLAY_SIZE = 60;
    private static final int MIN_RIGHT_CUT = 10;

    public static PSQLException annotateWithErrorLine(PSQLException e, String sql) {
        String lineError = ExceptionLineAnnotator.convertPGErrorPosition2Line(e, sql);
        if (lineError == null) {
            return e;
        }
        return new PSQLException(e.toString() + lineError, e, e.getSQLState());
    }

    private static String convertPGErrorPosition2Line(PSQLException e, String sql) {
        if (e == null) {
            return null;
        }
        if (sql == null || sql.isEmpty()) {
            return null;
        }
        if (e.getServerErrorMessage() == null) {
            return null;
        }
        int position = e.getServerErrorMessage().getPosition();
        if (position <= 0 || position > sql.length()) {
            return null;
        }
        --position;
        StringBuffer querySB = new StringBuffer(sql);
        int locLine = 1;
        int iBeg = 0;
        int iEnd = -1;
        for (int index = 0; index < querySB.length(); ++index) {
            char ch = querySB.charAt(index);
            if ('\t' == ch) {
                querySB.setCharAt(index, ' ');
                continue;
            }
            if ('\r' != ch && '\n' != ch) continue;
            if (index < position) {
                if ('\r' == ch || index == 0 || '\r' != querySB.charAt(index - 1)) {
                    ++locLine;
                }
                iBeg = index + 1;
                continue;
            }
            iEnd = index;
            break;
        }
        if (iEnd < 0) {
            iEnd = querySB.length();
        }
        if (iEnd > position && position >= iBeg) {
            int i;
            boolean begTrunc = false;
            boolean endTrunc = false;
            if (iEnd - iBeg > 60) {
                if (iBeg + 60 >= position + 10) {
                    if (iEnd - iBeg > 60) {
                        iEnd = 60 + iBeg;
                    }
                    endTrunc = true;
                } else {
                    if (position + 10 < iEnd) {
                        iEnd = position + 10;
                        endTrunc = true;
                    }
                    if (iEnd - iBeg > 60) {
                        iBeg = iEnd - 60;
                        begTrunc = true;
                    }
                }
            }
            StringBuffer messageSB = new StringBuffer();
            messageSB.append('\n');
            int leadingSpaceCount = ExceptionLineAnnotator.getLeadingSpace(e.getMessage());
            StringBuffer hintMsg = new StringBuffer(String.format("%" + leadingSpaceCount + "sLINE %d: ", " ", locLine));
            if (begTrunc) {
                hintMsg = hintMsg.append("...");
            }
            messageSB.append(hintMsg);
            sql = querySB.toString();
            messageSB.append(sql.substring(iBeg, iEnd));
            if (endTrunc) {
                messageSB = messageSB.append("...");
            }
            messageSB = messageSB.append("\n");
            for (i = 0; i < hintMsg.length(); ++i) {
                messageSB.append(' ');
            }
            for (i = 0; i < position - iBeg; ++i) {
                messageSB.append(' ');
            }
            messageSB.append("^\n");
            return messageSB.toString();
        }
        return null;
    }

    private static int getLeadingSpace(String message) {
        if (message == null) {
            return 0;
        }
        String[] msgArr = message.split("\n");
        if (msgArr == null || msgArr.length == 0) {
            return 0;
        }
        String msgLastLine = msgArr[msgArr.length - 1];
        boolean spaceCount = false;
        for (int i = 0; i < msgLastLine.length(); ++i) {
            char c = msgLastLine.charAt(i);
            if (c == ' ') continue;
            return i;
        }
        return 0;
    }
}

