/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.sql.SQLException;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;

public class PgDefaultBinaryObject
extends PGobject
implements PGBinaryObject {
    int length = 0;
    byte[] bytes = null;

    public PgDefaultBinaryObject(String type) {
        this.type = type;
    }

    @Override
    public void setByteValue(byte[] bytes, int i) throws SQLException {
        this.length = bytes.length - i;
        if (this.bytes == null || this.bytes.length < this.length) {
            this.bytes = new byte[this.length];
        }
        System.arraycopy(bytes, i, this.bytes, 0, this.length);
    }

    @Override
    public int lengthInBytes() {
        return this.length;
    }

    @Override
    public void toBytes(byte[] bytes, int i) {
        System.arraycopy(this.bytes, 0, bytes, i, this.length);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PgDefaultBinaryObject ret = new PgDefaultBinaryObject(this.type);
        ret.length = this.length;
        ret.bytes = new byte[this.length];
        System.arraycopy(this.bytes, 0, ret.bytes, 0, this.length);
        return ret;
    }

    @Override
    public String getValue() {
        throw new UnsupportedOperationException("Unsupported type " + this.type + " input byte[]");
    }
}

