/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.core.SqlCommandType;
import org.postgresql.model.ParsedQuery;
import org.postgresql.model.TableName;
import org.postgresql.util.FunctionWithSQLException;

public class QueryParser
implements FunctionWithSQLException<String, ParsedQuery> {
    private static final QueryParser parser = new QueryParser();
    private static final Pattern INSERT_PATTERN = Pattern.compile("\\s*insert\\s+into\\s+([^ \\(]*)\\s*(?:\\(([^\\)]*)\\))?\\s+values\\s*\\((\\?(?:::\\S+)?(?:\\s*,\\s*\\?(?:::\\S+)?)*)\\)", 2);
    private static final Pattern UPDATE_PATTERN = Pattern.compile("\\s*update\\s+([^ ]*)\\s+set", 2);
    private static final Pattern DELETE_PATTERN = Pattern.compile("\\s*delete\\s+from\\s+([^ ]*)\\s+", 2);

    public static QueryParser instance() {
        return parser;
    }

    private void handleTableName(ParsedQuery query, Matcher m) {
        query.setTableNameStart(m.start(1));
        query.setTableNameEnd(m.end(1));
        String text = m.group(1);
        query.setTableNameObj(TableName.valueOf(text));
    }

    private void handleInsertColumns(ParsedQuery query, Matcher m) {
        String insertColumns = m.group(2);
        String insertValues = m.group(3);
        int count = insertValues.split(",").length;
        query.setInsertValueCount(count);
        if (insertColumns != null) {
            String[] columns = insertColumns.split(",");
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = this.unQuotaString(columns[i].trim());
            }
            query.setInsertColumns(columns);
        }
    }

    private String unQuotaString(String str) {
        if (str.startsWith("\"") && str.length() > 2) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    @Override
    public ParsedQuery apply(String s) {
        Matcher m;
        ParsedQuery query = new ParsedQuery();
        query.setOrigin(s);
        query.setType(null);
        if (s.startsWith("insert ") || s.startsWith("INSERT ")) {
            Matcher m2 = INSERT_PATTERN.matcher(s);
            if (m2.find()) {
                query.setType(SqlCommandType.INSERT);
                this.handleTableName(query, m2);
                this.handleInsertColumns(query, m2);
            }
        } else if (s.startsWith("update ") || s.startsWith("UPDATE ")) {
            Matcher m3 = UPDATE_PATTERN.matcher(s);
            if (m3.find()) {
                query.setType(SqlCommandType.UPDATE);
                this.handleTableName(query, m3);
            }
        } else if ((s.startsWith("delete ") || s.startsWith("DELETE ")) && (m = UPDATE_PATTERN.matcher(s)).find()) {
            query.setType(SqlCommandType.UPDATE);
            this.handleTableName(query, m);
        }
        return query;
    }
}

