/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util.cache;

import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.postgresql.util.FunctionWithSQLException;

public class Cache<K, V> {
    public static final int MODE_NO_CACHE = 1;
    public static final int MODE_ONLY_CACHE = 2;
    public static final int MODE_LOCAL_THEN_REMOTE = 0;
    Map<K, Item> cache = new ConcurrentHashMap<K, Item>();
    FunctionWithSQLException<K, V> builder;
    private long ttl;

    public Cache() {
        this(null);
    }

    public Cache(FunctionWithSQLException<K, V> builder) {
        this(-1L, builder);
    }

    public Cache(long ttl, FunctionWithSQLException<K, V> builder) {
        this.ttl = ttl;
        this.builder = builder;
    }

    public Set<K> filterKeys(long remainLifeTime) {
        long current = System.currentTimeMillis();
        return this.cache.entrySet().stream().filter(entry -> !((Item)entry.getValue()).isExpire(current) && ((Item)entry.getValue()).isAccessed() && this.ttl - ((Item)entry.getValue()).getAge(current) < remainLifeTime).map(entry -> entry.getKey()).collect(Collectors.toSet());
    }

    public void setBuilder(FunctionWithSQLException<K, V> builder) {
        this.builder = builder;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public V get(K key) throws SQLException {
        return this.get(key, null);
    }

    public V get(K key, FunctionWithSQLException<K, V> builder) throws SQLException {
        return this.get(key, builder, 0);
    }

    public V get(K key, FunctionWithSQLException<K, V> builder, int mode) throws SQLException {
        FunctionWithSQLException<K, V> internalBuilder = builder == null ? this.builder : builder;
        Item item = null;
        if (mode == 2) {
            item = this.cache.get(key);
            if (item != null && !item.isExpire()) {
                item.setAccessed(true);
            } else {
                item = null;
            }
        } else {
            try {
                item = this.cache.compute(key, (k, old) -> {
                    if (1 == mode || old == null || old.isExpire()) {
                        try {
                            Object value = internalBuilder.apply(k);
                            if (value != null) {
                                return new Item(value);
                            }
                            return null;
                        }
                        catch (SQLException throwables) {
                            throw new FunctionRuntimeException(throwables);
                        }
                    }
                    old.setAccessed(true);
                    return old;
                });
            }
            catch (FunctionRuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException(cause);
            }
        }
        if (item == null) {
            return null;
        }
        return item.get();
    }

    public void put(K key, V value) {
        if (value != null) {
            this.cache.put(key, new Item(value));
        }
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    class Item {
        V value;
        long createTime;
        boolean accessed;

        Item(V value) {
            this.value = value;
            this.createTime = System.currentTimeMillis();
            this.accessed = false;
        }

        public void setAccessed(boolean accessed) {
            this.accessed = accessed;
        }

        public boolean isAccessed() {
            return this.accessed;
        }

        public V get() {
            return this.value;
        }

        public boolean isExpire() {
            return this.isExpire(System.currentTimeMillis());
        }

        public boolean isExpire(long current) {
            if (Cache.this.ttl < 1L) {
                return false;
            }
            return this.getAge(current) > Cache.this.ttl;
        }

        public long getAge(long current) {
            return current - this.createTime;
        }
    }

    static class FunctionRuntimeException
    extends RuntimeException {
        FunctionRuntimeException(Throwable cause) {
            super(cause);
        }
    }
}

