/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics;

import com.alibaba.metrics.ClusterHistogram;
import com.alibaba.metrics.Compass;
import com.alibaba.metrics.Counter;
import com.alibaba.metrics.DynamicMetricSet;
import com.alibaba.metrics.FastCompass;
import com.alibaba.metrics.Gauge;
import com.alibaba.metrics.Histogram;
import com.alibaba.metrics.IMetricManager;
import com.alibaba.metrics.Meter;
import com.alibaba.metrics.Metric;
import com.alibaba.metrics.MetricFilter;
import com.alibaba.metrics.MetricManager;
import com.alibaba.metrics.MetricName;
import com.alibaba.metrics.MetricRegistry;
import com.alibaba.metrics.MetricRegistryImpl;
import com.alibaba.metrics.ReservoirType;
import com.alibaba.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class AliMetricManager
implements IMetricManager {
    private static final SortedMap emptySortedMap = new TreeMap();
    private Map<String, MetricRegistry> metricRegistryMap = new ConcurrentHashMap<String, MetricRegistry>();
    private volatile boolean enabled = true;

    public Meter getMeter(String group, MetricName name) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getMeter(group, name);
        }
        return this.getMetricRegistryByGroup(group).meter(name);
    }

    public Counter getCounter(String group, MetricName name) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getCounter(group, name);
        }
        return this.getMetricRegistryByGroup(group).counter(name);
    }

    public Histogram getHistogram(String group, MetricName name) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getHistogram(group, name);
        }
        return this.getMetricRegistryByGroup(group).histogram(name);
    }

    public Histogram getHistogram(String group, MetricName name, ReservoirType type) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getHistogram(group, name, type);
        }
        return this.getMetricRegistryByGroup(group).histogram(name, type);
    }

    public Timer getTimer(String group, MetricName name) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getTimer(group, name);
        }
        return this.getMetricRegistryByGroup(group).timer(name);
    }

    public Timer getTimer(String group, MetricName name, ReservoirType type) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getTimer(group, name, type);
        }
        return this.getMetricRegistryByGroup(group).timer(name, type);
    }

    public Compass getCompass(String group, MetricName name) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getCompass(group, name);
        }
        return this.getMetricRegistryByGroup(group).compass(name);
    }

    public Compass getCompass(String group, MetricName name, ReservoirType type) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getCompass(group, name, type);
        }
        return this.getMetricRegistryByGroup(group).compass(name, type);
    }

    public FastCompass getFastCompass(String group, MetricName name) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getFastCompass(group, name);
        }
        return this.getMetricRegistryByGroup(group).fastCompass(name);
    }

    public ClusterHistogram getClusterHistogram(String group, MetricName name, long[] buckets) {
        if (!this.enabled) {
            return MetricManager.NOP_METRIC_MANAGER.getClusterHistogram(group, name, buckets);
        }
        return this.getMetricRegistryByGroup(group).clusterHistogram(name, buckets);
    }

    public List<String> listMetricGroups() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        ArrayList<String> groups = new ArrayList<String>();
        groups.addAll(this.metricRegistryMap.keySet());
        return groups;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, Set<MetricName>> listMetricNamesByGroup() {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<MetricName>> result = new HashMap<String, Set<MetricName>>();
        for (Map.Entry<String, MetricRegistry> entry : this.metricRegistryMap.entrySet()) {
            TreeSet metricNames = new TreeSet();
            for (Map.Entry metricEntry : entry.getValue().getMetrics().entrySet()) {
                metricNames.add(metricEntry.getKey());
            }
            result.put(entry.getKey(), metricNames);
        }
        return result;
    }

    public MetricRegistry getMetricRegistryByGroup(String group) {
        if (!this.metricRegistryMap.containsKey(group)) {
            this.metricRegistryMap.put(group, new MetricRegistryImpl());
        }
        return this.metricRegistryMap.get(group);
    }

    public SortedMap<MetricName, Gauge> getGauges(String group, MetricFilter filter) {
        if (!this.enabled) {
            return emptySortedMap;
        }
        MetricRegistry metricRegistry = this.getMetricRegistryByGroup(group);
        if (metricRegistry == null) {
            return emptySortedMap;
        }
        return metricRegistry.getGauges(filter);
    }

    public SortedMap<MetricName, Counter> getCounters(String group, MetricFilter filter) {
        if (!this.enabled) {
            return emptySortedMap;
        }
        MetricRegistry metricRegistry = this.getMetricRegistryByGroup(group);
        if (metricRegistry == null) {
            return emptySortedMap;
        }
        return metricRegistry.getCounters(filter);
    }

    public SortedMap<MetricName, Histogram> getHistograms(String group, MetricFilter filter) {
        if (!this.enabled) {
            return emptySortedMap;
        }
        MetricRegistry metricRegistry = this.getMetricRegistryByGroup(group);
        if (metricRegistry == null) {
            return emptySortedMap;
        }
        return metricRegistry.getHistograms(filter);
    }

    public SortedMap<MetricName, Meter> getMeters(String group, MetricFilter filter) {
        if (!this.enabled) {
            return emptySortedMap;
        }
        MetricRegistry metricRegistry = this.getMetricRegistryByGroup(group);
        if (metricRegistry == null) {
            return emptySortedMap;
        }
        return metricRegistry.getMeters(filter);
    }

    public SortedMap<MetricName, Timer> getTimers(String group, MetricFilter filter) {
        if (!this.enabled) {
            return emptySortedMap;
        }
        MetricRegistry metricRegistry = this.getMetricRegistryByGroup(group);
        if (metricRegistry == null) {
            return emptySortedMap;
        }
        return metricRegistry.getTimers(filter);
    }

    public SortedMap<MetricName, Compass> getCompasses(String group, MetricFilter filter) {
        if (!this.enabled) {
            return emptySortedMap;
        }
        MetricRegistry metricRegistry = this.getMetricRegistryByGroup(group);
        if (metricRegistry == null) {
            return emptySortedMap;
        }
        return metricRegistry.getCompasses(filter);
    }

    public SortedMap<MetricName, FastCompass> getFastCompasses(String group, MetricFilter filter) {
        if (!this.enabled) {
            return emptySortedMap;
        }
        MetricRegistry metricRegistry = this.getMetricRegistryByGroup(group);
        if (metricRegistry == null) {
            return emptySortedMap;
        }
        return metricRegistry.getFastCompasses(filter);
    }

    public SortedMap<MetricName, ClusterHistogram> getClusterHistogram(String group, MetricFilter filter) {
        if (!this.enabled) {
            return emptySortedMap;
        }
        MetricRegistry metricRegistry = this.getMetricRegistryByGroup(group);
        if (metricRegistry == null) {
            return emptySortedMap;
        }
        return metricRegistry.getClusterHistograms(filter);
    }

    public void register(String group, MetricName name, Metric metric) {
        if (!this.enabled) {
            return;
        }
        MetricRegistry metricRegistry = this.getMetricRegistryByGroup(group);
        metricRegistry.register(name, metric);
    }

    public Map<MetricName, Metric> getMetrics(String group) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        MetricRegistry metricRegistry = this.metricRegistryMap.get(group);
        if (metricRegistry != null) {
            return metricRegistry.getMetrics();
        }
        return Collections.emptyMap();
    }

    public Map<Class<? extends Metric>, Map<MetricName, ? extends Metric>> getCategoryMetrics(String group) {
        return this.getCategoryMetrics(group, MetricFilter.ALL);
    }

    public Map<Class<? extends Metric>, Map<MetricName, ? extends Metric>> getCategoryMetrics(String group, MetricFilter filter) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        MetricRegistry metricRegistry = this.metricRegistryMap.get(group);
        Map metrics = metricRegistry.getMetrics();
        return this.getCategoryMetrics(metrics, filter);
    }

    public Map<Class<? extends Metric>, Map<MetricName, ? extends Metric>> getAllCategoryMetrics(MetricFilter filter) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        HashMap<Class<? extends Metric>, Map<MetricName, ? extends Metric>> result = new HashMap<Class<? extends Metric>, Map<MetricName, ? extends Metric>>();
        HashMap<MetricName, Gauge> gauges = new HashMap<MetricName, Gauge>();
        HashMap<MetricName, Counter> counters = new HashMap<MetricName, Counter>();
        HashMap<MetricName, Histogram> histograms = new HashMap<MetricName, Histogram>();
        HashMap<MetricName, Meter> meters = new HashMap<MetricName, Meter>();
        HashMap<MetricName, Timer> timers = new HashMap<MetricName, Timer>();
        HashMap<MetricName, Compass> compasses = new HashMap<MetricName, Compass>();
        HashMap<MetricName, FastCompass> fastCompasses = new HashMap<MetricName, FastCompass>();
        HashMap<MetricName, ClusterHistogram> clusterHistogrames = new HashMap<MetricName, ClusterHistogram>();
        for (Map.Entry<String, MetricRegistry> entry : this.metricRegistryMap.entrySet()) {
            MetricRegistry metricRegistry = entry.getValue();
            Map metrics = metricRegistry.getMetrics();
            for (Map.Entry<MetricName, Metric> entry2 : metrics.entrySet()) {
                this.checkAndAdd(entry2, filter, gauges, counters, histograms, meters, timers, compasses, fastCompasses, clusterHistogrames);
            }
        }
        result.put(Gauge.class, gauges);
        result.put(Counter.class, counters);
        result.put(Histogram.class, histograms);
        result.put(Meter.class, meters);
        result.put(Timer.class, timers);
        result.put(Compass.class, compasses);
        result.put(FastCompass.class, fastCompasses);
        result.put(ClusterHistogram.class, clusterHistogrames);
        return result;
    }

    private Map<Class<? extends Metric>, Map<MetricName, ? extends Metric>> getCategoryMetrics(Map<MetricName, Metric> metrics, MetricFilter filter) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        HashMap<Class<? extends Metric>, Map<MetricName, ? extends Metric>> result = new HashMap<Class<? extends Metric>, Map<MetricName, ? extends Metric>>();
        HashMap<MetricName, Gauge> gauges = new HashMap<MetricName, Gauge>();
        HashMap<MetricName, Counter> counters = new HashMap<MetricName, Counter>();
        HashMap<MetricName, Histogram> histograms = new HashMap<MetricName, Histogram>();
        HashMap<MetricName, Meter> meters = new HashMap<MetricName, Meter>();
        HashMap<MetricName, Timer> timers = new HashMap<MetricName, Timer>();
        HashMap<MetricName, Compass> compasses = new HashMap<MetricName, Compass>();
        HashMap<MetricName, FastCompass> fastCompasses = new HashMap<MetricName, FastCompass>();
        HashMap<MetricName, ClusterHistogram> clusterHistogrames = new HashMap<MetricName, ClusterHistogram>();
        for (Map.Entry<MetricName, Metric> entry : metrics.entrySet()) {
            this.checkAndAdd(entry, filter, gauges, counters, histograms, meters, timers, compasses, fastCompasses, clusterHistogrames);
        }
        result.put(Gauge.class, gauges);
        result.put(Counter.class, counters);
        result.put(Histogram.class, histograms);
        result.put(Meter.class, meters);
        result.put(Timer.class, timers);
        result.put(Compass.class, compasses);
        result.put(FastCompass.class, fastCompasses);
        result.put(ClusterHistogram.class, clusterHistogrames);
        return result;
    }

    private void checkAndAdd(Map.Entry<MetricName, Metric> entry, MetricFilter filter, Map<MetricName, Gauge> gauges, Map<MetricName, Counter> counters, Map<MetricName, Histogram> histograms, Map<MetricName, Meter> meters, Map<MetricName, Timer> timers, Map<MetricName, Compass> compasses, Map<MetricName, FastCompass> fastCompasses, Map<MetricName, ClusterHistogram> clusterHistogrames) {
        MetricName metricName = entry.getKey();
        Metric metric = entry.getValue();
        if (metric instanceof Gauge && filter.matches(metricName, metric)) {
            gauges.put(metricName, (Gauge)metric);
        } else if (metric instanceof Counter && filter.matches(metricName, metric)) {
            counters.put(metricName, (Counter)metric);
        } else if (metric instanceof Histogram && filter.matches(metricName, metric)) {
            histograms.put(metricName, (Histogram)metric);
        } else if (metric instanceof Meter && filter.matches(metricName, metric)) {
            meters.put(metricName, (Meter)metric);
        } else if (metric instanceof Timer && filter.matches(metricName, metric)) {
            timers.put(metricName, (Timer)metric);
        } else if (metric instanceof Compass && filter.matches(metricName, metric)) {
            compasses.put(metricName, (Compass)metric);
        } else if (metric instanceof FastCompass && filter.matches(metricName, metric)) {
            fastCompasses.put(metricName, (FastCompass)metric);
        } else if (metric instanceof ClusterHistogram && filter.matches(metricName, metric)) {
            clusterHistogrames.put(metricName, (ClusterHistogram)metric);
        } else if (metric instanceof DynamicMetricSet) {
            DynamicMetricSet dynamicMetricSet = (DynamicMetricSet)metric;
            Map dynamicMetrics = dynamicMetricSet.getDynamicMetrics();
            for (Map.Entry<MetricName, Metric> entry2 : dynamicMetrics.entrySet()) {
                this.checkAndAdd(entry2, filter, gauges, counters, histograms, meters, timers, compasses, fastCompasses, clusterHistogrames);
            }
        }
    }

    public void clear() {
        this.metricRegistryMap.clear();
    }
}

