/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics;

import com.alibaba.metrics.BucketCounter;
import com.alibaba.metrics.BucketCounterImpl;
import com.alibaba.metrics.Clock;
import com.alibaba.metrics.ClusterHistogram;
import java.util.HashMap;
import java.util.Map;

public class ClusterHistogramImpl
extends ClusterHistogram {
    private static final int DEFAULT_NUM_OF_BUCKETS = 5;
    private BucketCounter[] values;

    public ClusterHistogramImpl(int interval, Clock clock) {
        this(null, interval, clock);
    }

    public ClusterHistogramImpl(long[] buckets, int interval, Clock clock) {
        super(buckets);
        this.values = new BucketCounter[buckets.length + 1];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new BucketCounterImpl(interval, 5, clock, false);
        }
    }

    public void update(long value) {
        int low = 0;
        int high = this.buckets.length - 1;
        int i = 0;
        while (low <= high) {
            i = low + (high - low) / 2;
            if (value < this.buckets[i] && (i == 0 || value >= this.buckets[i - 1])) {
                this.values[i].update();
                break;
            }
            if (value >= this.buckets[i]) {
                low = i + 1;
                continue;
            }
            high = i - 1;
        }
    }

    public Map<Long, Map<Long, Long>> getBucketValues(long startTime) {
        HashMap<Long, Map<Long, Long>> result = new HashMap<Long, Map<Long, Long>>();
        for (int i = 0; i < this.values.length; ++i) {
            Map counts = this.values[i].getBucketCounts(startTime);
            for (Map.Entry entry : counts.entrySet()) {
                if (!result.containsKey(entry.getKey())) {
                    result.put((Long)entry.getKey(), new HashMap());
                }
                Map bucketAndValue = (Map)result.get(entry.getKey());
                bucketAndValue.put(this.buckets[i], entry.getValue());
            }
        }
        return result;
    }

    public long lastUpdateTime() {
        long latest = 0L;
        for (BucketCounter value : this.values) {
            if (value.lastUpdateTime() <= latest) continue;
            latest = value.lastUpdateTime();
        }
        return latest;
    }
}

