/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics;

import com.alibaba.metrics.BucketCounter;
import com.alibaba.metrics.BucketCounterImpl;
import com.alibaba.metrics.Clock;
import com.alibaba.metrics.FastCompass;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FastCompassImpl
implements FastCompass {
    private static final long COUNT_OFFSET = 38L;
    private static final long COUNT_BASE = 0x4000000000L;
    private static final long RT_BITWISE_AND_BASE = 0x3FFFFFFFFFL;
    private static final int MAX_SUBCATEGORY_SIZE = Integer.getInteger("com.alibaba.metrics.maxSubCategoryCount", 20);
    private static final int DEFAULT_BUCKET_COUNT = 10;
    private int bucketInterval;
    private int numberOfBuckets;
    private Clock clock;
    private int maxCategoryCount;
    private final ConcurrentHashMap<String, BucketCounter> subCategories;

    public FastCompassImpl(int bucketInterval) {
        this(bucketInterval, 10, Clock.defaultClock(), MAX_SUBCATEGORY_SIZE);
    }

    public FastCompassImpl(int bucketInterval, int numberOfBuckets, Clock clock, int maxCategoryCount) {
        this.bucketInterval = bucketInterval;
        this.numberOfBuckets = numberOfBuckets;
        this.clock = clock;
        this.maxCategoryCount = maxCategoryCount;
        this.subCategories = new ConcurrentHashMap();
    }

    public void record(long duration, String subCategory) {
        if (duration < 0L || subCategory == null) {
            return;
        }
        if (!this.subCategories.containsKey(subCategory)) {
            if (this.subCategories.size() >= this.maxCategoryCount) {
                return;
            }
            this.subCategories.putIfAbsent(subCategory, new BucketCounterImpl(this.bucketInterval, this.numberOfBuckets, this.clock, false));
        }
        long data = 0x4000000000L + duration;
        this.subCategories.get(subCategory).update(data);
    }

    public Map<String, Map<Long, Long>> getMethodCountPerCategory() {
        return this.getMethodCountPerCategory(0L);
    }

    public Map<String, Map<Long, Long>> getMethodRtPerCategory() {
        return this.getMethodRtPerCategory(0L);
    }

    public Map<String, Map<Long, Long>> getMethodCountPerCategory(long startTime) {
        HashMap<String, Map<Long, Long>> countPerCategory = new HashMap<String, Map<Long, Long>>();
        for (Map.Entry<String, BucketCounter> entry : this.subCategories.entrySet()) {
            HashMap bucketCount = new HashMap();
            for (Map.Entry bucket : entry.getValue().getBucketCounts(startTime).entrySet()) {
                bucketCount.put(bucket.getKey(), (Long)bucket.getValue() >> 38);
            }
            countPerCategory.put(entry.getKey(), bucketCount);
        }
        return countPerCategory;
    }

    public Map<String, Map<Long, Long>> getMethodRtPerCategory(long startTime) {
        HashMap<String, Map<Long, Long>> rtPerCategory = new HashMap<String, Map<Long, Long>>();
        for (Map.Entry<String, BucketCounter> entry : this.subCategories.entrySet()) {
            HashMap bucketCount = new HashMap();
            for (Map.Entry bucket : entry.getValue().getBucketCounts(startTime).entrySet()) {
                bucketCount.put(bucket.getKey(), (Long)bucket.getValue() & 0x3FFFFFFFFFL);
            }
            rtPerCategory.put(entry.getKey(), bucketCount);
        }
        return rtPerCategory;
    }

    public int getBucketInterval() {
        return this.bucketInterval;
    }

    public Map<String, Map<Long, Long>> getCountAndRtPerCategory() {
        return this.getCountAndRtPerCategory(0L);
    }

    public Map<String, Map<Long, Long>> getCountAndRtPerCategory(long startTime) {
        HashMap<String, Map<Long, Long>> countAndRtPerCategory = new HashMap<String, Map<Long, Long>>();
        for (Map.Entry<String, BucketCounter> entry : this.subCategories.entrySet()) {
            HashMap bucketCount = new HashMap();
            for (Map.Entry bucket : entry.getValue().getBucketCounts(startTime).entrySet()) {
                bucketCount.put(bucket.getKey(), bucket.getValue());
            }
            countAndRtPerCategory.put(entry.getKey(), bucketCount);
        }
        return countAndRtPerCategory;
    }

    public long lastUpdateTime() {
        long latest = 0L;
        for (Map.Entry<String, BucketCounter> entry : this.subCategories.entrySet()) {
            if (latest >= entry.getValue().lastUpdateTime()) continue;
            latest = entry.getValue().lastUpdateTime();
        }
        return latest;
    }
}

