/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics;

import com.alibaba.metrics.BucketCounterImpl;
import com.alibaba.metrics.Clock;
import com.alibaba.metrics.EWMA;
import com.alibaba.metrics.LongAdder;
import com.alibaba.metrics.Meter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MeterImpl
implements Meter {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private static final int DEFAULT_NUM_OF_BUCKET = Integer.getInteger("com.alibaba.metrics.numberOfBucket", 10);
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
    private final long startTime;
    private final AtomicLong lastTick;
    private final Clock clock;
    private final BucketCounterImpl bucketCounter;
    private final LongAdder uncounted = new LongAdder();

    public MeterImpl() {
        this(Clock.defaultClock(), DEFAULT_NUM_OF_BUCKET, 60);
    }

    public MeterImpl(int interval) {
        this(Clock.defaultClock(), DEFAULT_NUM_OF_BUCKET, interval);
    }

    public MeterImpl(Clock clock) {
        this(clock, DEFAULT_NUM_OF_BUCKET, 60);
    }

    public MeterImpl(Clock clock, int interval) {
        this(clock, DEFAULT_NUM_OF_BUCKET, interval);
    }

    public MeterImpl(Clock clock, int numberOfBucket, int interval) {
        this.clock = clock;
        this.startTime = this.clock.getTick();
        this.lastTick = new AtomicLong(this.startTime);
        this.bucketCounter = new BucketCounterImpl(interval, numberOfBucket, clock);
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.tickIfNecessary();
        this.uncounted.add(n);
        this.bucketCounter.update(n);
    }

    private void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.getTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                long count = this.uncounted.sumThenReset();
                this.m1Rate.tick(count);
                this.m5Rate.tick(count);
                this.m15Rate.tick(count);
            }
        }
    }

    public long getCount() {
        return this.bucketCounter.getCount();
    }

    public Map<Long, Long> getInstantCount() {
        return this.bucketCounter.getBucketCounts();
    }

    public Map<Long, Long> getInstantCount(long startTime) {
        return this.bucketCounter.getBucketCounts(startTime);
    }

    public int getInstantCountInterval() {
        return this.bucketCounter.getBucketInterval();
    }

    public double getFifteenMinuteRate() {
        this.tickIfNecessary();
        return this.m15Rate.getRate(TimeUnit.SECONDS);
    }

    public double getFiveMinuteRate() {
        this.tickIfNecessary();
        return this.m5Rate.getRate(TimeUnit.SECONDS);
    }

    public double getMeanRate() {
        if (this.getCount() == 0L) {
            return 0.0;
        }
        double elapsed = this.clock.getTick() - this.startTime;
        return (double)this.getCount() / elapsed * (double)TimeUnit.SECONDS.toNanos(1L);
    }

    public double getOneMinuteRate() {
        this.tickIfNecessary();
        return this.m1Rate.getRate(TimeUnit.SECONDS);
    }

    public long lastUpdateTime() {
        return this.bucketCounter.lastUpdateTime();
    }
}

