/* TermInfoParser.java */
/* Generated By:JavaCC: Do not edit this line. TermInfoParser.java */
package io.termd.core.term;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TermInfoParser implements TermInfoParserConstants {

  public TermInfoParser(String s) {
    this(new java.io.StringReader(s));
  }

  public List<String> parseHeaderLine() throws ParseException {
    final List<String> headerLine = new ArrayList<String>();
    parseHeaderLine(new ParserHandler() {
      public void beginHeaderLine(String alias) { headerLine.add(alias); }
      public void addHeader(String alias) { headerLine.add(alias); }
    });
    return headerLine;
  }

  public void parseFeatureLine() throws ParseException {
    parseFeatureLine(new ParserHandler());
  }

  public void parseDevice() throws ParseException {
    parseDevice(new ParserHandler());
  }

  public void parseDatabase() throws ParseException {
    parseDatabase(new ParserHandler());
  }

  private String convertControlChar(String s) {
    char c = s.charAt(0);
    if (c >= 64) {
      if (c >= 'a' && c <= 'z') {
        c = (char)(c - 'a' + 'A' - 64);
      } else {
        c -= 64;
      }
      return String.valueOf(c);
    } else {
        throw new UnsupportedOperationException("Invalid control :" + s);
    }
  }

  private String convertEscChar(String s) {
    char c = s.charAt(0);
    switch (c) {
      case 'e':
      case 'E':
        c = 27;
        break;
      case 'a':
        c = 7;
        break;
      case 'b':
        c = 8;
        break;
      case 'r':
        c = '\r';
        break;
      case 'n':
        c = '\n';
        break;
      case 't':
        c = '\t';
        break;
      case 'f':
        c = 12;
        break;
      case 'A':
        c = 1;
        break;
      case ':':
      case ',':
      case '^':
      case '\\':
        break;
      case 's':
        c = ' ';
        break;
      default:
        throw new UnsupportedOperationException("Invalid escape :" + s);
    }
    return String.valueOf(c);
  }

  public Sequence parseSequence() throws ParseException {
    token_source.SwitchTo(PARSING_FEATURE_VALUE);
    final Sequence[] ref = new Sequence[1];
    parseStringFeature("", new ParserHandler() {
      public void addStringFeature(String name, Sequence value) {
        ref[0] = value;
      }
    });
    return ref[0];
  }

  // For testing purposes we switch the lexical state before
  public OpCode parseSingleOpCode() throws ParseException {
    token_source.SwitchTo(PARSING_STRING_VALUE);
    return parseChar();
  }

  final public void parseDatabase(ParserHandler handler) throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case START_HEADER_LINE:
      case START_COMMENT_LINE:
      case EMPTY_LINE:{
        ;
        break;
        }
      default:
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case START_HEADER_LINE:{
        parseDevice(handler);
        break;
        }
      case START_COMMENT_LINE:{
        parseCommentLine();
        break;
        }
      case EMPTY_LINE:{
        jj_consume_token(EMPTY_LINE);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
handler.endDatabase();
  }

  final public void parseDevice(ParserHandler handler) throws ParseException {
    parseHeaderLine(handler);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case START_FEATURE_LINE:{
        ;
        break;
        }
      default:
        break label_2;
      }
      parseFeatureLine(handler);
    }
handler.endDevice();
  }

  final public void parseCommentLine() throws ParseException {
    jj_consume_token(START_COMMENT_LINE);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ANY_CHAR:{
        ;
        break;
        }
      default:
        break label_3;
      }
      jj_consume_token(ANY_CHAR);
    }
    jj_consume_token(END_COMMENT_LINE);
  }

  final public void parseHeaderLine(ParserHandler handler) throws ParseException {Token alias;
    alias = jj_consume_token(START_HEADER_LINE);
handler.beginHeaderLine(alias.image);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case START_HEADER:{
        ;
        break;
        }
      default:
        break label_4;
      }
      jj_consume_token(START_HEADER);
      alias = jj_consume_token(HEADER_VALUE);
handler.addHeader(alias.image);
    }
    jj_consume_token(END_HEADER_LINE);
handler.endHeaderLine();
  }

  final public void parseFeatureLine(ParserHandler handler) throws ParseException {
    jj_consume_token(START_FEATURE_LINE);
    label_5:
    while (true) {
      parseFeature(handler);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case START_FEATURE:{
        ;
        break;
        }
      default:
        break label_5;
      }
    }
    jj_consume_token(END_FEATURE_LINE);
  }

  final public void parseFeature(ParserHandler handler) throws ParseException {Token name;
    name = jj_consume_token(START_FEATURE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case END_BOOLEAN_VALUE:{
      parseBooleanFeature(name.image, handler);
      break;
      }
    case START_STRING_VALUE:{
      parseStringFeature(name.image, handler);
      break;
      }
    case START_NUMERIC_VALUE:{
      parseNumericFeature(name.image, handler);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void parseBooleanFeature(String name, ParserHandler handler) throws ParseException {
    jj_consume_token(END_BOOLEAN_VALUE);
if (name.endsWith("@")) {
      handler.addBooleanFeature(name.substring(0, name.length() - 1), false);
    } else {
      handler.addBooleanFeature(name, true);
    }
  }

  final public void parseStringFeature(String name, ParserHandler handler) throws ParseException {List<OpCode> value = new ArrayList<OpCode>(); OpCode opcode;
    try {
      jj_consume_token(START_STRING_VALUE);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case STRING_CHAR:
        case STRING_QUOTE:
        case STRING_ESC:
        case STRING_CARET:
        case OP_CODE_PUSH_PARAM:
        case OP_CODE_PRINTF:
        case OP_CODE_PUSH_INTEGER_CONSTANT:
        case OP_CODE_BIT_AND:
        case OP_CODE_BIT_OR:
        case OP_CODE_BIT_XOR:
        case OP_CODE_BIT_NEG:
        case OP_CODE_PERCENT:
        case OP_CODE_PRINT_CHAR:
        case OP_CODE_SET_POP_VARIABLE:
        case OP_CODE_GET_PUSH_VARIABLE:
        case OP_CODE_PUSH_CHAR_CONSTANT:
        case OP_CODE_PUSH_STRLEN:
        case OP_CODE_ARITHMETIC_PLUS:
        case OP_CODE_ARITHMETIC_MINUS:
        case OP_CODE_ARITHMETIC_MUL:
        case OP_CODE_ARITHMETIC_DIV:
        case OP_CODE_ARITHMETIC_MOD:
        case OP_CODE_LOGICAL_EQ:
        case OP_CODE_LOGICAL_GT:
        case OP_CODE_LOGICAL_LT:
        case OP_CODE_LOGICAL_AND:
        case OP_CODE_LOGICAL_OR:
        case OP_CODE_LOGICAL_NEG:
        case OP_CODE_ADD_1_TO_PARAMS:
        case OP_CODE_EXPR_IF:{
          ;
          break;
          }
        default:
          break label_6;
        }
        opcode = parseChar();
if (opcode instanceof OpCode.Literal && value.size() > 0 && value.get(value.size() - 1) instanceof OpCode.Literal) {
          value.set(value.size() - 1, new OpCode.Literal("" + value.get(value.size() - 1) + opcode));
        } else {
          value.add(opcode);
        }
      }
      jj_consume_token(END_STRING_VALUE);
handler.addStringFeature(name, new Sequence(value));
    } catch (ParseException e) {
// Deep error recovery
    io.termd.core.util.Logging.TERMINFO.trace("Could not parse feature " + name);
    Token t;
    do {
      t = getNextToken();
    }
    while (t.kind != END_STRING_VALUE);
    }
  }

  final public OpCode parseChar() throws ParseException {OpCode opcode;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_CHAR:
    case STRING_QUOTE:
    case STRING_ESC:
    case STRING_CARET:{
      opcode = parseStringLiteral();
      break;
      }
    case OP_CODE_PUSH_PARAM:
    case OP_CODE_PRINTF:
    case OP_CODE_PUSH_INTEGER_CONSTANT:
    case OP_CODE_BIT_AND:
    case OP_CODE_BIT_OR:
    case OP_CODE_BIT_XOR:
    case OP_CODE_BIT_NEG:
    case OP_CODE_PERCENT:
    case OP_CODE_PRINT_CHAR:
    case OP_CODE_SET_POP_VARIABLE:
    case OP_CODE_GET_PUSH_VARIABLE:
    case OP_CODE_PUSH_CHAR_CONSTANT:
    case OP_CODE_PUSH_STRLEN:
    case OP_CODE_ARITHMETIC_PLUS:
    case OP_CODE_ARITHMETIC_MINUS:
    case OP_CODE_ARITHMETIC_MUL:
    case OP_CODE_ARITHMETIC_DIV:
    case OP_CODE_ARITHMETIC_MOD:
    case OP_CODE_LOGICAL_EQ:
    case OP_CODE_LOGICAL_GT:
    case OP_CODE_LOGICAL_LT:
    case OP_CODE_LOGICAL_AND:
    case OP_CODE_LOGICAL_OR:
    case OP_CODE_LOGICAL_NEG:
    case OP_CODE_ADD_1_TO_PARAMS:
    case OP_CODE_EXPR_IF:{
      opcode = parseOpCode();
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return opcode;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.Literal parseStringLiteral() throws ParseException {StringBuilder buffer = new StringBuilder(); char c;
    label_7:
    while (true) {
      c = parseCharLiteral();
buffer.append(c);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING_CHAR:
      case STRING_QUOTE:
      case STRING_ESC:
      case STRING_CARET:{
        ;
        break;
        }
      default:
        break label_7;
      }
    }
{if ("" != null) return new OpCode.Literal(buffer.toString());}
    throw new Error("Missing return statement in function");
  }

  final public char parseCharLiteral() throws ParseException {char c;Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_CHAR:{
      t = jj_consume_token(STRING_CHAR);
c=t.image.charAt(0);
      break;
      }
    case STRING_QUOTE:{
      jj_consume_token(STRING_QUOTE);
c='\'';
      break;
      }
    case STRING_ESC:{
      jj_consume_token(STRING_ESC);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ANY_ESC_VALUE:{
        t = jj_consume_token(ANY_ESC_VALUE);
c=convertEscChar(t.image).charAt(0);
        break;
        }
      case ESC_ZERO_OCTAL:{
        t = jj_consume_token(ESC_ZERO_OCTAL);
c=(char) Integer.parseInt(t.image, 8);
        break;
        }
      case ESC_OTHER_OCTAL:{
        t = jj_consume_token(ESC_OTHER_OCTAL);
c=(char) Integer.parseInt(t.image, 8);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case STRING_CARET:{
      jj_consume_token(STRING_CARET);
      t = jj_consume_token(ANY_CARET_VALUE);
c=convertControlChar(t.image).charAt(0);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode parseOpCode() throws ParseException {OpCode opcode;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_CODE_PUSH_PARAM:{
      opcode = parseOpCodePushParam();
      break;
      }
    case OP_CODE_PRINTF:{
      opcode = parseOpCodePrintf();
      break;
      }
    case OP_CODE_PUSH_INTEGER_CONSTANT:{
      opcode = parseOpCodePushIntegerConstant();
      break;
      }
    case OP_CODE_BIT_AND:
    case OP_CODE_BIT_OR:
    case OP_CODE_BIT_XOR:
    case OP_CODE_BIT_NEG:{
      opcode = parseOpCodeBit();
      break;
      }
    case OP_CODE_ARITHMETIC_PLUS:
    case OP_CODE_ARITHMETIC_MINUS:
    case OP_CODE_ARITHMETIC_MUL:
    case OP_CODE_ARITHMETIC_DIV:
    case OP_CODE_ARITHMETIC_MOD:{
      opcode = parseOpCodeArithmetic();
      break;
      }
    case OP_CODE_LOGICAL_EQ:
    case OP_CODE_LOGICAL_GT:
    case OP_CODE_LOGICAL_LT:
    case OP_CODE_LOGICAL_AND:
    case OP_CODE_LOGICAL_OR:
    case OP_CODE_LOGICAL_NEG:{
      opcode = parseOpCodeLogical();
      break;
      }
    case OP_CODE_PERCENT:{
      opcode = parseOpCodePercent();
      break;
      }
    case OP_CODE_ADD_1_TO_PARAMS:{
      opcode = parseOpCodeAdd1ToParams();
      break;
      }
    case OP_CODE_PUSH_STRLEN:{
      opcode = parseOpCodePushStrLen();
      break;
      }
    case OP_CODE_PRINT_CHAR:{
      opcode = parseOpCodePrintChar();
      break;
      }
    case OP_CODE_SET_POP_VARIABLE:
    case OP_CODE_GET_PUSH_VARIABLE:{
      opcode = parseOpCodeVariable();
      break;
      }
    case OP_CODE_PUSH_CHAR_CONSTANT:{
      opcode = parseOpCodePushCharConstant();
      break;
      }
    case OP_CODE_EXPR_IF:{
      opcode = parseOpCodeExpr();
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return opcode;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.If parseOpCodeExpr() throws ParseException {OpCode opcode;List<OpCode> expr=new ArrayList<OpCode>();OpCode.Then thenPart;
    jj_consume_token(OP_CODE_EXPR_IF);
    label_8:
    while (true) {
      opcode = parseChar();
expr.add(opcode);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING_CHAR:
      case STRING_QUOTE:
      case STRING_ESC:
      case STRING_CARET:
      case OP_CODE_PUSH_PARAM:
      case OP_CODE_PRINTF:
      case OP_CODE_PUSH_INTEGER_CONSTANT:
      case OP_CODE_BIT_AND:
      case OP_CODE_BIT_OR:
      case OP_CODE_BIT_XOR:
      case OP_CODE_BIT_NEG:
      case OP_CODE_PERCENT:
      case OP_CODE_PRINT_CHAR:
      case OP_CODE_SET_POP_VARIABLE:
      case OP_CODE_GET_PUSH_VARIABLE:
      case OP_CODE_PUSH_CHAR_CONSTANT:
      case OP_CODE_PUSH_STRLEN:
      case OP_CODE_ARITHMETIC_PLUS:
      case OP_CODE_ARITHMETIC_MINUS:
      case OP_CODE_ARITHMETIC_MUL:
      case OP_CODE_ARITHMETIC_DIV:
      case OP_CODE_ARITHMETIC_MOD:
      case OP_CODE_LOGICAL_EQ:
      case OP_CODE_LOGICAL_GT:
      case OP_CODE_LOGICAL_LT:
      case OP_CODE_LOGICAL_AND:
      case OP_CODE_LOGICAL_OR:
      case OP_CODE_LOGICAL_NEG:
      case OP_CODE_ADD_1_TO_PARAMS:
      case OP_CODE_EXPR_IF:{
        ;
        break;
        }
      default:
        break label_8;
      }
    }
    thenPart = parseThen();
    jj_consume_token(OP_CODE_EXPR_FI);
{if ("" != null) return new OpCode.If(expr,thenPart);}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.Then parseThen() throws ParseException {OpCode opcode;List<OpCode> expr=new ArrayList<OpCode>();List<OpCode> elseExpr=new ArrayList<OpCode>();ElsePart elsePart=null;OpCode.Then thenPart;
    jj_consume_token(OP_CODE_EXPR_THEN);
    label_9:
    while (true) {
      opcode = parseChar();
expr.add(opcode);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING_CHAR:
      case STRING_QUOTE:
      case STRING_ESC:
      case STRING_CARET:
      case OP_CODE_PUSH_PARAM:
      case OP_CODE_PRINTF:
      case OP_CODE_PUSH_INTEGER_CONSTANT:
      case OP_CODE_BIT_AND:
      case OP_CODE_BIT_OR:
      case OP_CODE_BIT_XOR:
      case OP_CODE_BIT_NEG:
      case OP_CODE_PERCENT:
      case OP_CODE_PRINT_CHAR:
      case OP_CODE_SET_POP_VARIABLE:
      case OP_CODE_GET_PUSH_VARIABLE:
      case OP_CODE_PUSH_CHAR_CONSTANT:
      case OP_CODE_PUSH_STRLEN:
      case OP_CODE_ARITHMETIC_PLUS:
      case OP_CODE_ARITHMETIC_MINUS:
      case OP_CODE_ARITHMETIC_MUL:
      case OP_CODE_ARITHMETIC_DIV:
      case OP_CODE_ARITHMETIC_MOD:
      case OP_CODE_LOGICAL_EQ:
      case OP_CODE_LOGICAL_GT:
      case OP_CODE_LOGICAL_LT:
      case OP_CODE_LOGICAL_AND:
      case OP_CODE_LOGICAL_OR:
      case OP_CODE_LOGICAL_NEG:
      case OP_CODE_ADD_1_TO_PARAMS:
      case OP_CODE_EXPR_IF:{
        ;
        break;
        }
      default:
        break label_9;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_CODE_EXPR_ELSE:{
      jj_consume_token(OP_CODE_EXPR_ELSE);
      label_10:
      while (true) {
        opcode = parseChar();
elseExpr.add(opcode);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case STRING_CHAR:
        case STRING_QUOTE:
        case STRING_ESC:
        case STRING_CARET:
        case OP_CODE_PUSH_PARAM:
        case OP_CODE_PRINTF:
        case OP_CODE_PUSH_INTEGER_CONSTANT:
        case OP_CODE_BIT_AND:
        case OP_CODE_BIT_OR:
        case OP_CODE_BIT_XOR:
        case OP_CODE_BIT_NEG:
        case OP_CODE_PERCENT:
        case OP_CODE_PRINT_CHAR:
        case OP_CODE_SET_POP_VARIABLE:
        case OP_CODE_GET_PUSH_VARIABLE:
        case OP_CODE_PUSH_CHAR_CONSTANT:
        case OP_CODE_PUSH_STRLEN:
        case OP_CODE_ARITHMETIC_PLUS:
        case OP_CODE_ARITHMETIC_MINUS:
        case OP_CODE_ARITHMETIC_MUL:
        case OP_CODE_ARITHMETIC_DIV:
        case OP_CODE_ARITHMETIC_MOD:
        case OP_CODE_LOGICAL_EQ:
        case OP_CODE_LOGICAL_GT:
        case OP_CODE_LOGICAL_LT:
        case OP_CODE_LOGICAL_AND:
        case OP_CODE_LOGICAL_OR:
        case OP_CODE_LOGICAL_NEG:
        case OP_CODE_ADD_1_TO_PARAMS:
        case OP_CODE_EXPR_IF:{
          ;
          break;
          }
        default:
          break label_10;
        }
      }
elsePart=new OpCode.Else(elseExpr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OP_CODE_EXPR_THEN:{
        thenPart = parseThen();
elsePart=new OpCode.If(elseExpr,thenPart);
        break;
        }
      default:
        ;
      }
      break;
      }
    default:
      ;
    }
{if ("" != null) return new OpCode.Then(expr,elsePart);}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.Bit parseOpCodeBit() throws ParseException {OpCode.Bit opcode;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_CODE_BIT_AND:{
      jj_consume_token(OP_CODE_BIT_AND);
opcode=OpCode.Bit.AND;
      break;
      }
    case OP_CODE_BIT_OR:{
      jj_consume_token(OP_CODE_BIT_OR);
opcode=OpCode.Bit.OR;
      break;
      }
    case OP_CODE_BIT_XOR:{
      jj_consume_token(OP_CODE_BIT_XOR);
opcode=OpCode.Bit.XOR;
      break;
      }
    case OP_CODE_BIT_NEG:{
      jj_consume_token(OP_CODE_BIT_NEG);
opcode=OpCode.Bit.NEG;
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return opcode;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.Arithmetic parseOpCodeArithmetic() throws ParseException {OpCode.Arithmetic opcode;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_CODE_ARITHMETIC_PLUS:{
      jj_consume_token(OP_CODE_ARITHMETIC_PLUS);
opcode=OpCode.Arithmetic.PLUS;
      break;
      }
    case OP_CODE_ARITHMETIC_MINUS:{
      jj_consume_token(OP_CODE_ARITHMETIC_MINUS);
opcode=OpCode.Arithmetic.MINUS;
      break;
      }
    case OP_CODE_ARITHMETIC_MUL:{
      jj_consume_token(OP_CODE_ARITHMETIC_MUL);
opcode=OpCode.Arithmetic.MUL;
      break;
      }
    case OP_CODE_ARITHMETIC_DIV:{
      jj_consume_token(OP_CODE_ARITHMETIC_DIV);
opcode=OpCode.Arithmetic.DIV;
      break;
      }
    case OP_CODE_ARITHMETIC_MOD:{
      jj_consume_token(OP_CODE_ARITHMETIC_MOD);
opcode=OpCode.Arithmetic.MOD;
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return opcode;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.Logical parseOpCodeLogical() throws ParseException {OpCode.Logical opcode;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_CODE_LOGICAL_EQ:{
      jj_consume_token(OP_CODE_LOGICAL_EQ);
opcode=OpCode.Logical.EQ;
      break;
      }
    case OP_CODE_LOGICAL_GT:{
      jj_consume_token(OP_CODE_LOGICAL_GT);
opcode=OpCode.Logical.GT;
      break;
      }
    case OP_CODE_LOGICAL_LT:{
      jj_consume_token(OP_CODE_LOGICAL_LT);
opcode=OpCode.Logical.LT;
      break;
      }
    case OP_CODE_LOGICAL_AND:{
      jj_consume_token(OP_CODE_LOGICAL_AND);
opcode=OpCode.Logical.AND;
      break;
      }
    case OP_CODE_LOGICAL_OR:{
      jj_consume_token(OP_CODE_LOGICAL_OR);
opcode=OpCode.Logical.OR;
      break;
      }
    case OP_CODE_LOGICAL_NEG:{
      jj_consume_token(OP_CODE_LOGICAL_NEG);
opcode=OpCode.Logical.NEG;
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return opcode;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.Percent parseOpCodePercent() throws ParseException {OpCode.Percent opcode;
    jj_consume_token(OP_CODE_PERCENT);
opcode=OpCode.Percent.INSTANCE;
{if ("" != null) return opcode;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.Add1ToParams parseOpCodeAdd1ToParams() throws ParseException {OpCode.Add1ToParams opcode;
    jj_consume_token(OP_CODE_ADD_1_TO_PARAMS);
opcode=OpCode.Add1ToParams.INSTANCE;
{if ("" != null) return opcode;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.PushStrLen parseOpCodePushStrLen() throws ParseException {OpCode.PushStrLen opcode;
    jj_consume_token(OP_CODE_PUSH_STRLEN);
opcode=OpCode.PushStrLen.INSTANCE;
{if ("" != null) return opcode;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.PushParam parseOpCodePushParam() throws ParseException {Token t;
    t = jj_consume_token(OP_CODE_PUSH_PARAM);
{if ("" != null) return new OpCode.PushParam(t.image.charAt(2) - '0');}
    throw new Error("Missing return statement in function");
  }

  final public OpCode.PushConstant parseOpCodePushIntegerConstant() throws ParseException {Token t;
    t = jj_consume_token(OP_CODE_PUSH_INTEGER_CONSTANT);
{if ("" != null) return new OpCode.PushConstant(Integer.parseInt(t.image.substring(2, t.image.length() - 1)), true);}
    throw new Error("Missing return statement in function");
  }

  final public OpCode parseOpCodePrintf() throws ParseException {Token t;
    t = jj_consume_token(OP_CODE_PRINTF);
if ("%+".equals(t.image)) {
        {if ("" != null) return OpCode.Arithmetic.PLUS;}
    } else if ("%-".equals(t.image)) {
        {if ("" != null) return OpCode.Arithmetic.MINUS;}
    } else {
        {if ("" != null) return OpCode.Printf.parse(t.image);}
    }
    throw new Error("Missing return statement in function");
  }

  final public OpCode.PrintChar parseOpCodePrintChar() throws ParseException {
    jj_consume_token(OP_CODE_PRINT_CHAR);
{if ("" != null) return OpCode.PrintChar.INSTANCE;}
    throw new Error("Missing return statement in function");
  }

  final public OpCode parseOpCodeVariable() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_CODE_SET_POP_VARIABLE:{
      t = jj_consume_token(OP_CODE_SET_POP_VARIABLE);
{if ("" != null) return new OpCode.SetPopVar(t.image.charAt(2));}
      break;
      }
    case OP_CODE_GET_PUSH_VARIABLE:{
      t = jj_consume_token(OP_CODE_GET_PUSH_VARIABLE);
{if ("" != null) return new OpCode.GetPushVar(t.image.charAt(2));}
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public OpCode.PushConstant parseOpCodePushCharConstant() throws ParseException {char c;
    jj_consume_token(OP_CODE_PUSH_CHAR_CONSTANT);
    c = parseCharLiteral();
    jj_consume_token(STRING_QUOTE);
{if ("" != null) return new OpCode.PushConstant(c, false);}
    throw new Error("Missing return statement in function");
  }

  final public void parseNumericFeature(String name, ParserHandler handler) throws ParseException {Token t;
    jj_consume_token(START_NUMERIC_VALUE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HEX_VALUE:{
      t = jj_consume_token(HEX_VALUE);
handler.addNumericFeature(name, Integer.parseInt(t.image.substring(2), 16));
      break;
      }
    case OCT_VALUE:{
      t = jj_consume_token(OCT_VALUE);
handler.addNumericFeature(name, Integer.parseInt(t.image, 8));
      break;
      }
    case DEC_VALUE:{
      t = jj_consume_token(DEC_VALUE);
handler.addNumericFeature(name, Integer.parseInt(t.image));
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(END_NUMERIC_VALUE);
  }

  /** Generated Token Manager. */
  public TermInfoParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;

  /** Constructor with InputStream. */
  public TermInfoParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public TermInfoParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new TermInfoParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Constructor. */
  public TermInfoParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new TermInfoParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new JavaCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new TermInfoParserTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Constructor with generated Token Manager. */
  public TermInfoParser(TermInfoParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(TermInfoParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      return token;
    }
    token = oldToken;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    Token errortok = token.next;
    int line = errortok.beginLine, column = errortok.beginColumn;
    String mess = (errortok.kind == 0) ? tokenImage[0] : errortok.image;
    return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
