/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.alibaba.nacos.spring.context.event.config.NacosConfigReceivedEvent;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.spring.beans.factory.annotation.AnnotationInjectedBeanPostProcessor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

public class NacosValueAnnotationBeanPostProcessor
extends AnnotationInjectedBeanPostProcessor<NacosValue>
implements BeanFactoryAware,
ApplicationListener<NacosConfigReceivedEvent> {
    public static final String BEAN_NAME = "nacosValueAnnotationBeanPostProcessor";
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String VALUE_SEPARATOR = ":";
    private Map<String, List<BeanProperty>> placeholderPropertyListMap = new HashMap<String, List<BeanProperty>>();
    private Map<BeanProperty, List<Object>> propertyBeanListMap = new HashMap<BeanProperty, List<Object>>();
    private ConfigurableListableBeanFactory beanFactory;

    protected Object doGetInjectedBean(NacosValue annotation, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        String value = annotation.value();
        return this.beanFactory.resolveEmbeddedValue(value);
    }

    protected String buildInjectedObjectCacheKey(NacosValue annotation, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        return bean.getClass().getName() + annotation;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("NacosValueAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        HashMap<String, List<BeanProperty>> beanNamePropertyListMap = new HashMap<String, List<BeanProperty>>();
        this.doWithAnnotationFields(bean, beanName, beanNamePropertyListMap);
        List beanPropertyList = (List)beanNamePropertyListMap.get(beanName);
        if (beanPropertyList != null) {
            for (BeanProperty beanProperty : beanPropertyList) {
                this.put2ListMap(this.propertyBeanListMap, beanProperty, bean);
            }
        }
        return super.postProcessBeforeInitialization(bean, beanName);
    }

    private void doWithAnnotationFields(Object bean, final String beanName, final Map<String, List<BeanProperty>> beanNamePropertyListMap) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException {
                this.doWithNacosValueField(field);
                this.doWithValueField(field);
            }

            private void doWithNacosValueField(Field field) {
                NacosValue annotation = (NacosValue)AnnotationUtils.getAnnotation((AnnotatedElement)field, NacosValue.class);
                if (annotation != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        return;
                    }
                    if (annotation.autoRefreshed()) {
                        String placeHolder = annotation.value();
                        this.doWithListMap(field, placeHolder);
                    }
                }
            }

            private void doWithValueField(Field field) {
                Value annotation = (Value)AnnotationUtils.getAnnotation((AnnotatedElement)field, Value.class);
                if (annotation != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        return;
                    }
                    String placeHolder = annotation.value();
                    this.doWithListMap(field, placeHolder);
                }
            }

            private void doWithListMap(Field field, String placeholder) {
                if (!placeholder.startsWith(NacosValueAnnotationBeanPostProcessor.PLACEHOLDER_PREFIX)) {
                    return;
                }
                if (!placeholder.endsWith(NacosValueAnnotationBeanPostProcessor.PLACEHOLDER_SUFFIX)) {
                    return;
                }
                if (placeholder.length() <= NacosValueAnnotationBeanPostProcessor.PLACEHOLDER_PREFIX.length() + NacosValueAnnotationBeanPostProcessor.PLACEHOLDER_SUFFIX.length()) {
                    return;
                }
                String actualPlaceholder = this.resolveActualPlaceholder(placeholder);
                BeanProperty beanProperty = new BeanProperty(field.getName(), actualPlaceholder);
                NacosValueAnnotationBeanPostProcessor.this.put2ListMap(beanNamePropertyListMap, beanName, beanProperty);
                NacosValueAnnotationBeanPostProcessor.this.put2ListMap(NacosValueAnnotationBeanPostProcessor.this.placeholderPropertyListMap, actualPlaceholder, beanProperty);
            }

            private String resolveActualPlaceholder(String placeholder) {
                int endIndex;
                int beginIndex = NacosValueAnnotationBeanPostProcessor.PLACEHOLDER_PREFIX.length();
                int separatorIndex = (placeholder = placeholder.substring(beginIndex, endIndex = placeholder.length() - NacosValueAnnotationBeanPostProcessor.PLACEHOLDER_PREFIX.length() + 1)).indexOf(NacosValueAnnotationBeanPostProcessor.VALUE_SEPARATOR);
                if (separatorIndex != -1) {
                    return placeholder.substring(0, separatorIndex);
                }
                return placeholder;
            }
        });
    }

    private <K, V> void put2ListMap(Map<K, List<V>> map, K key, V value) {
        List<V> valueList = map.get(key);
        if (valueList == null) {
            valueList = new ArrayList<V>();
        }
        valueList.add(value);
        map.put(key, valueList);
    }

    public void onApplicationEvent(NacosConfigReceivedEvent event) {
        String content = event.getContent();
        if (content != null) {
            HashMap<Object, List<BeanProperty>> map = new HashMap<Object, List<BeanProperty>>();
            Properties configProperties = NacosUtils.toProperties(content);
            for (Object key : configProperties.keySet()) {
                List<BeanProperty> beanPropertyList = this.placeholderPropertyListMap.get(key.toString());
                if (beanPropertyList == null) continue;
                for (BeanProperty beanProperty : beanPropertyList) {
                    List<Object> beanList = this.propertyBeanListMap.get(beanProperty);
                    if (beanList == null) continue;
                    for (Object bean : beanList) {
                        beanProperty.setKey((String)key);
                        this.put2ListMap(map, bean, beanProperty);
                    }
                }
            }
            this.doBind(map, configProperties);
        }
    }

    private void doBind(Map<Object, List<BeanProperty>> map, Properties configProperties) {
        for (Map.Entry<Object, List<BeanProperty>> entry : map.entrySet()) {
            Object bean = entry.getKey();
            List<BeanProperty> beanPropertyList = entry.getValue();
            PropertyValues propertyValues = this.resolvePropertyValues(bean, configProperties, beanPropertyList);
            DataBinder dataBinder = new DataBinder(bean);
            dataBinder.bind(propertyValues);
        }
    }

    private PropertyValues resolvePropertyValues(Object bean, final Properties configProperties, final List<BeanProperty> beanPropertyList) {
        final MutablePropertyValues propertyValues = new MutablePropertyValues();
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException {
                String propertyName = NacosValueAnnotationBeanPostProcessor.this.resolvePropertyName(field, beanPropertyList);
                if (StringUtils.hasText((String)propertyName) && configProperties.containsKey(propertyName)) {
                    String propertyValue = configProperties.getProperty(propertyName);
                    propertyValues.add(field.getName(), (Object)propertyValue);
                }
            }
        });
        return propertyValues;
    }

    private String resolvePropertyName(Field field, List<BeanProperty> beanPropertyList) {
        for (BeanProperty beanProperty : beanPropertyList) {
            if (!field.getName().equals(beanProperty.name)) continue;
            return beanProperty.getKey();
        }
        return null;
    }

    private static class BeanProperty {
        private String name;
        private String value;
        private String key;

        BeanProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getKey() {
            return this.key;
        }

        void setKey(String key) {
            this.key = key;
        }

        public String toString() {
            return "BeanProperty{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

