/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.util;

import com.alibaba.nacos.api.annotation.NacosProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.annotation.NacosIgnore;
import com.alibaba.nacos.api.config.annotation.NacosProperty;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.util.ConfigParseUtils;
import com.alibaba.nacos.spring.util.PropertiesPlaceholderResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class NacosUtils {
    public static final String DEFAULT_STRING_ATTRIBUTE_VALUE = "";
    public static final String DEFAULT_CONFIG_TYPE_VALUE = "properties";
    public static final boolean DEFAULT_BOOLEAN_ATTRIBUTE_VALUE = false;
    public static final String SEPARATOR = "|";
    public static final long DEFAULT_TIMEOUT = Long.getLong("nacos.default.timeout", 5000L);
    private static final Logger logger = LoggerFactory.getLogger(NacosUtils.class);

    public static String buildDefaultPropertySourceName(String dataId, String groupId, Map<?, ?> properties) {
        return NacosUtils.build(dataId, groupId, NacosUtils.identify(properties));
    }

    public static String identify(NacosProperties nacosProperties) {
        return NacosUtils.identify(AnnotationUtils.getAnnotationAttributes((Annotation)nacosProperties));
    }

    public static String identify(Map<?, ?> properties) {
        String namespace = (String)properties.get("namespace");
        String serverAddress = (String)properties.get("serverAddr");
        String contextPath = (String)properties.get("contextPath");
        String clusterName = (String)properties.get("clusterName");
        String endpoint = (String)properties.get("endpoint");
        String accessKey = (String)properties.get("accessKey");
        String secretKey = (String)properties.get("secretKey");
        String encode = (String)properties.get("encode");
        return NacosUtils.build(namespace, clusterName, serverAddress, contextPath, endpoint, accessKey, secretKey, encode);
    }

    private static String build(Object ... values) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object value : values) {
            String stringValue;
            String string = stringValue = value == null ? null : String.valueOf(value);
            if (StringUtils.hasText((String)stringValue)) {
                stringBuilder.append(stringValue);
            }
            stringBuilder.append(SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static boolean isDefault(final NacosProperties nacosProperties) {
        final LinkedList records = new LinkedList();
        ReflectionUtils.doWithMethods((Class)nacosProperties.annotationType(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Object defaultValue;
                if (Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && (defaultValue = method.getDefaultValue()) != null) {
                    try {
                        Object returnValue = method.invoke((Object)nacosProperties, new Object[0]);
                        if (!defaultValue.equals(returnValue)) {
                            records.add(returnValue);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return records.isEmpty();
    }

    public static String readTypeFromDataId(String dataId) {
        if (StringUtils.isEmpty((Object)dataId)) {
            return dataId;
        }
        int index = dataId.lastIndexOf(".");
        return index != -1 ? dataId.substring(index + 1) : DEFAULT_STRING_ATTRIBUTE_VALUE;
    }

    public static String readFromEnvironment(String label, Environment environment) {
        return environment.resolvePlaceholders(label);
    }

    public static PropertyValues resolvePropertyValues(Object bean, String content, String type) {
        return NacosUtils.resolvePropertyValues(bean, DEFAULT_STRING_ATTRIBUTE_VALUE, DEFAULT_STRING_ATTRIBUTE_VALUE, DEFAULT_STRING_ATTRIBUTE_VALUE, content, type);
    }

    public static PropertyValues resolvePropertyValues(Object bean, final String prefix, String dataId, String groupId, String content, String type) {
        final Properties configProperties = NacosUtils.toProperties(dataId, groupId, content, type);
        final MutablePropertyValues propertyValues = new MutablePropertyValues();
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                String propertyName = NacosUtils.resolvePropertyName(field);
                String string = propertyName = StringUtils.isEmpty((Object)prefix) ? propertyName : prefix + "." + propertyName;
                if (StringUtils.hasText((String)propertyName)) {
                    if (Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) {
                        NacosUtils.bindContainer(prefix, propertyName, configProperties, propertyValues);
                        return;
                    }
                    if (configProperties.containsKey(propertyName)) {
                        String propertyValue = configProperties.getProperty(propertyName);
                        propertyValues.add(field.getName(), (Object)propertyValue);
                    }
                }
            }
        });
        return propertyValues;
    }

    public static Properties resolveProperties(NacosProperties nacosProperties, PropertyResolver propertyResolver) {
        return NacosUtils.resolveProperties(nacosProperties, propertyResolver, null);
    }

    public static Properties resolveProperties(NacosProperties nacosProperties, PropertyResolver propertyResolver, Properties defaultProperties) {
        Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)nacosProperties);
        return NacosUtils.resolveProperties(attributes, propertyResolver, defaultProperties);
    }

    public static Properties resolveProperties(Map<String, Object> attributes, PropertyResolver propertyResolver, Properties defaultProperties) {
        if (CollectionUtils.isEmpty(attributes)) {
            return defaultProperties;
        }
        Properties resolveProperties = NacosUtils.resolveProperties(attributes, propertyResolver);
        NacosUtils.merge(resolveProperties, defaultProperties);
        return resolveProperties;
    }

    public static Properties resolveProperties(Map<?, ?> properties, PropertyResolver propertyResolver) {
        PropertiesPlaceholderResolver propertiesPlaceholderResolver = new PropertiesPlaceholderResolver(propertyResolver);
        return propertiesPlaceholderResolver.resolve(properties);
    }

    protected static void merge(Properties targetProperties, Properties sourceProperties) {
        if (CollectionUtils.isEmpty((Map)sourceProperties)) {
            return;
        }
        for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            if (targetProperties.containsKey(propertyName)) continue;
            String propertyValue = (String)entry.getValue();
            targetProperties.setProperty(propertyName, propertyValue);
        }
    }

    public static String getContent(ConfigService configService, String dataId, String groupId) {
        String content;
        block2: {
            content = null;
            try {
                content = configService.getConfig(dataId, groupId, DEFAULT_TIMEOUT);
            }
            catch (NacosException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error("Can't get content from dataId : " + dataId + " , groupId : " + groupId, (Throwable)e);
            }
        }
        return content;
    }

    private static void bindContainer(String prefix, String fieldName, Properties configProperties, MutablePropertyValues propertyValues) {
        String regx1 = fieldName + "\\[(.*)\\]";
        String regx2 = fieldName + "\\..*";
        Pattern pattern1 = Pattern.compile(regx1);
        Pattern pattern2 = Pattern.compile(regx2);
        Enumeration<?> enumeration = configProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            int index;
            String s = (String)enumeration.nextElement();
            String name = StringUtils.isEmpty((Object)prefix) ? s : s.replace(prefix + ".", DEFAULT_STRING_ATTRIBUTE_VALUE);
            String value = configProperties.getProperty(s);
            if (configProperties.containsKey(fieldName)) {
                NacosUtils.bindContainer(prefix, fieldName, NacosUtils.listToProperties(fieldName, configProperties.getProperty(fieldName)), propertyValues);
                continue;
            }
            if (pattern1.matcher(s).find()) {
                propertyValues.add(name, (Object)value);
                continue;
            }
            if (!pattern2.matcher(s).find() || (index = s.indexOf(46)) == -1) continue;
            String key = s.substring(index + 1);
            propertyValues.add(s.substring(0, index) + "[" + key + "]", (Object)value);
        }
    }

    private static Properties listToProperties(String fieldName, String content) {
        String[] splits = content.split(",");
        int index = 0;
        Properties properties = new Properties();
        for (String s : splits) {
            properties.put(fieldName + "[" + index + "]", s.trim());
            ++index;
        }
        return properties;
    }

    private static String resolvePropertyName(Field field) {
        if (AnnotationUtils.getAnnotation((AnnotatedElement)field, NacosIgnore.class) != null) {
            return null;
        }
        NacosProperty nacosProperty = (NacosProperty)AnnotationUtils.getAnnotation((AnnotatedElement)field, NacosProperty.class);
        return nacosProperty != null ? nacosProperty.value() : field.getName();
    }

    public static <T> Class<T> resolveGenericType(Class<?> declaredClass) {
        ParameterizedType parameterizedType = (ParameterizedType)declaredClass.getGenericSuperclass();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }

    public static Properties toProperties(String text) {
        return NacosUtils.toProperties(text, DEFAULT_CONFIG_TYPE_VALUE);
    }

    public static Properties toProperties(String text, String type) {
        return NacosUtils.toProperties(DEFAULT_STRING_ATTRIBUTE_VALUE, DEFAULT_STRING_ATTRIBUTE_VALUE, text, type);
    }

    public static Properties toProperties(String dataId, String group, String text) {
        return NacosUtils.toProperties(dataId, group, text, DEFAULT_CONFIG_TYPE_VALUE);
    }

    public static Properties toProperties(String dataId, String group, String text, String type) {
        if ("yml".equalsIgnoreCase(type = type.toLowerCase())) {
            type = "yaml";
        }
        return ConfigParseUtils.toProperties(dataId, group, text, type);
    }
}

