/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.SerialWriterStringEncoder;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.Base64;
import com.alibaba.fastjson.util.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.nio.charset.Charset;

public final class SerializeWriter
extends Writer {
    protected char[] buf;
    protected int count;
    private static final ThreadLocal<SoftReference<char[]>> bufLocal = new ThreadLocal();
    private int features;
    private final Writer writer;

    public SerializeWriter() {
        this((Writer)null);
    }

    public SerializeWriter(Writer writer) {
        this.writer = writer;
        this.features = JSON.DEFAULT_GENERATE_FEATURE;
        SoftReference<char[]> ref = bufLocal.get();
        if (ref != null) {
            this.buf = ref.get();
            bufLocal.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[1024];
        }
    }

    public SerializeWriter(SerializerFeature ... features) {
        this((Writer)null, features);
    }

    public SerializeWriter(Writer writer, SerializerFeature ... features) {
        this.writer = writer;
        SoftReference<char[]> ref = bufLocal.get();
        if (ref != null) {
            this.buf = ref.get();
            bufLocal.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[1024];
        }
        int featuresValue = 0;
        SerializerFeature[] serializerFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            SerializerFeature feature = serializerFeatureArray[n2];
            featuresValue |= feature.getMask();
            ++n2;
        }
        this.features = featuresValue;
    }

    public int getBufferLength() {
        return this.buf.length;
    }

    public SerializeWriter(int initialSize) {
        this(null, initialSize);
    }

    public SerializeWriter(Writer writer, int initialSize) {
        this.writer = writer;
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Negative initial size: " + initialSize);
        }
        this.buf = new char[initialSize];
    }

    public void config(SerializerFeature feature, boolean state) {
        this.features = state ? (this.features |= feature.getMask()) : (this.features &= ~feature.getMask());
    }

    public boolean isEnabled(SerializerFeature feature) {
        return SerializerFeature.isEnabled(this.features, feature);
    }

    @Override
    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                this.flush();
                newcount = 1;
            }
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    public void write(char c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                this.flush();
                newcount = 1;
            }
        }
        this.buf[this.count] = c;
        this.count = newcount;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                int rest;
                do {
                    rest = this.buf.length - this.count;
                    System.arraycopy(c, off, this.buf, this.count, rest);
                    this.count = this.buf.length;
                    this.flush();
                    off += rest;
                } while ((len -= rest) > this.buf.length);
                newcount = len;
            }
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void expandCapacity(int minimumCapacity) {
        int newCapacity = this.buf.length * 3 / 2 + 1;
        if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        this.buf = newValue;
    }

    @Override
    public void write(String str, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                int rest;
                do {
                    rest = this.buf.length - this.count;
                    str.getChars(off, off + rest, this.buf, this.count);
                    this.count = this.buf.length;
                    this.flush();
                    off += rest;
                } while ((len -= rest) > this.buf.length);
                newcount = len;
            }
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    public void writeTo(Writer out) throws IOException {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        out.write(this.buf, 0, this.count);
    }

    public void writeTo(OutputStream out, String charsetName) throws IOException {
        this.writeTo(out, Charset.forName(charsetName));
    }

    public void writeTo(OutputStream out, Charset charset) throws IOException {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        byte[] bytes = new String(this.buf, 0, this.count).getBytes(charset);
        out.write(bytes);
    }

    @Override
    public SerializeWriter append(CharSequence csq) {
        String s = csq == null ? "null" : csq.toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public SerializeWriter append(CharSequence csq, int start, int end) {
        String s = (csq == null ? "null" : csq).subSequence(start, end).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public SerializeWriter append(char c) {
        this.write(c);
        return this;
    }

    public void reset() {
        this.count = 0;
    }

    public char[] toCharArray() {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        char[] newValue = new char[this.count];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        return newValue;
    }

    public byte[] toBytes(String charsetName) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        Charset cs = Charset.forName(charsetName);
        SerialWriterStringEncoder encoder = new SerialWriterStringEncoder(cs);
        return encoder.encode(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void close() {
        if (this.writer != null && this.count > 0) {
            this.flush();
        }
        if (this.buf.length <= 8192) {
            bufLocal.set(new SoftReference<char[]>(this.buf));
        }
        this.buf = null;
    }

    @Override
    public void write(String text) {
        if (text == null) {
            this.writeNull();
            return;
        }
        this.write(text, 0, text.length());
    }

    public void writeInt(int i) {
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int size = i < 0 ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                char[] chars = new char[size];
                IOUtils.getChars(i, size, chars);
                this.write(chars, 0, chars.length);
                return;
            }
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeByteArray(byte[] bytes) {
        char quote;
        int bytesLen = bytes.length;
        boolean singleQuote = this.isEnabled(SerializerFeature.UseSingleQuotes);
        char c = quote = singleQuote ? (char)'\'' : '\"';
        if (bytesLen == 0) {
            String emptyString = singleQuote ? "''" : "\"\"";
            this.write(emptyString);
            return;
        }
        char[] CA = Base64.CA;
        int eLen = bytesLen / 3 * 3;
        int charsLen = (bytesLen - 1) / 3 + 1 << 2;
        int offset = this.count;
        int newcount = this.count + charsLen + 2;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                int i;
                this.write(quote);
                int s = 0;
                while (s < eLen) {
                    i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
                    this.write(CA[i >>> 18 & 0x3F]);
                    this.write(CA[i >>> 12 & 0x3F]);
                    this.write(CA[i >>> 6 & 0x3F]);
                    this.write(CA[i & 0x3F]);
                }
                int left = bytesLen - eLen;
                if (left > 0) {
                    i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytesLen - 1] & 0xFF) << 2 : 0);
                    this.write(CA[i >> 12]);
                    this.write(CA[i >>> 6 & 0x3F]);
                    this.write(left == 2 ? CA[i & 0x3F] : (char)'=');
                    this.write('=');
                }
                this.write(quote);
                return;
            }
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        this.buf[offset++] = quote;
        int s = 0;
        int d = offset;
        while (s < eLen) {
            int i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            this.buf[d++] = CA[i >>> 18 & 0x3F];
            this.buf[d++] = CA[i >>> 12 & 0x3F];
            this.buf[d++] = CA[i >>> 6 & 0x3F];
            this.buf[d++] = CA[i & 0x3F];
        }
        int left = bytesLen - eLen;
        if (left > 0) {
            int i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytesLen - 1] & 0xFF) << 2 : 0);
            this.buf[newcount - 5] = CA[i >> 12];
            this.buf[newcount - 4] = CA[i >>> 6 & 0x3F];
            this.buf[newcount - 3] = left == 2 ? CA[i & 0x3F] : 61;
            this.buf[newcount - 2] = 61;
        }
        this.buf[newcount - 1] = quote;
    }

    public void writeFloatAndChar(float value, char c) {
        String text = Float.toString(value);
        if (text.endsWith(".0")) {
            text = text.substring(0, text.length() - 2);
        }
        this.write(text);
        this.write(c);
    }

    public void writeDoubleAndChar(double value, char c) {
        String text = Double.toString(value);
        if (text.endsWith(".0")) {
            text = text.substring(0, text.length() - 2);
        }
        this.write(text);
        this.write(c);
    }

    public void writeBooleanAndChar(boolean value, char c) {
        if (value) {
            if (c == ',') {
                this.write("true,");
            } else if (c == ']') {
                this.write("true]");
            } else {
                this.write("true");
                this.write(c);
            }
        } else if (c == ',') {
            this.write("false,");
        } else if (c == ']') {
            this.write("false]");
        } else {
            this.write("false");
            this.write(c);
        }
    }

    public void writeCharacterAndChar(char value, char c) {
        this.writeString(Character.toString(value));
        this.write(c);
    }

    public void writeEnum(Enum<?> value, char c) {
        if (value == null) {
            this.writeNull();
            this.write(',');
            return;
        }
        if (this.isEnabled(SerializerFeature.WriteEnumUsingToString)) {
            if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
                this.write('\'');
                this.write(value.name());
                this.write('\'');
                this.write(c);
            } else {
                this.write('\"');
                this.write(value.name());
                this.write('\"');
                this.write(c);
            }
            return;
        }
        this.writeIntAndChar(value.ordinal(), c);
    }

    public void writeIntAndChar(int i, char c) {
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            this.write(c);
            return;
        }
        int size = i < 0 ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount0 = this.count + size;
        int newcount1 = newcount0 + 1;
        if (newcount1 > this.buf.length) {
            if (this.writer != null) {
                this.writeInt(i);
                this.write(c);
                return;
            }
            this.expandCapacity(newcount1);
        }
        IOUtils.getChars(i, newcount0, this.buf);
        this.buf[newcount0] = c;
        this.count = newcount1;
    }

    public void writeLongAndChar(long i, char c) throws IOException {
        if (i == Long.MIN_VALUE) {
            this.write("-9223372036854775808");
            this.write(c);
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount0 = this.count + size;
        int newcount1 = newcount0 + 1;
        if (newcount1 > this.buf.length) {
            if (this.writer != null) {
                this.writeLong(i);
                this.write(c);
                return;
            }
            this.expandCapacity(newcount1);
        }
        IOUtils.getChars(i, newcount0, this.buf);
        this.buf[newcount0] = c;
        this.count = newcount1;
    }

    public void writeLong(long i) {
        if (i == Long.MIN_VALUE) {
            this.write("-9223372036854775808");
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                char[] chars = new char[size];
                IOUtils.getChars(i, size, chars);
                this.write(chars, 0, chars.length);
                return;
            }
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeNull() {
        this.write("null");
    }

    private void writeStringWithDoubleQuote(String text, char seperator) {
        this.writeStringWithDoubleQuote(text, seperator, true);
    }

    /*
     * Unable to fully structure code
     */
    private void writeStringWithDoubleQuote(String text, char seperator, boolean checkSpecial) {
        block57: {
            block58: {
                if (text == null) {
                    this.writeNull();
                    if (seperator != '\u0000') {
                        this.write(seperator);
                    }
                    return;
                }
                len = text.length();
                newcount = this.count + len + 2;
                if (seperator != '\u0000') {
                    ++newcount;
                }
                if (newcount <= this.buf.length) break block57;
                if (this.writer == null) break block58;
                this.write('\"');
                i = 0;
                while (i < text.length()) {
                    block61: {
                        block59: {
                            block62: {
                                block60: {
                                    ch = text.charAt(i);
                                    if (!this.isEnabled(SerializerFeature.BrowserCompatible)) break block59;
                                    if (ch != '\b' && ch != '\f' && ch != '\n' && ch != '\r' && ch != '\t' && ch != '\"' && ch != '/' && ch != '\\') break block60;
                                    this.write('\\');
                                    this.write(IOUtils.replaceChars[ch]);
                                    break block61;
                                }
                                if (ch >= ' ') break block62;
                                this.write('\\');
                                this.write('u');
                                this.write('0');
                                this.write('0');
                                this.write(IOUtils.ASCII_CHARS[ch * 2]);
                                this.write(IOUtils.ASCII_CHARS[ch * 2 + 1]);
                                break block61;
                            }
                            if (ch < '\u007f') ** GOTO lbl-1000
                            this.write('\\');
                            this.write('u');
                            this.write(IOUtils.DIGITS[ch >>> 12 & 15]);
                            this.write(IOUtils.DIGITS[ch >>> 8 & 15]);
                            this.write(IOUtils.DIGITS[ch >>> 4 & 15]);
                            this.write(IOUtils.DIGITS[ch & 15]);
                            break block61;
                        }
                        if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] != 0 || ch == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                            this.write('\\');
                            this.write(IOUtils.replaceChars[ch]);
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.write(ch);
                        }
                    }
                    ++i;
                }
                this.write('\"');
                if (seperator != '\u0000') {
                    this.write(seperator);
                }
                return;
            }
            this.expandCapacity(newcount);
        }
        start = this.count + 1;
        end = start + len;
        this.buf[this.count] = 34;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            lastSpecialIndex = -1;
            i = start;
            while (i < end) {
                ch = this.buf[i];
                if (ch == '\"' || ch == '/' || ch == '\\') {
                    lastSpecialIndex = i;
                    ++newcount;
                } else if (ch == '\b' || ch == '\f' || ch == '\n' || ch == '\r' || ch == '\t') {
                    lastSpecialIndex = i;
                    ++newcount;
                } else if (ch < ' ') {
                    lastSpecialIndex = i;
                    newcount += 5;
                } else if (ch >= '\u007f') {
                    lastSpecialIndex = i;
                    newcount += 5;
                }
                ++i;
            }
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            i = lastSpecialIndex;
            while (i >= start) {
                ch = this.buf[i];
                if (ch == '\b' || ch == '\f' || ch == '\n' || ch == '\r' || ch == '\t') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = IOUtils.replaceChars[ch];
                    ++end;
                } else if (ch == '\"' || ch == '/' || ch == '\\') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = ch;
                    ++end;
                } else if (ch < ' ') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 6, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = 117;
                    this.buf[i + 2] = 48;
                    this.buf[i + 3] = 48;
                    this.buf[i + 4] = IOUtils.ASCII_CHARS[ch * 2];
                    this.buf[i + 5] = IOUtils.ASCII_CHARS[ch * 2 + 1];
                    end += 5;
                } else if (ch >= '\u007f') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 6, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = 117;
                    this.buf[i + 2] = IOUtils.DIGITS[ch >>> 12 & 15];
                    this.buf[i + 3] = IOUtils.DIGITS[ch >>> 8 & 15];
                    this.buf[i + 4] = IOUtils.DIGITS[ch >>> 4 & 15];
                    this.buf[i + 5] = IOUtils.DIGITS[ch & 15];
                    end += 5;
                }
                --i;
            }
            if (seperator != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = seperator;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        specialCount = 0;
        lastSpecialIndex = -1;
        firstSpecialIndex = -1;
        lastSpecial = '\u0000';
        if (checkSpecial) {
            i = start;
            while (i < end) {
                ch = this.buf[i];
                if (ch == '\u2028') {
                    ++specialCount;
                    lastSpecialIndex = i;
                    lastSpecial = ch;
                    newcount += 4;
                    if (firstSpecialIndex == -1) {
                        firstSpecialIndex = i;
                    }
                } else if (ch >= ']') {
                    if (ch >= '\u007f' && ch <= '\u00a0') {
                        if (firstSpecialIndex == -1) {
                            firstSpecialIndex = i;
                        }
                        ++specialCount;
                        lastSpecialIndex = i;
                        lastSpecial = ch;
                        newcount += 4;
                    }
                } else if (SerializeWriter.isSpecial(ch, this.features)) {
                    ++specialCount;
                    lastSpecialIndex = i;
                    lastSpecial = ch;
                    if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                        newcount += 4;
                    }
                    if (firstSpecialIndex == -1) {
                        firstSpecialIndex = i;
                    }
                }
                ++i;
            }
            if (specialCount > 0) {
                if ((newcount += specialCount) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                if (specialCount == 1) {
                    if (lastSpecial == '\u2028') {
                        srcPos = lastSpecialIndex + 1;
                        destPos = lastSpecialIndex + 6;
                        LengthOfCopy = end - lastSpecialIndex - 1;
                        System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                        this.buf[lastSpecialIndex] = 92;
                        this.buf[++lastSpecialIndex] = 117;
                        this.buf[++lastSpecialIndex] = 50;
                        this.buf[++lastSpecialIndex] = 48;
                        this.buf[++lastSpecialIndex] = 50;
                        this.buf[++lastSpecialIndex] = 56;
                    } else {
                        ch = lastSpecial;
                        if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                            srcPos = lastSpecialIndex + 1;
                            destPos = lastSpecialIndex + 6;
                            LengthOfCopy = end - lastSpecialIndex - 1;
                            System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                            bufIndex = lastSpecialIndex;
                            this.buf[bufIndex++] = 92;
                            this.buf[bufIndex++] = 117;
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 15];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 15];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 15];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch & 15];
                        } else {
                            srcPos = lastSpecialIndex + 1;
                            destPos = lastSpecialIndex + 2;
                            LengthOfCopy = end - lastSpecialIndex - 1;
                            System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                            this.buf[lastSpecialIndex] = 92;
                            this.buf[++lastSpecialIndex] = IOUtils.replaceChars[ch];
                        }
                    }
                } else if (specialCount > 1) {
                    textIndex = firstSpecialIndex - start;
                    bufIndex = firstSpecialIndex;
                    i = textIndex;
                    while (i < text.length()) {
                        ch = text.charAt(i);
                        if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] != 0 || ch == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                            this.buf[bufIndex++] = 92;
                            if (IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                                this.buf[bufIndex++] = 117;
                                this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 15];
                                this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 15];
                                this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 15];
                                this.buf[bufIndex++] = IOUtils.DIGITS[ch & 15];
                                end += 5;
                            } else {
                                this.buf[bufIndex++] = IOUtils.replaceChars[ch];
                                ++end;
                            }
                        } else if (ch == '\u2028') {
                            this.buf[bufIndex++] = 92;
                            this.buf[bufIndex++] = 117;
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 15];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 15];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 15];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch & 15];
                            end += 5;
                        } else {
                            this.buf[bufIndex++] = ch;
                        }
                        ++i;
                    }
                }
            }
        }
        if (seperator != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = seperator;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    public void writeFieldNull(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeNull();
    }

    public void writeFieldEmptyList(char seperator, String key) {
        this.write(seperator);
        this.writeFieldName(key);
        this.write("[]");
    }

    public void writeFieldNullString(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullStringAsEmpty)) {
            this.writeString("");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullBoolean(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullBooleanAsFalse)) {
            this.write("false");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullList(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
            this.write("[]");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullNumber(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
            this.write('0');
        } else {
            this.writeNull();
        }
    }

    public void writeFieldValue(char seperator, String name, char value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == '\u0000') {
            this.writeString("\u0000");
        } else {
            this.writeString(Character.toString(value));
        }
    }

    public void writeFieldValue(char seperator, String name, boolean value) {
        int keySeperator = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
        int intSize = value ? 4 : 5;
        int nameLen = name.length();
        int newcount = this.count + nameLen + 4 + intSize;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                this.write(seperator);
                this.writeString(name);
                this.write(':');
                this.write(value);
                return;
            }
            this.expandCapacity(newcount);
        }
        int start = this.count;
        this.count = newcount;
        this.buf[start] = seperator;
        int nameEnd = start + nameLen + 1;
        this.buf[start + 1] = keySeperator;
        name.getChars(0, nameLen, this.buf, start + 2);
        this.buf[nameEnd + 1] = keySeperator;
        if (value) {
            System.arraycopy(":true".toCharArray(), 0, this.buf, nameEnd + 2, 5);
        } else {
            System.arraycopy(":false".toCharArray(), 0, this.buf, nameEnd + 2, 6);
        }
    }

    public void write(boolean value) {
        if (value) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void writeFieldValue(char seperator, String name, int value) {
        if (value == Integer.MIN_VALUE || !this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            this.writeFieldValue1(seperator, name, value);
            return;
        }
        int keySeperator = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
        int intSize = value < 0 ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
        int nameLen = name.length();
        int newcount = this.count + nameLen + 4 + intSize;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                this.writeFieldValue1(seperator, name, value);
                return;
            }
            this.expandCapacity(newcount);
        }
        int start = this.count;
        this.count = newcount;
        this.buf[start] = seperator;
        int nameEnd = start + nameLen + 1;
        this.buf[start + 1] = keySeperator;
        name.getChars(0, nameLen, this.buf, start + 2);
        this.buf[nameEnd + 1] = keySeperator;
        this.buf[nameEnd + 2] = 58;
        IOUtils.getChars(value, this.count, this.buf);
    }

    public void writeFieldValue1(char seperator, String name, int value) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeInt(value);
    }

    public void writeFieldValue(char seperator, String name, long value) {
        if (value == Long.MIN_VALUE || !this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            this.writeFieldValue1(seperator, name, value);
            return;
        }
        int keySeperator = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
        int intSize = value < 0L ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
        int nameLen = name.length();
        int newcount = this.count + nameLen + 4 + intSize;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                this.write(seperator);
                this.writeFieldName(name);
                this.writeLong(value);
                return;
            }
            this.expandCapacity(newcount);
        }
        int start = this.count;
        this.count = newcount;
        this.buf[start] = seperator;
        int nameEnd = start + nameLen + 1;
        this.buf[start + 1] = keySeperator;
        name.getChars(0, nameLen, this.buf, start + 2);
        this.buf[nameEnd + 1] = keySeperator;
        this.buf[nameEnd + 2] = 58;
        IOUtils.getChars(value, this.count, this.buf);
    }

    public void writeFieldValue1(char seperator, String name, long value) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeLong(value);
    }

    public void writeFieldValue(char seperator, String name, float value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == 0.0f) {
            this.write('0');
        } else if (Float.isNaN(value)) {
            this.writeNull();
        } else if (Float.isInfinite(value)) {
            this.writeNull();
        } else {
            String text = Float.toString(value);
            if (text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
            this.write(text);
        }
    }

    public void writeFieldValue(char seperator, String name, double value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == 0.0) {
            this.write('0');
        } else if (Double.isNaN(value)) {
            this.writeNull();
        } else if (Double.isInfinite(value)) {
            this.writeNull();
        } else {
            String text = Double.toString(value);
            if (text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
            this.write(text);
        }
    }

    public void writeFieldValue(char seperator, String name, String value) {
        if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
                this.write(seperator);
                this.writeFieldName(name);
                if (value == null) {
                    this.writeNull();
                } else {
                    this.writeString(value);
                }
            } else if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                this.write(seperator);
                this.writeStringWithDoubleQuote(name, ':');
                this.writeStringWithDoubleQuote(value, '\u0000');
            } else {
                this.writeFieldValueStringWithDoubleQuote(seperator, name, value, true);
            }
        } else {
            this.write(seperator);
            this.writeFieldName(name);
            if (value == null) {
                this.writeNull();
            } else {
                this.writeString(value);
            }
        }
    }

    private void writeFieldValueStringWithDoubleQuote(char seperator, String name, String value, boolean checkSpecial) {
        int valueLen;
        int nameLen = name.length();
        int newcount = this.count;
        if (value == null) {
            valueLen = 4;
            newcount += nameLen + 8;
        } else {
            valueLen = value.length();
            newcount += nameLen + valueLen + 6;
        }
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                this.write(seperator);
                this.writeStringWithDoubleQuote(name, ':', checkSpecial);
                this.writeStringWithDoubleQuote(value, '\u0000', checkSpecial);
                return;
            }
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = seperator;
        int nameStart = this.count + 2;
        int nameEnd = nameStart + nameLen;
        this.buf[this.count + 1] = 34;
        name.getChars(0, nameLen, this.buf, nameStart);
        this.count = newcount;
        this.buf[nameEnd] = 34;
        int index = nameEnd + 1;
        this.buf[index++] = 58;
        if (value == null) {
            this.buf[index++] = 110;
            this.buf[index++] = 117;
            this.buf[index++] = 108;
            this.buf[index++] = 108;
            return;
        }
        this.buf[index++] = 34;
        int valueStart = index;
        int valueEnd = valueStart + valueLen;
        value.getChars(0, valueLen, this.buf, valueStart);
        if (checkSpecial && !this.isEnabled(SerializerFeature.DisableCheckSpecialChar)) {
            int specialCount = 0;
            int lastSpecialIndex = -1;
            int firstSpecialIndex = -1;
            char lastSpecial = '\u0000';
            int i = valueStart;
            while (i < valueEnd) {
                char ch = this.buf[i];
                if (ch == '\u2028') {
                    ++specialCount;
                    lastSpecialIndex = i;
                    lastSpecial = ch;
                    newcount += 4;
                    if (firstSpecialIndex == -1) {
                        firstSpecialIndex = i;
                    }
                } else if (ch >= ']') {
                    if (ch >= '\u007f' && ch <= '\u00a0') {
                        if (firstSpecialIndex == -1) {
                            firstSpecialIndex = i;
                        }
                        ++specialCount;
                        lastSpecialIndex = i;
                        lastSpecial = ch;
                        newcount += 4;
                    }
                } else if (SerializeWriter.isSpecial(ch, this.features)) {
                    ++specialCount;
                    lastSpecialIndex = i;
                    lastSpecial = ch;
                    if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                        newcount += 4;
                    }
                    if (firstSpecialIndex == -1) {
                        firstSpecialIndex = i;
                    }
                }
                ++i;
            }
            if (specialCount > 0) {
                if ((newcount += specialCount) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                if (specialCount == 1) {
                    if (lastSpecial == '\u2028') {
                        int srcPos = lastSpecialIndex + 1;
                        int destPos = lastSpecialIndex + 6;
                        int LengthOfCopy = valueEnd - lastSpecialIndex - 1;
                        System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                        this.buf[lastSpecialIndex] = 92;
                        this.buf[++lastSpecialIndex] = 117;
                        this.buf[++lastSpecialIndex] = 50;
                        this.buf[++lastSpecialIndex] = 48;
                        this.buf[++lastSpecialIndex] = 50;
                        this.buf[++lastSpecialIndex] = 56;
                    } else {
                        int srcPos;
                        char ch = lastSpecial;
                        if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                            srcPos = lastSpecialIndex + 1;
                            int destPos = lastSpecialIndex + 6;
                            int LengthOfCopy = valueEnd - lastSpecialIndex - 1;
                            System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                            int bufIndex = lastSpecialIndex;
                            this.buf[bufIndex++] = 92;
                            this.buf[bufIndex++] = 117;
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch & 0xF];
                        } else {
                            srcPos = lastSpecialIndex + 1;
                            int destPos = lastSpecialIndex + 2;
                            int LengthOfCopy = valueEnd - lastSpecialIndex - 1;
                            System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                            this.buf[lastSpecialIndex] = 92;
                            this.buf[++lastSpecialIndex] = IOUtils.replaceChars[ch];
                        }
                    }
                } else if (specialCount > 1) {
                    int textIndex = firstSpecialIndex - valueStart;
                    int bufIndex = firstSpecialIndex;
                    int i2 = textIndex;
                    while (i2 < value.length()) {
                        char ch = value.charAt(i2);
                        if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] != 0 || ch == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                            this.buf[bufIndex++] = 92;
                            if (IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                                this.buf[bufIndex++] = 117;
                                this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                                this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                                this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                                this.buf[bufIndex++] = IOUtils.DIGITS[ch & 0xF];
                                valueEnd += 5;
                            } else {
                                this.buf[bufIndex++] = IOUtils.replaceChars[ch];
                                ++valueEnd;
                            }
                        } else if (ch == '\u2028') {
                            this.buf[bufIndex++] = 92;
                            this.buf[bufIndex++] = 117;
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch & 0xF];
                            valueEnd += 5;
                        } else {
                            this.buf[bufIndex++] = ch;
                        }
                        ++i2;
                    }
                }
            }
        }
        this.buf[this.count - 1] = 34;
    }

    static final boolean isSpecial(char ch, int features) {
        if (ch == ' ') {
            return false;
        }
        if (ch == '/' && SerializerFeature.isEnabled(features, SerializerFeature.WriteSlashAsSpecial)) {
            return true;
        }
        if (ch > '#' && ch != '\\') {
            return false;
        }
        return ch <= '\u001f' || ch == '\\' || ch == '\"';
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeFieldValue(char seperator, String name, Enum<?> value) {
        if (value == null) {
            this.write(seperator);
            this.writeFieldName(name);
            this.writeNull();
            return;
        }
        if (!this.isEnabled(SerializerFeature.WriteEnumUsingToString)) {
            this.writeFieldValue(seperator, name, value.ordinal());
            return;
        }
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            this.writeFieldValue(seperator, name, value.name());
            return;
        }
        this.writeFieldValueStringWithDoubleQuote(seperator, name, value.name(), false);
    }

    public void writeFieldValue(char seperator, String name, BigDecimal value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == null) {
            this.writeNull();
        } else {
            this.write(value.toString());
        }
    }

    public void writeString(String text, char seperator) {
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            this.writeStringWithSingleQuote(text);
            this.write(seperator);
        } else {
            this.writeStringWithDoubleQuote(text, seperator);
        }
    }

    public void writeString(String text) {
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            this.writeStringWithSingleQuote(text);
        } else {
            this.writeStringWithDoubleQuote(text, '\u0000');
        }
    }

    private void writeStringWithSingleQuote(String text) {
        char ch;
        if (text == null) {
            int newcount = this.count + 4;
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = newcount;
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                this.write('\'');
                int i = 0;
                while (i < text.length()) {
                    char ch2 = text.charAt(i);
                    if (ch2 <= '\r' || ch2 == '\\' || ch2 == '\'' || ch2 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write('\\');
                        this.write(IOUtils.replaceChars[ch2]);
                    } else {
                        this.write(ch2);
                    }
                    ++i;
                }
                this.write('\'');
                return;
            }
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 39;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        int i = start;
        while (i < end) {
            ch = this.buf[i];
            if (ch <= '\r' || ch == '\\' || ch == '\'' || ch == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                ++specialCount;
                lastSpecialIndex = i;
                lastSpecial = ch;
            }
            ++i;
        }
        if ((newcount += specialCount) > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = IOUtils.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = IOUtils.replaceChars[lastSpecial];
            ++end;
            i = lastSpecialIndex - 2;
            while (i >= start) {
                ch = this.buf[i];
                if (ch <= '\r' || ch == '\\' || ch == '\'' || ch == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = IOUtils.replaceChars[ch];
                    ++end;
                }
                --i;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    public void writeFieldName(String key) {
        this.writeFieldName(key, false);
    }

    public void writeFieldName(String key, boolean checkSpecial) {
        if (key == null) {
            this.write("null:");
            return;
        }
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
                this.writeStringWithSingleQuote(key);
                this.write(':');
            } else {
                this.writeKeyWithSingleQuoteIfHasSpecial(key);
            }
        } else if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            this.writeStringWithDoubleQuote(key, ':', checkSpecial);
        } else {
            this.writeKeyWithDoubleQuoteIfHasSpecial(key);
        }
    }

    private void writeKeyWithDoubleQuoteIfHasSpecial(String text) {
        byte[] specicalFlags_doubleQuotes = IOUtils.specicalFlags_doubleQuotes;
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                char ch;
                if (len == 0) {
                    this.write('\"');
                    this.write('\"');
                    this.write(':');
                    return;
                }
                boolean hasSpecial = false;
                int i = 0;
                while (i < len) {
                    ch = text.charAt(i);
                    if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] != 0) {
                        hasSpecial = true;
                        break;
                    }
                    ++i;
                }
                if (hasSpecial) {
                    this.write('\"');
                }
                i = 0;
                while (i < len) {
                    ch = text.charAt(i);
                    if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] != 0) {
                        this.write('\\');
                        this.write(IOUtils.replaceChars[ch]);
                    } else {
                        this.write(ch);
                    }
                    ++i;
                }
                if (hasSpecial) {
                    this.write('\"');
                }
                this.write(':');
                return;
            }
            this.expandCapacity(newcount);
        }
        if (len == 0) {
            int newCount = this.count + 3;
            if (newCount > this.buf.length) {
                this.expandCapacity(this.count + 3);
            }
            this.buf[this.count++] = 34;
            this.buf[this.count++] = 34;
            this.buf[this.count++] = 58;
            return;
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        int i = start;
        while (i < end) {
            char ch = this.buf[i];
            if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] != 0) {
                if (!hasSpecial) {
                    if ((newcount += 3) > this.buf.length) {
                        this.expandCapacity(newcount);
                    }
                    this.count = newcount;
                    System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                    System.arraycopy(this.buf, 0, this.buf, 1, i);
                    this.buf[start] = 34;
                    this.buf[++i] = 92;
                    this.buf[++i] = IOUtils.replaceChars[ch];
                    end += 2;
                    this.buf[this.count - 2] = 34;
                    hasSpecial = true;
                } else {
                    if (++newcount > this.buf.length) {
                        this.expandCapacity(newcount);
                    }
                    this.count = newcount;
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
                    this.buf[i] = 92;
                    this.buf[++i] = IOUtils.replaceChars[ch];
                    ++end;
                }
            }
            ++i;
        }
        this.buf[this.count - 1] = 58;
    }

    private void writeKeyWithSingleQuoteIfHasSpecial(String text) {
        byte[] specicalFlags_singleQuotes = IOUtils.specicalFlags_singleQuotes;
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                char ch;
                if (len == 0) {
                    this.write('\'');
                    this.write('\'');
                    this.write(':');
                    return;
                }
                boolean hasSpecial = false;
                int i = 0;
                while (i < len) {
                    ch = text.charAt(i);
                    if (ch < specicalFlags_singleQuotes.length && specicalFlags_singleQuotes[ch] != 0) {
                        hasSpecial = true;
                        break;
                    }
                    ++i;
                }
                if (hasSpecial) {
                    this.write('\'');
                }
                i = 0;
                while (i < len) {
                    ch = text.charAt(i);
                    if (ch < specicalFlags_singleQuotes.length && specicalFlags_singleQuotes[ch] != 0) {
                        this.write('\\');
                        this.write(IOUtils.replaceChars[ch]);
                    } else {
                        this.write(ch);
                    }
                    ++i;
                }
                if (hasSpecial) {
                    this.write('\'');
                }
                this.write(':');
                return;
            }
            this.expandCapacity(newcount);
        }
        if (len == 0) {
            int newCount = this.count + 3;
            if (newCount > this.buf.length) {
                this.expandCapacity(this.count + 3);
            }
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 58;
            return;
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        int i = start;
        while (i < end) {
            char ch = this.buf[i];
            if (ch < specicalFlags_singleQuotes.length && specicalFlags_singleQuotes[ch] != 0) {
                if (!hasSpecial) {
                    if ((newcount += 3) > this.buf.length) {
                        this.expandCapacity(newcount);
                    }
                    this.count = newcount;
                    System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                    System.arraycopy(this.buf, 0, this.buf, 1, i);
                    this.buf[start] = 39;
                    this.buf[++i] = 92;
                    this.buf[++i] = IOUtils.replaceChars[ch];
                    end += 2;
                    this.buf[this.count - 2] = 39;
                    hasSpecial = true;
                } else {
                    if (++newcount > this.buf.length) {
                        this.expandCapacity(newcount);
                    }
                    this.count = newcount;
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
                    this.buf[i] = 92;
                    this.buf[++i] = IOUtils.replaceChars[ch];
                    ++end;
                }
            }
            ++i;
        }
        this.buf[newcount - 1] = 58;
    }

    @Override
    public void flush() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(this.buf, 0, this.count);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
        this.count = 0;
    }
}

