/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.Base64;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeUtils {
    public static boolean compatibleWithJavaBean = false;
    private static boolean setAccessibleEnable = true;
    private static ConcurrentMap<String, Class<?>> mappings;

    static {
        try {
            String prop = System.getProperty("fastjson.compatibleWithJavaBean");
            if ("true".equals(prop)) {
                compatibleWithJavaBean = true;
            } else if ("false".equals(prop)) {
                compatibleWithJavaBean = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        mappings = new ConcurrentHashMap();
        TypeUtils.addBaseClassMappings();
    }

    public static final String castToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static final Byte castToByte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Byte.parseByte(strVal);
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static final Character castToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if (strVal.length() != 1) {
                throw new JSONException("can not cast to byte, value : " + value);
            }
            return Character.valueOf(strVal.charAt(0));
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static final Short castToShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Short.parseShort(strVal);
        }
        throw new JSONException("can not cast to short, value : " + value);
    }

    public static final BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static final BigInteger castToBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Float || value instanceof Double) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigInteger(strVal);
    }

    public static final Float castToFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0) {
                return null;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(strVal));
        }
        throw new JSONException("can not cast to float, value : " + value);
    }

    public static final Double castToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0) {
                return null;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Double.parseDouble(strVal);
        }
        throw new JSONException("can not cast to double, value : " + value);
    }

    public static final java.util.Date castToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        long longValue = -1L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
            return new java.util.Date(longValue);
        }
        if (value instanceof String) {
            String strVal = (String)value;
            System.out.println("123456");
            if (strVal.length() == 22) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");
                    return dateFormat.parse(strVal);
                }
                catch (ParseException dateFormat) {
                    // empty catch block
                }
            }
            if (strVal.indexOf(45) != -1) {
                String format = strVal.length() == JSON.DEFFAULT_DATE_FORMAT.length() ? JSON.DEFFAULT_DATE_FORMAT : (strVal.length() == 10 ? "yyyy-MM-dd" : (strVal.length() == "yyyy-MM-dd HH:mm:ss".length() ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS"));
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                try {
                    return dateFormat.parse(strVal);
                }
                catch (ParseException e) {
                    throw new JSONException("can not cast to Date, value : " + strVal);
                }
            }
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue < 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new java.util.Date(longValue);
    }

    public static final Date castToSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Date(longValue);
    }

    public static final Timestamp castToTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Timestamp(longValue);
    }

    public static final Long castToLong(Object value) {
        block8: {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.length() == 0) {
                    return null;
                }
                if ("null".equals(strVal) || "NULL".equals(strVal)) {
                    return null;
                }
                try {
                    return Long.parseLong(strVal);
                }
                catch (NumberFormatException numberFormatException) {
                    JSONScanner dateParser = new JSONScanner(strVal);
                    Calendar calendar = null;
                    if (dateParser.scanISO8601DateIfMatch(false)) {
                        calendar = dateParser.getCalendar();
                    }
                    dateParser.close();
                    if (calendar == null) break block8;
                    return calendar.getTimeInMillis();
                }
            }
        }
        throw new JSONException("can not cast to long, value : " + value);
    }

    public static final Integer castToInt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if ("null".equals(strVal)) {
                return null;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Integer.parseInt(strVal);
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return Base64.decodeFast((String)value);
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final Boolean castToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            if (((Number)value).intValue() == 1) {
                return true;
            }
            return false;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if ("true".equalsIgnoreCase(strVal)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(strVal)) {
                return Boolean.FALSE;
            }
            if ("1".equals(strVal)) {
                return Boolean.TRUE;
            }
            if ("0".equals(strVal)) {
                return Boolean.FALSE;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
        }
        throw new JSONException("can not cast to boolean, value : " + value);
    }

    public static final <T> T castToJavaBean(Object obj, Class<T> clazz) {
        return TypeUtils.cast(obj, clazz, ParserConfig.getGlobalInstance());
    }

    public static final <T> T cast(Object obj, Class<T> clazz, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (clazz == obj.getClass()) {
            return (T)obj;
        }
        if (obj instanceof Map) {
            if (clazz == Map.class) {
                return (T)obj;
            }
            Map map = (Map)obj;
            if (clazz == Object.class && !map.containsKey(JSON.DEFAULT_TYPE_KEY)) {
                return (T)obj;
            }
            return TypeUtils.castToJavaBean((Map)obj, clazz, mapping);
        }
        if (clazz.isArray()) {
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                int index = 0;
                Object array = Array.newInstance(clazz.getComponentType(), collection.size());
                for (Object item : collection) {
                    Object value = TypeUtils.cast(item, clazz.getComponentType(), mapping);
                    Array.set(array, index, value);
                    ++index;
                }
                return (T)array;
            }
            if (clazz == byte[].class) {
                return (T)TypeUtils.castToBytes(obj);
            }
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtils.castToBoolean(obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte(obj);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort(obj);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtils.castToInt(obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtils.castToLong(obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat(obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble(obj);
        }
        if (clazz == String.class) {
            return (T)TypeUtils.castToString(obj);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(obj);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(obj);
        }
        if (clazz == java.util.Date.class) {
            return (T)TypeUtils.castToDate(obj);
        }
        if (clazz == Date.class) {
            return (T)TypeUtils.castToSqlDate(obj);
        }
        if (clazz == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp(obj);
        }
        if (clazz.isEnum()) {
            return TypeUtils.castToEnum(obj, clazz, mapping);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            Calendar calendar;
            java.util.Date date = TypeUtils.castToDate(obj);
            if (clazz == Calendar.class) {
                calendar = Calendar.getInstance();
            } else {
                try {
                    calendar = (Calendar)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new JSONException("can not cast to : " + clazz.getName(), e);
                }
            }
            calendar.setTime(date);
            return (T)calendar;
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <T> T castToEnum(Object obj, Class<T> clazz, ParserConfig mapping) {
        try {
            Object[] values;
            if (obj instanceof String) {
                String name = (String)obj;
                if (name.length() != 0) return Enum.valueOf(clazz, name);
                return null;
            }
            if (!(obj instanceof Number)) throw new JSONException("can not cast to : " + clazz.getName());
            int ordinal = ((Number)obj).intValue();
            Method method = clazz.getMethod("values", new Class[0]);
            Object[] objectArray = values = (Object[])method.invoke(null, new Object[0]);
            int n = values.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    throw new JSONException("can not cast to : " + clazz.getName());
                }
                Object value = objectArray[n2];
                Enum e = (Enum)value;
                if (e.ordinal() == ordinal) {
                    return (T)e;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new JSONException("can not cast to : " + clazz.getName(), ex);
        }
    }

    public static final <T> T cast(Object obj, Type type, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type, mapping);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(obj, (ParameterizedType)type, mapping);
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)obj;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static final <T> T cast(Object obj, ParameterizedType type, ParserConfig mapping) {
        Type argType;
        String strVal;
        Type rawTye = type.getRawType();
        if (rawTye == Set.class || rawTye == HashSet.class || rawTye == TreeSet.class || rawTye == List.class || rawTye == ArrayList.class) {
            Type itemType = type.getActualTypeArguments()[0];
            if (obj instanceof Iterable) {
                AbstractCollection collection = rawTye == Set.class || rawTye == HashSet.class ? new HashSet() : (rawTye == TreeSet.class ? new TreeSet() : new ArrayList());
                for (Object item : (Iterable)obj) {
                    collection.add(TypeUtils.cast(item, itemType, mapping));
                }
                return (T)collection;
            }
        }
        if (rawTye == Map.class || rawTye == HashMap.class) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (obj instanceof Map) {
                HashMap<T, T> map = new HashMap<T, T>();
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    T key = TypeUtils.cast(entry.getKey(), keyType, mapping);
                    T value = TypeUtils.cast(entry.getValue(), valueType, mapping);
                    map.put(key, value);
                }
                return (T)map;
            }
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        if (type.getActualTypeArguments().length == 1 && (argType = type.getActualTypeArguments()[0]) instanceof WildcardType) {
            return TypeUtils.cast(obj, rawTye, mapping);
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static final <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig mapping) {
        try {
            if (clazz == StackTraceElement.class) {
                String declaringClass = (String)map.get("className");
                String methodName = (String)map.get("methodName");
                String fileName = (String)map.get("fileName");
                Number value = (Number)map.get("lineNumber");
                int lineNumber = value == null ? 0 : value.intValue();
                return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            Object iClassObject = map.get(JSON.DEFAULT_TYPE_KEY);
            if (iClassObject instanceof String) {
                String className = (String)iClassObject;
                Class<?> loadClazz = TypeUtils.loadClass(className);
                if (loadClazz == null) {
                    throw new ClassNotFoundException(String.valueOf(className) + " not found");
                }
                if (!loadClazz.equals(clazz)) {
                    return (T)TypeUtils.castToJavaBean(map, loadClazz, mapping);
                }
            }
            if (clazz.isInterface()) {
                JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
                return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)object);
            }
            if (mapping == null) {
                mapping = ParserConfig.getGlobalInstance();
            }
            Map<String, FieldDeserializer> setters = mapping.getFieldDeserializers(clazz);
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            T object = constructor.newInstance(new Object[0]);
            for (Map.Entry<String, FieldDeserializer> entry : setters.entrySet()) {
                String key = entry.getKey();
                FieldDeserializer fieldDeser = entry.getValue();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method method = fieldDeser.getMethod();
                if (method != null) {
                    Type paramType = method.getGenericParameterTypes()[0];
                    value = TypeUtils.cast(value, paramType, mapping);
                    method.invoke(object, value);
                    continue;
                }
                Field field = fieldDeser.getField();
                Type paramType = field.getGenericType();
                value = TypeUtils.cast(value, paramType, mapping);
                field.set(object, value);
            }
            return object;
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public static void addClassMapping(String className, Class<?> clazz) {
        if (className == null) {
            className = clazz.getName();
        }
        mappings.put(className, clazz);
    }

    public static void addBaseClassMappings() {
        mappings.put("byte", Byte.TYPE);
        mappings.put("short", Short.TYPE);
        mappings.put("int", Integer.TYPE);
        mappings.put("long", Long.TYPE);
        mappings.put("float", Float.TYPE);
        mappings.put("double", Double.TYPE);
        mappings.put("boolean", Boolean.TYPE);
        mappings.put("char", Character.TYPE);
        mappings.put("[byte", byte[].class);
        mappings.put("[short", short[].class);
        mappings.put("[int", int[].class);
        mappings.put("[long", long[].class);
        mappings.put("[float", float[].class);
        mappings.put("[double", double[].class);
        mappings.put("[boolean", boolean[].class);
        mappings.put("[char", char[].class);
        mappings.put(HashMap.class.getName(), HashMap.class);
    }

    public static void clearClassMapping() {
        mappings.clear();
        TypeUtils.addBaseClassMappings();
    }

    public static Class<?> loadClass(String className) {
        if (className == null || className.length() == 0) {
            return null;
        }
        Class<?> clazz = (Class<?>)mappings.get(className);
        if (clazz != null) {
            return clazz;
        }
        if (className.charAt(0) == '[') {
            Class<?> componentType = TypeUtils.loadClass(className.substring(1));
            return Array.newInstance(componentType, 0).getClass();
        }
        if (className.startsWith("L") && className.endsWith(";")) {
            String newClassName = className.substring(1, className.length() - 1);
            return TypeUtils.loadClass(newClassName);
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                clazz = classLoader.loadClass(className);
                TypeUtils.addClassMapping(className, clazz);
                return clazz;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            clazz = Class.forName(className);
            TypeUtils.addClassMapping(className, clazz);
            return clazz;
        }
        catch (Throwable throwable) {
            return clazz;
        }
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> aliasMap) {
        return TypeUtils.computeGetters(clazz, aliasMap, true);
    }

    /*
     * Unable to fully structure code
     */
    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> aliasMap, boolean sorted) {
        fieldInfoMap = new LinkedHashMap<String, FieldInfo>();
        var7_4 = clazz.getMethods();
        var6_5 = var7_4.length;
        var5_7 = 0;
        while (var5_7 < var6_5) {
            block32: {
                block43: {
                    block41: {
                        block42: {
                            block40: {
                                block34: {
                                    block39: {
                                        block36: {
                                            block38: {
                                                block37: {
                                                    block35: {
                                                        block33: {
                                                            method = var7_4[var5_7];
                                                            methodName = method.getName();
                                                            ordinal = 0;
                                                            serialzeFeatures = 0;
                                                            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0 || method.getReturnType() == ClassLoader.class || method.getName().equals("getMetaClass") && method.getReturnType().getName().equals("groovy.lang.MetaClass")) break block32;
                                                            annotation = method.getAnnotation(JSONField.class);
                                                            if (annotation == null) {
                                                                annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
                                                            }
                                                            if (annotation == null) break block33;
                                                            if (!annotation.serialize()) break block32;
                                                            ordinal = annotation.ordinal();
                                                            serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                                                            if (annotation.name().length() != 0) {
                                                                propertyName = annotation.name();
                                                                if (aliasMap == null || (propertyName = aliasMap.get(propertyName)) != null) {
                                                                    fieldInfoMap.put(propertyName, new FieldInfo(propertyName, method, null, ordinal, serialzeFeatures));
                                                                    ** GOTO lbl87
                                                                } else {
                                                                    ** GOTO lbl25
                                                                }
                                                            }
                                                            break block33;
lbl25:
                                                            // 2 sources

                                                            break block32;
                                                        }
                                                        if (!methodName.startsWith("get")) break block34;
                                                        if (methodName.length() < 4 || methodName.equals("getClass")) break block32;
                                                        c3 = methodName.charAt(3);
                                                        if (!Character.isUpperCase(c3)) break block35;
                                                        propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
                                                        break block36;
                                                    }
                                                    if (c3 != '_') break block37;
                                                    propertyName = methodName.substring(4);
                                                    break block36;
                                                }
                                                if (c3 != 'f') break block38;
                                                propertyName = methodName.substring(3);
                                                break block36;
                                            }
                                            if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) break block32;
                                            propertyName = TypeUtils.decapitalize(methodName.substring(3));
                                        }
                                        ignore = TypeUtils.isJSONTypeIgnore(clazz, propertyName);
                                        if (ignore) break block32;
                                        field = ParserConfig.getField(clazz, propertyName);
                                        if (field == null || (fieldAnnotation = field.getAnnotation(JSONField.class)) == null) break block39;
                                        if (!fieldAnnotation.serialize()) break block32;
                                        ordinal = fieldAnnotation.ordinal();
                                        serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                                        if (fieldAnnotation.name().length() == 0) break block39;
                                        propertyName = fieldAnnotation.name();
                                        if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block32;
                                    }
                                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block32;
                                    fieldInfoMap.put(propertyName, new FieldInfo(propertyName, method, field, ordinal, serialzeFeatures));
                                }
                                if (!methodName.startsWith("is") || methodName.length() < 3) break block32;
                                c2 = methodName.charAt(2);
                                if (!Character.isUpperCase(c2)) break block40;
                                propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(2)) : String.valueOf(Character.toLowerCase(methodName.charAt(2))) + methodName.substring(3);
                                break block41;
                            }
                            if (c2 != '_') break block42;
                            propertyName = methodName.substring(3);
                            break block41;
                        }
                        if (c2 != 'f') break block32;
                        propertyName = methodName.substring(2);
                    }
                    field = ParserConfig.getField(clazz, propertyName);
                    if (field == null) {
                        field = ParserConfig.getField(clazz, methodName);
                    }
                    if (field == null || (fieldAnnotation = field.getAnnotation(JSONField.class)) == null) break block43;
                    if (!fieldAnnotation.serialize()) break block32;
                    ordinal = fieldAnnotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    if (fieldAnnotation.name().length() == 0) break block43;
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block32;
                }
                if (aliasMap == null || (propertyName = aliasMap.get(propertyName)) != null) {
                    fieldInfoMap.put(propertyName, new FieldInfo(propertyName, method, field, ordinal, serialzeFeatures));
                }
            }
            ++var5_7;
        }
        var7_4 = clazz.getFields();
        var6_5 = var7_4.length;
        var5_7 = 0;
        while (var5_7 < var6_5) {
            block44: {
                block45: {
                    field = var7_4[var5_7];
                    if (Modifier.isStatic(field.getModifiers())) break block44;
                    fieldAnnotation = field.getAnnotation(JSONField.class);
                    ordinal = 0;
                    serialzeFeatures = 0;
                    propertyName = field.getName();
                    if (fieldAnnotation == null) break block45;
                    if (!fieldAnnotation.serialize()) break block44;
                    ordinal = fieldAnnotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    if (fieldAnnotation.name().length() != 0) {
                        propertyName = fieldAnnotation.name();
                    }
                }
                if (!(aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null || fieldInfoMap.containsKey(propertyName))) {
                    fieldInfoMap.put(propertyName, new FieldInfo(propertyName, null, (Field)field, ordinal, serialzeFeatures));
                }
            }
            ++var5_7;
        }
        fieldInfoList = new ArrayList<FieldInfo>();
        containsAll = false;
        orders = null;
        annotation = clazz.getAnnotation(JSONType.class);
        if (annotation != null) {
            orders = annotation.orders();
            if (orders != null && orders.length == fieldInfoMap.size()) {
                containsAll = true;
                var11_13 = orders;
                var10_12 = orders.length;
                var9_10 = 0;
                while (var9_10 < var10_12) {
                    item = var11_13[var9_10];
                    if (!fieldInfoMap.containsKey(item)) {
                        containsAll = false;
                        break;
                    }
                    ++var9_10;
                }
            } else {
                containsAll = false;
            }
        }
        if (containsAll) {
            var11_13 = orders;
            var10_12 = orders.length;
            var9_10 = 0;
            while (var9_10 < var10_12) {
                item = var11_13[var9_10];
                fieldInfo = (FieldInfo)fieldInfoMap.get(item);
                fieldInfoList.add(fieldInfo);
                ++var9_10;
            }
        } else {
            for (FieldInfo fieldInfo : fieldInfoMap.values()) {
                fieldInfoList.add(fieldInfo);
            }
            if (sorted) {
                Collections.sort(fieldInfoList);
            }
        }
        return fieldInfoList;
    }

    public static JSONField getSupperMethodAnnotation(Class<?> clazz, Method method) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            Method[] methodArray = interfaceClass.getMethods();
            int n3 = methodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Method interfaceMethod = methodArray[n4];
                if (interfaceMethod.getName().equals(method.getName()) && interfaceMethod.getParameterTypes().length == method.getParameterTypes().length) {
                    JSONField annotation;
                    boolean match = true;
                    int i = 0;
                    while (i < interfaceMethod.getParameterTypes().length) {
                        if (!interfaceMethod.getParameterTypes()[i].equals(method.getParameterTypes()[i])) {
                            match = false;
                            break;
                        }
                        ++i;
                    }
                    if (match && (annotation = interfaceMethod.getAnnotation(JSONField.class)) != null) {
                        return annotation;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isJSONTypeIgnore(Class<?> clazz, String propertyName) {
        JSONType jsonType = clazz.getAnnotation(JSONType.class);
        if (jsonType != null && jsonType.ignores() != null) {
            String[] stringArray = jsonType.ignores();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (propertyName.equalsIgnoreCase(item)) {
                    return true;
                }
                ++n2;
            }
        }
        return clazz.getSuperclass() != Object.class && clazz.getSuperclass() != null && TypeUtils.isJSONTypeIgnore(clazz.getSuperclass(), propertyName);
    }

    public static boolean isGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof Class) {
            return TypeUtils.isGenericParamType(((Class)type).getGenericSuperclass());
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return type;
        }
        if (type instanceof Class) {
            return TypeUtils.getGenericParamType(((Class)type).getGenericSuperclass());
        }
        return type;
    }

    public static Type unwrap(Type type) {
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            if (componentType == Byte.TYPE) {
                return byte[].class;
            }
            if (componentType == Character.TYPE) {
                return char[].class;
            }
        }
        return type;
    }

    public static Class<?> getClass(Type type) {
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (fieldName.equals(field.getName())) {
                return field;
            }
            ++n2;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return TypeUtils.getField(superClass, fieldName);
        }
        return null;
    }

    public static JSONType getJSONType(Class<?> clazz) {
        return clazz.getAnnotation(JSONType.class);
    }

    public static int getSerializeFeatures(Class<?> clazz) {
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation == null) {
            return 0;
        }
        return SerializerFeature.of(annotation.serialzeFeatures());
    }

    public static int getParserFeatures(Class<?> clazz) {
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation == null) {
            return 0;
        }
        return Feature.of(annotation.parseFeatures());
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static void setAccessible(AccessibleObject obj) {
        if (!setAccessibleEnable) {
            return;
        }
        if (obj.isAccessible()) {
            return;
        }
        try {
            obj.setAccessible(true);
        }
        catch (AccessControlException error) {
            setAccessibleEnable = false;
        }
    }
}

