/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.util;

import com.alibaba.openapi.util.Base64;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public final class GenericsUtil {
    private static final String CHARSET_NAME_UTF8 = "UTF-8";

    private GenericsUtil() {
    }

    public static Class<?> getInterfaceGenricType(Class<?> clazz, Class<?> interfaceClass) {
        return GenericsUtil.getInterfaceGenricType(clazz, interfaceClass, 0);
    }

    public static Class<?> getTypeParameterClass(Class<?> clazz, String name) {
        TypeVariable<Class<?>>[] types = clazz.getTypeParameters();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                if (name.equals(types[i].getName())) {
                    Type[] bounds = types[i] instanceof WildcardType ? ((WildcardType)((Object)types[i])).getLowerBounds() : types[i].getBounds();
                    if (bounds != null && bounds.length > 0) {
                        if (bounds[0] instanceof Class) {
                            return (Class)bounds[0];
                        }
                        if (bounds[0] instanceof TypeVariable) {
                            return GenericsUtil.getTypeParameterClass(clazz, ((TypeVariable)bounds[0]).getName());
                        }
                    }
                    return null;
                }
                ++i;
            }
        }
        return null;
    }

    public static Class<?> getInterfaceGenricType(Class<?> clazz, Class<?> interfaceClass, int typeIndex) {
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        if (interfaceTypes != null && interfaceTypes.length > 0) {
            int i = 0;
            while (i < interfaceTypes.length) {
                Type interfaceType = interfaceTypes[i];
                if (interfaceType instanceof ParameterizedType && interfaceClass.isAssignableFrom((Class)((ParameterizedType)interfaceType).getRawType())) {
                    Type[] params = ((ParameterizedType)interfaceType).getActualTypeArguments();
                    Class[] types = new Class[params.length];
                    int j = 0;
                    while (j < params.length) {
                        if (params[i] instanceof Class) {
                            types[i] = (Class)params[i];
                        } else if (params[i] instanceof WildcardType) {
                            Type[] lowerBounds = ((WildcardType)params[i]).getLowerBounds();
                            if (lowerBounds != null && lowerBounds.length > 0 && lowerBounds[0] instanceof Class) {
                                types[i] = (Class)lowerBounds[0];
                            }
                        } else {
                            types[i] = params[i] instanceof TypeVariable ? GenericsUtil.getTypeParameterClass(clazz, ((TypeVariable)params[i]).getName()) : Object.class;
                        }
                        ++j;
                    }
                    if (typeIndex >= types.length || typeIndex < 0) {
                        return null;
                    }
                    return types[typeIndex];
                }
                ++i;
            }
        }
        return null;
    }

    public static Class<?> getMethodGenericReturnType(Method method, Class<?> rawType, int index) {
        Type returnType = method.getGenericReturnType();
        return GenericsUtil.getGenericType(returnType, rawType, index);
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return GenericsUtil.getRawType(ptype.getRawType());
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    public static Class<?> getGenericType(Type type, Class<?> rawType, int index) {
        ParameterizedType ptype;
        if (type instanceof ParameterizedType && rawType.equals((ptype = (ParameterizedType)type).getRawType())) {
            Type[] typeArguments = ptype.getActualTypeArguments();
            if (index >= typeArguments.length || index < 0) {
                throw new RuntimeException("index " + (index < 0 ? " must large then 0" : "out of arguments count"));
            }
            return GenericsUtil.getRawType(typeArguments[index]);
        }
        return null;
    }

    public static Class<?>[] getGenericType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] typeArguments = ptype.getActualTypeArguments();
            Class[] types = new Class[typeArguments.length];
            System.arraycopy(typeArguments, 0, types, 0, types.length);
            return types;
        }
        return null;
    }

    public static String encodeBase64Str(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return GenericsUtil.toString(Base64.encodeBase64(bytes));
    }

    public static byte[] decodeBase64Str(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Base64.decodeBase64(GenericsUtil.toBytes(str));
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, CHARSET_NAME_UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static byte[] toBytes(String str) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(CHARSET_NAME_UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

