/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DeserializeBeanInfo {
    private final Class<?> clazz;
    private Constructor<?> defaultConstructor;
    private Constructor<?> creatorConstructor;
    private Method factoryMethod;
    private final List<FieldInfo> fieldList = new ArrayList<FieldInfo>();
    private final List<FieldInfo> sortedFieldList = new ArrayList<FieldInfo>();
    private int parserFeatures = 0;

    public DeserializeBeanInfo(Class<?> clazz) {
        this.clazz = clazz;
        this.parserFeatures = TypeUtils.getParserFeatures(clazz);
    }

    public Constructor<?> getDefaultConstructor() {
        return this.defaultConstructor;
    }

    public void setDefaultConstructor(Constructor<?> defaultConstructor) {
        this.defaultConstructor = defaultConstructor;
    }

    public Constructor<?> getCreatorConstructor() {
        return this.creatorConstructor;
    }

    public void setCreatorConstructor(Constructor<?> createConstructor) {
        this.creatorConstructor = createConstructor;
    }

    public Method getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(Method factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<FieldInfo> getFieldList() {
        return this.fieldList;
    }

    public List<FieldInfo> getSortedFieldList() {
        return this.sortedFieldList;
    }

    public FieldInfo getField(String propertyName) {
        for (FieldInfo item : this.fieldList) {
            if (!item.getName().equals(propertyName)) continue;
            return item;
        }
        return null;
    }

    public boolean add(FieldInfo field) {
        for (FieldInfo item : this.fieldList) {
            if (!item.getName().equals(field.getName()) || item.isGetOnly() && !field.isGetOnly()) continue;
            if (item.getFieldClass().isAssignableFrom(field.getFieldClass())) {
                this.fieldList.remove(item);
                break;
            }
            return false;
        }
        this.fieldList.add(field);
        this.sortedFieldList.add(field);
        Collections.sort(this.sortedFieldList);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static DeserializeBeanInfo computeSetters(Class<?> clazz, Type type) {
        beanInfo = new DeserializeBeanInfo(clazz);
        defaultConstructor = DeserializeBeanInfo.getDefaultConstructor(clazz);
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(defaultConstructor);
            beanInfo.setDefaultConstructor(defaultConstructor);
        } else if (defaultConstructor == null && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            creatorConstructor = DeserializeBeanInfo.getCreatorConstructor(clazz);
            if (creatorConstructor != null) {
                TypeUtils.setAccessible(creatorConstructor);
                beanInfo.setCreatorConstructor(creatorConstructor);
                i = 0;
                while (i < creatorConstructor.getParameterTypes().length) {
                    paramAnnotations = creatorConstructor.getParameterAnnotations()[i];
                    fieldAnnotation = null;
                    var11_36 = paramAnnotations;
                    var10_28 = paramAnnotations.length;
                    var9_21 = 0;
                    while (var9_21 < var10_28) {
                        paramAnnotation = var11_36[var9_21];
                        if (paramAnnotation instanceof JSONField) {
                            fieldAnnotation = (JSONField)paramAnnotation;
                            break;
                        }
                        ++var9_21;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    fieldClass = creatorConstructor.getParameterTypes()[i];
                    fieldType = creatorConstructor.getGenericParameterTypes()[i];
                    field = TypeUtils.getField(clazz, fieldAnnotation.name());
                    ordinal = fieldAnnotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    beanInfo.add(fieldInfo);
                    ++i;
                }
                return beanInfo;
            }
            factoryMethod = DeserializeBeanInfo.getFactoryMethod(clazz);
            if (factoryMethod != null) {
                TypeUtils.setAccessible(factoryMethod);
                beanInfo.setFactoryMethod(factoryMethod);
                i = 0;
                while (i < factoryMethod.getParameterTypes().length) {
                    paramAnnotations = factoryMethod.getParameterAnnotations()[i];
                    fieldAnnotation = null;
                    serialzeFeatures = paramAnnotations;
                    ordinal = paramAnnotations.length;
                    field = 0;
                    while (field < ordinal) {
                        paramAnnotation = serialzeFeatures[field];
                        if (paramAnnotation instanceof JSONField) {
                            fieldAnnotation = (JSONField)paramAnnotation;
                            break;
                        }
                        ++field;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    fieldClass = factoryMethod.getParameterTypes()[i];
                    fieldType = factoryMethod.getGenericParameterTypes()[i];
                    field = TypeUtils.getField(clazz, fieldAnnotation.name());
                    ordinal = fieldAnnotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    beanInfo.add(fieldInfo);
                    ++i;
                }
                return beanInfo;
            }
            throw new JSONException("default constructor not found. " + clazz);
        }
        var7_14 = clazz.getMethods();
        var6_11 = var7_14.length;
        var5_8 = 0;
        while (var5_8 < var6_11) {
            block26: {
                block29: {
                    block31: {
                        block30: {
                            block28: {
                                block27: {
                                    method = var7_14[var5_8];
                                    ordinal = 0;
                                    serialzeFeatures = 0;
                                    methodName = method.getName();
                                    if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) && !method.getReturnType().equals(clazz) || method.getParameterTypes().length != 1) break block26;
                                    annotation = method.getAnnotation(JSONField.class);
                                    if (annotation == null) {
                                        annotation = TypeUtils.getSupperMethodAnnotation(clazz, (Method)method);
                                    }
                                    if (annotation == null) break block27;
                                    if (!annotation.deserialize()) break block26;
                                    ordinal = annotation.ordinal();
                                    serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                                    if (annotation.name().length() == 0) break block27;
                                    propertyName = annotation.name();
                                    beanInfo.add(new FieldInfo(propertyName, (Method)method, null, clazz, type, ordinal, serialzeFeatures));
                                    TypeUtils.setAccessible(method);
                                    break block26;
                                }
                                if (!methodName.startsWith("set")) break block26;
                                c3 = methodName.charAt(3);
                                if (!Character.isUpperCase(c3)) break block28;
                                propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
                                break block29;
                            }
                            if (c3 != '_') break block30;
                            propertyName = methodName.substring(4);
                            break block29;
                        }
                        if (c3 != 'f') break block31;
                        propertyName = methodName.substring(3);
                        break block29;
                    }
                    if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) break block26;
                    propertyName = TypeUtils.decapitalize(methodName.substring(3));
                }
                field = TypeUtils.getField(clazz, propertyName);
                if (field == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                    isFieldName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                    field = TypeUtils.getField(clazz, isFieldName);
                }
                if (field == null || (fieldAnnotation = field.getAnnotation(JSONField.class)) == null) ** GOTO lbl-1000
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    beanInfo.add(new FieldInfo(propertyName, (Method)method, field, clazz, type, ordinal, serialzeFeatures));
                } else lbl-1000:
                // 2 sources

                {
                    beanInfo.add(new FieldInfo(propertyName, (Method)method, null, clazz, type, ordinal, serialzeFeatures));
                    TypeUtils.setAccessible(method);
                }
            }
            ++var5_8;
        }
        var7_14 = clazz.getFields();
        var6_11 = var7_14.length;
        var5_8 = 0;
        while (var5_8 < var6_11) {
            field = var7_14[var5_8];
            if (!Modifier.isStatic(field.getModifiers())) {
                contains = false;
                for (FieldInfo item : beanInfo.getFieldList()) {
                    if (!item.getName().equals(field.getName())) continue;
                    contains = true;
                }
                if (!contains) {
                    ordinal = 0;
                    serialzeFeatures = 0;
                    propertyName = field.getName();
                    fieldAnnotation = field.getAnnotation(JSONField.class);
                    if (fieldAnnotation != null) {
                        ordinal = fieldAnnotation.ordinal();
                        serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        if (fieldAnnotation.name().length() != 0) {
                            propertyName = fieldAnnotation.name();
                        }
                    }
                    beanInfo.add(new FieldInfo(propertyName, null, (Field)field, clazz, type, ordinal, serialzeFeatures));
                }
            }
            ++var5_8;
        }
        var7_14 = clazz.getMethods();
        var6_11 = var7_14.length;
        var5_8 = 0;
        while (var5_8 < var6_11) {
            method = var7_14[var5_8];
            methodName = method.getName();
            if (methodName.length() >= 4 && !Modifier.isStatic(method.getModifiers()) && methodName.startsWith("get") && Character.isUpperCase(methodName.charAt(3)) && method.getParameterTypes().length == 0 && (Collection.class.isAssignableFrom(method.getReturnType()) || Map.class.isAssignableFrom(method.getReturnType()) || AtomicBoolean.class == method.getReturnType() || AtomicInteger.class == method.getReturnType() || AtomicLong.class == method.getReturnType()) && (fieldInfo = beanInfo.getField(propertyName = (annotation = method.getAnnotation(JSONField.class)) != null && annotation.name().length() > 0 ? annotation.name() : String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4))) == null) {
                beanInfo.add(new FieldInfo(propertyName, (Method)method, null, clazz, type));
                TypeUtils.setAccessible(method);
            }
            ++var5_8;
        }
        return beanInfo;
    }

    public static Constructor<?> getDefaultConstructor(Class<?> clazz) {
        Constructor<?> constructor;
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        Constructor<?> defaultConstructor = null;
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            if (constructor.getParameterTypes().length == 0) {
                defaultConstructor = constructor;
                break;
            }
            ++n2;
        }
        if (defaultConstructor == null && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            constructorArray = clazz.getDeclaredConstructors();
            n = constructorArray.length;
            n2 = 0;
            while (n2 < n) {
                constructor = constructorArray[n2];
                if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0].equals(clazz.getDeclaringClass())) {
                    defaultConstructor = constructor;
                    break;
                }
                ++n2;
            }
        }
        return defaultConstructor;
    }

    public static Constructor<?> getCreatorConstructor(Class<?> clazz) {
        Constructor<?> creatorConstructor = null;
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            JSONCreator annotation = constructor.getAnnotation(JSONCreator.class);
            if (annotation != null) {
                if (creatorConstructor != null) {
                    throw new JSONException("multi-json creator");
                }
                creatorConstructor = constructor;
                break;
            }
            ++n2;
        }
        return creatorConstructor;
    }

    public static Method getFactoryMethod(Class<?> clazz) {
        Method factoryMethod = null;
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            JSONCreator annotation;
            Method method = methodArray[n2];
            if (Modifier.isStatic(method.getModifiers()) && clazz.isAssignableFrom(method.getReturnType()) && (annotation = method.getAnnotation(JSONCreator.class)) != null) {
                if (factoryMethod != null) {
                    throw new JSONException("multi-json creator");
                }
                factoryMethod = method;
                break;
            }
            ++n2;
        }
        return factoryMethod;
    }

    public int getParserFeatures() {
        return this.parserFeatures;
    }
}

