/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.client.http;

import com.alibaba.openapi.client.Response;
import com.alibaba.openapi.client.http.HttpResponseBuilder;
import com.alibaba.openapi.client.http.HttpSupport;
import com.alibaba.openapi.client.http.InvokeContext;
import com.alibaba.openapi.client.policy.ClientPolicy;
import com.alibaba.openapi.client.policy.Protocol;
import com.alibaba.openapi.client.policy.RequestPolicy;
import com.alibaba.openapi.client.serialize.DeSerializerListener;
import com.alibaba.openapi.client.serialize.Serializer;
import com.alibaba.openapi.client.serialize.SerializerListener;
import com.alibaba.openapi.client.serialize.SerializerProvider;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractHttpClient {
    private SerializerProvider serializerProvider;
    private HttpResponseBuilder responseBuilder;

    public AbstractHttpClient(SerializerProvider serializerProvider, HttpResponseBuilder responseBuilder) {
        this.serializerProvider = serializerProvider;
        this.responseBuilder = responseBuilder;
    }

    public Response request(InvokeContext invokeContext, ClientPolicy clientPolicy, Collection<SerializerListener> serializerListners, Collection<DeSerializerListener> deSerializerListners) throws IOException {
        StringBuilder protocolRequestPath = HttpSupport.getProtocolRequestPath(invokeContext, clientPolicy);
        Protocol protocol = invokeContext.getPolicy().getRequestProtocol();
        Serializer serializer = this.serializerProvider.getSerializer(protocol.name());
        for (SerializerListener serializerListener : serializerListners) {
            serializer.registeSerializerListener(serializerListener);
        }
        Map<String, Object> parameters = HttpSupport.buildParams(serializer, invokeContext);
        HttpSupport.signature(protocolRequestPath, parameters, invokeContext.getPolicy(), clientPolicy);
        if (RequestPolicy.HttpMethodPolicy.GET.equals((Object)invokeContext.getPolicy().getHttpMethod())) {
            URL getURL = HttpSupport.buildGetRequestUrl(clientPolicy, invokeContext, parameters);
            Response response = this.doGet(getURL, parameters, invokeContext, clientPolicy, deSerializerListners);
            return response;
        }
        URL postURL = HttpSupport.buildPostRequestUrl(clientPolicy, invokeContext, parameters);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Object inputValue = entry.getValue();
            if (!inputValue.getClass().isAssignableFrom(byte[].class) && !inputValue.getClass().isAssignableFrom(Byte[].class)) continue;
            return this.doMultipartPost(postURL, parameters, invokeContext, clientPolicy, deSerializerListners);
        }
        Response response = this.doPost(postURL, parameters, invokeContext, clientPolicy, deSerializerListners);
        return response;
    }

    protected abstract Response doMultipartPost(URL var1, Map<String, Object> var2, InvokeContext var3, ClientPolicy var4, Collection<DeSerializerListener> var5) throws IOException;

    protected abstract Response doPost(URL var1, Map<String, Object> var2, InvokeContext var3, ClientPolicy var4, Collection<DeSerializerListener> var5) throws IOException;

    protected abstract Response doGet(URL var1, Map<String, Object> var2, InvokeContext var3, ClientPolicy var4, Collection<DeSerializerListener> var5) throws IOException;

    public SerializerProvider getSerializerProvider() {
        return this.serializerProvider;
    }

    public HttpResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }
}

