/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.client.http;

import com.alibaba.openapi.client.Response;
import com.alibaba.openapi.client.entity.ResponseWrapper;
import com.alibaba.openapi.client.http.HttpResponseBuilder;
import com.alibaba.openapi.client.http.HttpSupport;
import com.alibaba.openapi.client.http.InvokeContext;
import com.alibaba.openapi.client.policy.ClientPolicy;
import com.alibaba.openapi.client.policy.Protocol;
import com.alibaba.openapi.client.serialize.DeSerializer;
import com.alibaba.openapi.client.serialize.DeSerializerListener;
import com.alibaba.openapi.client.serialize.SerializerProvider;
import com.alibaba.openapi.client.util.LoggerHelper;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Collection;
import java.util.zip.GZIPInputStream;

public class DefaultHttpResponseBuilder
implements HttpResponseBuilder {
    private static final String HEADER_NAME_CONTENT_ENCODING = "Content-Encoding";
    protected static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String HEADER_NAME_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_FLAG_CONTENT_TYPE_CHARSET = ";charset=";
    private static final int HEADER_FLAG_LENGTH_CONTENT_TYPE_CHARSET = ";charset=".length();
    protected ClientPolicy clientPolicy;
    private SerializerProvider serializerProvider;

    public DefaultHttpResponseBuilder(ClientPolicy clientPolicy, SerializerProvider serializerProvider) {
        this.clientPolicy = clientPolicy;
        this.serializerProvider = serializerProvider;
    }

    protected <T> T parseBody(InputStream istream, Class<T> resultType, InvokeContext invokeContext, Collection<DeSerializerListener> deSerializerListners) throws IOException, ParseException {
        Protocol protocol = invokeContext.getPolicy().getResponseProtocol();
        if (protocol == null) {
            protocol = invokeContext.getPolicy().getRequestProtocol();
        }
        DeSerializer deSerializer = this.serializerProvider.getDeSerializer(protocol.name());
        for (DeSerializerListener srializerListener : deSerializerListners) {
            deSerializer.registeDeSerializerListener(srializerListener);
        }
        ResponseWrapper<T> responseWrapper = deSerializer.deSerialize(istream, resultType, invokeContext.getResponse().getCharset());
        invokeContext.setResponseWrapper(responseWrapper);
        return responseWrapper.getResult();
    }

    protected Throwable buildException(InputStream istream, int statusCode, InvokeContext invokeContext, Collection<DeSerializerListener> deSerializerListners) throws IOException, ParseException {
        DeSerializer deSerializer;
        Protocol protocol = invokeContext.getPolicy().getResponseProtocol();
        if (protocol == null) {
            protocol = invokeContext.getPolicy().getRequestProtocol();
        }
        if ((deSerializer = this.serializerProvider.getDeSerializer(protocol.name())) == null) {
            throw new RuntimeException("The Protocol[" + protocol.name() + "] is not supported when parse the response.");
        }
        for (DeSerializerListener srializerListener : deSerializerListners) {
            deSerializer.registeDeSerializerListener(srializerListener);
        }
        Throwable rhrowable = deSerializer.buildException(istream, statusCode, invokeContext.getResponse().getCharset());
        return rhrowable;
    }

    @Override
    public Response buildResponse(InputStream istream, int httpCode, String contentEncoding, String contentType, InvokeContext invokeContext, Collection<DeSerializerListener> deSerializerListners) {
        LoggerHelper.getClientLogger().finer("--Start init Response--");
        Response response = new Response();
        invokeContext.setResponse(response);
        response.setStatusCode(httpCode);
        if (contentEncoding != null) {
            response.setEncoding(contentEncoding);
        }
        if (contentType == null) {
            response.setException(new IllegalStateException("response need content type"));
        } else {
            String charset = HttpSupport.parseResponseCharset(invokeContext.getPolicy(), contentType);
            response.setCharset(charset);
        }
        try {
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(response.getEncoding())) {
                LoggerHelper.getClientLogger().finer(" translate InputStream to GZIPInputStream ");
                istream = new GZIPInputStream(istream);
            }
            LoggerHelper.getClientLogger().finer("Response status code :" + response.getStatusCode());
            if (response.getStatusCode() >= 200 && response.getStatusCode() <= 299) {
                Object result = this.parseBody(istream, invokeContext.getResultType(), invokeContext, deSerializerListners);
                response.setResult(result);
            } else {
                Throwable exception = this.buildException(istream, response.getStatusCode(), invokeContext, deSerializerListners);
                response.setException(exception);
            }
        }
        catch (IOException e) {
            response.setException(e);
        }
        catch (RuntimeException e) {
            response.setException(e);
        }
        catch (ParseException e) {
            response.setException(e);
        }
        return response;
    }

    public ClientPolicy getClientPolicy() {
        return this.clientPolicy;
    }
}

