/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.client.imp.serialize;

import com.alibaba.openapi.client.serialize.Serializer;
import com.alibaba.openapi.client.serialize.SerializerListener;
import com.alibaba.openapi.util.DateUtil;
import com.alibaba.openapi.util.DefaultPropertyUtils;
import com.alibaba.openapi.util.GenericsUtil;
import com.alibaba.openapi.util.SimplePropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractParamRequestSerializer
implements Serializer {
    private Map<Class<? extends SerializerListener>, SerializerListener> listnerList = new LinkedHashMap<Class<? extends SerializerListener>, SerializerListener>();

    protected abstract String processNestedParameter(Object var1);

    @Override
    public Map<String, Object> serialize(Object serializer) {
        SimplePropertyDescriptor[] propertyDescriptors;
        if (serializer == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        SimplePropertyDescriptor[] simplePropertyDescriptorArray = propertyDescriptors = DefaultPropertyUtils.getPropertyDescriptors(serializer.getClass());
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            SimplePropertyDescriptor propertyDescriptor = simplePropertyDescriptorArray[n2];
            String name = propertyDescriptor.getName();
            if (!name.equals("class")) {
                try {
                    Method method = propertyDescriptor.getReadMethod();
                    if (method == null && Boolean.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                        Method booleanMethod = null;
                        try {
                            booleanMethod = serializer.getClass().getMethod("is" + GenericsUtil.capitalize(name), new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                        method = booleanMethod;
                    }
                    if (method == null) {
                        throw new RuntimeException("Could not parse the property[" + name + "] of " + serializer.getClass().getSimpleName());
                    }
                    Object value = method.invoke(serializer, new Object[0]);
                    if (value != null) {
                        Class<?> valueType = value.getClass();
                        String valueStr = valueType.isPrimitive() || CharSequence.class.isAssignableFrom(valueType) || Number.class.isAssignableFrom(valueType) || Boolean.class.equals(valueType) || Character.class.equals(valueType) ? value.toString() : (Date.class.isAssignableFrom(valueType) ? DateUtil.format((Date)value) : this.processNestedParameter(value));
                        params.put(name, valueStr);
                    }
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException("illegal argument " + name + ", error:" + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("illegal argument " + name + ", error:" + e.getMessage(), e);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("illegal argument " + name + ", error:" + e.getMessage(), e);
                }
            }
            ++n2;
        }
        for (SerializerListener serializerListener : this.listnerList.values()) {
            serializerListener.onRequestSerialized(params);
        }
        return params;
    }

    @Override
    public void registeSerializerListener(SerializerListener listner) {
        if (!this.listnerList.containsKey(listner.getClass())) {
            this.listnerList.put(listner.getClass(), listner);
        }
    }
}

