/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.client.imp.serialize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.openapi.client.entity.ResponseWrapper;
import com.alibaba.openapi.client.imp.serialize.AbstractJsonDeserializer;
import com.alibaba.openapi.client.policy.Protocol;
import com.alibaba.openapi.client.serialize.DeSerializerListener;
import com.alibaba.openapi.client.util.ExceptionParser;
import java.util.LinkedHashMap;
import java.util.Map;

public class Json2Deserializer
extends AbstractJsonDeserializer {
    private Map<Class<? extends DeSerializerListener>, DeSerializerListener> listnerList = new LinkedHashMap<Class<? extends DeSerializerListener>, DeSerializerListener>();

    @Override
    public String supportedContentType() {
        return Protocol.json2.name();
    }

    @Override
    public <T> ResponseWrapper<T> deSerialize(String content, Class<T> resultType) {
        for (DeSerializerListener deSerializerListener : this.listnerList.values()) {
            deSerializerListener.onResponseDeSerialized(content);
        }
        JSONObject json = JSON.parseObject(content);
        T result = this.parseResult(json, resultType);
        ResponseWrapper<T> responseWrapper = new ResponseWrapper<T>();
        responseWrapper.setResult(result);
        return responseWrapper;
    }

    @Override
    public Throwable buildException(String content, int statusCode) {
        for (DeSerializerListener deSerializerListener : this.listnerList.values()) {
            deSerializerListener.onResponseExceptioned(content);
        }
        Map result = JSON.parseObject(content, Map.class);
        return ExceptionParser.buildException4Json2(result);
    }

    @Override
    public void registeDeSerializerListener(DeSerializerListener listner) {
        if (!this.listnerList.containsKey(listner.getClass())) {
            this.listnerList.put(listner.getClass(), listner);
        }
    }
}

