/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.client.policy;

import com.alibaba.openapi.client.ErrorHandler;
import com.alibaba.openapi.client.policy.Protocol;

public class RequestPolicy
implements Cloneable {
    private boolean requestSendTimestamp = false;
    private boolean useHttps = false;
    private Protocol requestProtocol = Protocol.param2;
    private Protocol responseProtocol = Protocol.json2;
    private boolean responseCompress = true;
    private int requestCompressThreshold = -1;
    private int timeout = 5000;
    private HttpMethodPolicy httpMethod = HttpMethodPolicy.POST;
    private String queryStringCharset = "GB18030";
    private String contentCharset = "UTF-8";
    private boolean useSignture = true;
    private boolean needAuthorization = false;
    private boolean accessPrivateApi = false;
    private int defaultApiVersion = 1;
    private ErrorHandler errorHandler;
    public static RequestPolicy authPolicy = null;

    public static RequestPolicy getAuthPolicy() {
        if (authPolicy == null) {
            authPolicy = new RequestPolicy().setHttpMethod(HttpMethodPolicy.POST).setRequestProtocol(Protocol.param2).setUseHttps(true).setNeedAuthorization(false);
        }
        return authPolicy;
    }

    public RequestPolicy clone() {
        RequestPolicy newObj = this.newPolicy();
        newObj.requestSendTimestamp = this.requestSendTimestamp;
        newObj.useHttps = this.useHttps;
        newObj.requestProtocol = this.requestProtocol;
        newObj.responseProtocol = this.responseProtocol;
        newObj.responseCompress = this.responseCompress;
        newObj.requestCompressThreshold = this.requestCompressThreshold;
        newObj.timeout = this.timeout;
        newObj.httpMethod = this.httpMethod;
        newObj.queryStringCharset = this.queryStringCharset;
        newObj.contentCharset = this.contentCharset;
        newObj.useSignture = this.useSignture;
        newObj.accessPrivateApi = this.accessPrivateApi;
        newObj.defaultApiVersion = this.defaultApiVersion;
        return newObj;
    }

    protected RequestPolicy newPolicy() {
        return new RequestPolicy();
    }

    public RequestPolicy setRequestSendTimestamp(boolean requestSendTimestamp) {
        this.requestSendTimestamp = requestSendTimestamp;
        return this;
    }

    public boolean isRequestSendTimestamp() {
        return this.requestSendTimestamp;
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public RequestPolicy setUseHttps(boolean useHttps) {
        this.useHttps = useHttps;
        return this;
    }

    public RequestPolicy setRequestProtocol(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol can not be null");
        }
        this.requestProtocol = protocol;
        return this;
    }

    public Protocol getRequestProtocol() {
        return this.requestProtocol;
    }

    public boolean isResponseCompress() {
        return this.responseCompress;
    }

    private RequestPolicy setResponseCompress(boolean responseCompress) {
        this.responseCompress = responseCompress;
        return this;
    }

    public int getRequestCompressThreshold() {
        return this.requestCompressThreshold;
    }

    public RequestPolicy setRequestCompressThreshold(int requestCompressThreshold) {
        this.requestCompressThreshold = requestCompressThreshold;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public RequestPolicy setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public RequestPolicy setHttpMethod(HttpMethodPolicy httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public HttpMethodPolicy getHttpMethod() {
        return this.httpMethod;
    }

    public String getQueryStringCharset() {
        return this.queryStringCharset;
    }

    public RequestPolicy setQueryStringCharset(String queryStringCharset) {
        this.queryStringCharset = queryStringCharset;
        return this;
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public RequestPolicy setContentCharset(String contentCharset) {
        this.contentCharset = contentCharset;
        return this;
    }

    public RequestPolicy setResponseProtocol(Protocol responseProtocol) {
        if (this.requestProtocol == null) {
            throw new IllegalArgumentException("response protocol can not be null");
        }
        this.responseProtocol = responseProtocol;
        return this;
    }

    public Protocol getResponseProtocol() {
        return this.responseProtocol;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public RequestPolicy setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public boolean isUseSignture() {
        return this.useSignture;
    }

    public RequestPolicy setUseSignture(boolean useSignture) {
        this.useSignture = useSignture;
        return this;
    }

    public boolean isNeedAuthorization() {
        return this.needAuthorization;
    }

    public RequestPolicy setNeedAuthorization(boolean needAuthorization) {
        this.needAuthorization = needAuthorization;
        return this;
    }

    public boolean isAccessPrivateApi() {
        return this.accessPrivateApi;
    }

    public void setAccessPrivateApi(boolean accessPrivateApi) {
        this.accessPrivateApi = accessPrivateApi;
    }

    public int getDefaultApiVersion() {
        return this.defaultApiVersion;
    }

    public static enum HttpMethodPolicy {
        POST,
        GET;

    }
}

