/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.client.util;

import com.alibaba.openapi.client.exception.AuthServiceException;
import com.alibaba.openapi.client.exception.InvokeConnectException;
import com.alibaba.openapi.client.exception.InvokeTimeoutException;
import com.alibaba.openapi.client.exception.OceanException;
import com.alibaba.openapi.client.exception.SecurityException;
import com.alibaba.openapi.client.exception.UnsupportAPIException;
import com.alibaba.openapi.util.GenericsUtil;
import java.util.Map;

public class ExceptionParser {
    public static Throwable buildException4Json2(Map exption) {
        Map m = exption;
        String errorCodeStr = (String)m.get("error_code");
        String errorMesage = (String)m.get("error_message");
        if (GenericsUtil.isBlank(errorMesage)) {
            errorMesage = "Unknow message defined in response.";
        }
        if (GenericsUtil.isBlank(errorCodeStr) || !GenericsUtil.isNumeric(errorCodeStr)) {
            return ExceptionParser.buildException(errorCodeStr, errorMesage);
        }
        int errorCode = Integer.parseInt(errorCodeStr);
        return ExceptionParser.buildException(errorCode, errorMesage);
    }

    public static Throwable buildException4OAuth2(Object exption) {
        Map m = (Map)exption;
        int errorCode = 401;
        String errorMesage = (String)m.get("error_description");
        return ExceptionParser.buildException(errorCode, errorMesage);
    }

    private static Throwable buildException(int errorCode, String errorMesage) {
        switch (errorCode) {
            case 400: {
                return new SecurityException(errorMesage);
            }
            case 401: {
                return new AuthServiceException(errorMesage);
            }
            case 404: {
                return new UnsupportAPIException(errorMesage);
            }
            case 502: {
                return new InvokeConnectException(errorMesage);
            }
            case 504: {
                return new InvokeTimeoutException(errorMesage);
            }
        }
        return new OceanException(String.valueOf(errorCode), errorMesage);
    }

    private static Throwable buildException(String errorCode, String errorMesage) {
        return new OceanException(errorCode, errorMesage);
    }
}

