/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.example;

import com.alibaba.openapi.client.entity.AuthorizationToken;
import com.alibaba.openapi.example.ExampleFacade;
import com.alibaba.openapi.example.param.apiexample.ExampleCar;
import com.alibaba.openapi.example.param.apiexample.ExampleFamily;
import com.alibaba.openapi.example.param.apiexample.ExampleFamilyGetParam;
import com.alibaba.openapi.example.param.apiexample.ExampleFamilyGetResult;
import com.alibaba.openapi.example.param.apiexample.ExampleFamilyPostParam;
import com.alibaba.openapi.example.param.apiexample.ExampleFamilyPostResult;
import com.alibaba.openapi.example.param.apiexample.ExampleHouse;
import com.alibaba.openapi.example.param.apiexample.ExamplePerson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Example {
    public static final String DATE_FORMAT_STR = "yyyy-MM-dd HH:mm:ss";
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static ExampleFamily createFirstFamily() {
        ExampleFamily family = new ExampleFamily();
        ExamplePerson father = new ExamplePerson();
        father.setAge(38);
        father.setBirthday(Example.createDate("1978-03-12 10:10:10"));
        father.setMobileNumber("27088888888");
        father.setName("\u5f20\u8fdb\u5219");
        family.setFather(father);
        ExamplePerson mother = new ExamplePerson();
        mother.setAge(33);
        mother.setBirthday(Example.createDate("1983-06-17 10:10:10"));
        mother.setMobileNumber("27099999999");
        mother.setName("\u5468\u715c\u6e05");
        family.setMother(mother);
        ExamplePerson xiaoming = new ExamplePerson();
        xiaoming.setBirthday(Example.createDate("2010-10-17 10:10:10"));
        xiaoming.setName("\u5f20\u5c0f\u660e");
        ExamplePerson xiaogang = new ExamplePerson();
        xiaogang.setBirthday(Example.createDate("2010-10-17 10:20:10"));
        xiaogang.setName("\u5f20\u5c0f\u521a");
        ExamplePerson[] children = new ExamplePerson[]{xiaoming, xiaogang};
        family.setChildren(children);
        family.setFamilyNumber(1);
        family.setMyHouse(Example.createHouse("\u4e2d\u56fd\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a", false));
        ExampleCar[] ownedCars = new ExampleCar[]{Example.createCar("BMW", 370000.12), Example.createCar("Ford", 150000.27)};
        family.setOwnedCars(ownedCars);
        return family;
    }

    private static ExampleFamily createSecondFamily() {
        ExampleFamily family = new ExampleFamily();
        ExamplePerson mother = new ExamplePerson();
        mother.setAge(33);
        mother.setBirthday(Example.createDate("1983-06-17 10:10:10"));
        mother.setMobileNumber("27099999999");
        mother.setName("\u53f6\u6db5");
        family.setMother(mother);
        ExamplePerson xiaoming = new ExamplePerson();
        xiaoming.setBirthday(Example.createDate("2010-10-17 10:10:10"));
        xiaoming.setName("\u53f6\u5b50\u6db5");
        xiaoming.setAge(6);
        ExamplePerson[] children = new ExamplePerson[]{xiaoming};
        family.setChildren(children);
        family.setFamilyNumber(2);
        family.setMyHouse(Example.createHouse("\u4e2d\u56fd\u6d59\u6c5f\u7701\u676d\u5dde\u5e02\u6ee8\u6c5f\u533a", null));
        ExampleCar[] ownedCars = new ExampleCar[]{Example.createCar("XXXX", 1370000.12)};
        family.setOwnedCars(ownedCars);
        return family;
    }

    private static ExampleCar createCar(String name, Double price) {
        ExampleCar car = new ExampleCar();
        car.setBoughtDate(Example.createDate("2008-10-17 10:20:10"));
        car.setBuiltArea("\u4e2d\u56fd");
        car.setBuiltDate(Example.createDate("2007-10-17 10:20:10"));
        car.setCarNumber("HZ-H-9875");
        car.setName(name);
        car.setPrice(price);
        car.setSeats(4);
        return car;
    }

    private static ExampleHouse createHouse(String address, Boolean rent) {
        ExampleHouse house = new ExampleHouse();
        house.setAreaSize(120);
        house.setLocation(address);
        house.setRent(rent);
        return house;
    }

    private static Date createDate(String input) {
        try {
            return simpleDateFormat.parse(input);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] getPicture(String fileName) {
        URL fatherURL = Example.class.getClassLoader().getResource(fileName);
        try {
            InputStream inputStream = fatherURL.openStream();
            byte[] bs = new byte[0x100000];
            int readCount = inputStream.read(bs);
            byte[] content = new byte[readCount];
            System.arraycopy(bs, 0, content, 0, readCount);
            return content;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void exampleFamilyGet(ExampleFacade cnApiFacadeInst) {
        ExampleFamilyGetParam exampleFamilyGetParam = new ExampleFamilyGetParam();
        exampleFamilyGetParam.setFamilyNumber(1);
        exampleFamilyGetParam.setMyTest(new ExampleFamily[]{Example.createFirstFamily()});
        ExampleFamilyGetResult exampleFamilyGetResult = cnApiFacadeInst.getApiExample().exampleFamilyGet(exampleFamilyGetParam);
        System.out.println("ExampleFamilyGet call, father's name of Result:" + exampleFamilyGetResult.getResult().getFather().getName());
    }

    private void exampleFamilyPost(ExampleFacade cnApiFacadeInst, String accessToken) {
        ExampleFamilyPostParam exampleFamilyPostParam = new ExampleFamilyPostParam();
        exampleFamilyPostParam.setComments("Example for SDK");
        exampleFamilyPostParam.setFamily(Example.createFirstFamily());
        exampleFamilyPostParam.setHouseImg(Example.getPicture("example.png"));
        ExampleFamilyPostResult exampleFamilyPostResult = cnApiFacadeInst.getApiExample().exampleFamilyPost(exampleFamilyPostParam, accessToken);
        System.out.println("ExampleFamilyPost call, FamilyNumber of Result:" + exampleFamilyPostResult.getResult().getFamilyNumber());
        System.out.println("ExampleFamilyPost call, Desc of Result:" + exampleFamilyPostResult.getResultDesc());
    }

    public static void main(String[] args) {
        ExampleFacade cnApiFacadeInst = new ExampleFacade();
        cnApiFacadeInst.setAppKey("set your app key");
        cnApiFacadeInst.setSigningKey("set your app secret");
        Example exampleDomain = new Example();
        exampleDomain.exampleFamilyGet(cnApiFacadeInst);
        AuthorizationToken authorizationToken = cnApiFacadeInst.refreshToken("{your refreshToken}");
        String accessToken = authorizationToken.getAccess_token();
        exampleDomain.exampleFamilyPost(cnApiFacadeInst, accessToken);
    }
}

