/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.example;

import com.alibaba.openapi.client.AlibabaClientFactory;
import com.alibaba.openapi.client.OceanApiFacadeInterface;
import com.alibaba.openapi.client.Request;
import com.alibaba.openapi.client.SDKListener;
import com.alibaba.openapi.client.SyncAPIClient;
import com.alibaba.openapi.client.entity.AuthorizationToken;
import com.alibaba.openapi.client.entity.AuthorizationTokenStore;
import com.alibaba.openapi.client.entity.DefaultAuthorizationTokenStore;
import com.alibaba.openapi.client.policy.ClientPolicy;
import com.alibaba.openapi.client.policy.RequestPolicy;
import com.alibaba.openapi.client.serialize.DeSerializerListener;
import com.alibaba.openapi.client.serialize.SerializerListener;
import com.alibaba.openapi.example.param.apiexample.ExampleFamilyGetParam;
import com.alibaba.openapi.example.param.apiexample.ExampleFamilyGetResult;
import com.alibaba.openapi.example.param.apiexample.ExampleFamilyPostParam;
import com.alibaba.openapi.example.param.apiexample.ExampleFamilyPostResult;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ExampleFacade
implements OceanApiFacadeInterface,
SDKListener {
    private String serverHost = "gw.open.1688.com";
    private int httpPort = 80;
    private int httpsPort = 443;
    private String appKey;
    private String secKey;
    private AuthorizationTokenStore authorizationTokenStore;
    private Map<Class<? extends SerializerListener>, SerializerListener> serializerListeners = new LinkedHashMap<Class<? extends SerializerListener>, SerializerListener>();
    private Map<Class<? extends DeSerializerListener>, DeSerializerListener> deSerializerListeners = new LinkedHashMap<Class<? extends DeSerializerListener>, DeSerializerListener>();
    private ApiExample _ApiExample = new ApiExample();

    @Override
    public void register(SerializerListener serializerListener) {
        this.serializerListeners.put(serializerListener.getClass(), serializerListener);
    }

    @Override
    public void register(DeSerializerListener deSerializerListener) {
        this.deSerializerListeners.put(deSerializerListener.getClass(), deSerializerListener);
    }

    @Override
    public SyncAPIClient getAPIClient() {
        ClientPolicy clientPolicy = new ClientPolicy(this.serverHost);
        clientPolicy.setHttpPort(this.httpPort);
        clientPolicy.setHttpsPort(this.httpsPort);
        if (this.appKey != null) {
            clientPolicy.setAppKey(this.appKey);
        }
        if (this.secKey != null) {
            clientPolicy.setSigningKey(this.secKey);
        }
        if (this.authorizationTokenStore == null) {
            this.authorizationTokenStore = new DefaultAuthorizationTokenStore();
        }
        SyncAPIClient syncAPIClient = new AlibabaClientFactory().createAPIClient(clientPolicy, this.authorizationTokenStore);
        return syncAPIClient;
    }

    @Override
    public final void setServerHost(String host) {
        this.serverHost = host;
    }

    @Override
    public final void setHttpPort(int port) {
        this.httpPort = port;
    }

    @Override
    public final void setHttpsPort(int port) {
        this.httpsPort = port;
    }

    @Override
    public final void setAppKey(String newAppKey) {
        this.appKey = newAppKey;
    }

    @Override
    public final void setSigningKey(String newSecKey) {
        this.secKey = newSecKey;
    }

    public final AuthorizationToken getToken(String code) {
        try {
            return this.getAPIClient().getToken(code);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final AuthorizationToken refreshToken(String refreshToken) {
        try {
            return this.getAPIClient().refreshToken(refreshToken);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ApiExample getApiExample() {
        return this._ApiExample;
    }

    public final class ApiExample {
        public final ExampleFamilyGetResult exampleFamilyGet(ExampleFamilyGetParam param) {
            RequestPolicy reqPolicy = new RequestPolicy();
            reqPolicy.setHttpMethod(RequestPolicy.HttpMethodPolicy.POST).setNeedAuthorization(false).setRequestSendTimestamp(false).setUseHttps(false).setUseSignture(false).setAccessPrivateApi(false);
            try {
                Request req = new Request("aliexpress.open.ningyong", "example.family.get", 1);
                req.setRequestEntity(param);
                ExampleFamilyGetResult ret = ExampleFacade.this.getAPIClient().send(req, ExampleFamilyGetResult.class, reqPolicy, ExampleFacade.this.serializerListeners.values(), ExampleFacade.this.deSerializerListeners.values());
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public final ExampleFamilyPostResult exampleFamilyPost(ExampleFamilyPostParam param, String accessToken) {
            RequestPolicy reqPolicy = new RequestPolicy();
            reqPolicy.setHttpMethod(RequestPolicy.HttpMethodPolicy.POST).setNeedAuthorization(true).setRequestSendTimestamp(false).setUseHttps(false).setUseSignture(true).setAccessPrivateApi(false);
            try {
                Request req = new Request("aliexpress.open.ningyong", "example.family.post", 1);
                req.setRequestEntity(param);
                req.setAccessToken(accessToken);
                ExampleFamilyPostResult ret = ExampleFacade.this.getAPIClient().send(req, ExampleFamilyPostResult.class, reqPolicy, ExampleFacade.this.serializerListeners.values(), ExampleFacade.this.deSerializerListeners.values());
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

