/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtil {
    public static final String DEFAULT_DATE_FORMAT_STR = "yyyyMMddHHmmssSSSZ";
    private static SimpleDateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");

    public static String format(Date d) {
        return DateUtil.format(d, null);
    }

    public static String format(Date d, String pattern) {
        return DateUtil.format(d, pattern, null);
    }

    public static String format(Date d, String pattern, TimeZone timeZone) {
        if (d == null) {
            return null;
        }
        SimpleDateFormat format = pattern != null ? new SimpleDateFormat(pattern) : (SimpleDateFormat)DEFAULT_FORMAT.clone();
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        return format.format(d);
    }

    public static Date parse(String str) throws ParseException {
        return DateUtil.parse(str, null);
    }

    public static Date parse(String source, String pattern) throws ParseException {
        return DateUtil.parse(source, pattern, null);
    }

    public static Date parse(String source, String pattern, TimeZone timeZone) throws ParseException {
        if (source == null) {
            return null;
        }
        SimpleDateFormat format = pattern != null ? new SimpleDateFormat(pattern) : (SimpleDateFormat)DEFAULT_FORMAT.clone();
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        return format.parse(source);
    }

    private DateUtil() {
    }
}

