/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.openapi.util;

import com.alibaba.openapi.util.GenericsUtil;
import com.alibaba.openapi.util.SimplePropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

public class DefaultPropertyUtils {
    private static HashMap<Class, SimplePropertyDescriptor[]> descriptorsCache = new HashMap();

    public static SimplePropertyDescriptor[] getPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            return new SimplePropertyDescriptor[0];
        }
        SimplePropertyDescriptor[] descriptors = null;
        descriptors = descriptorsCache.get(beanClass);
        if (descriptors != null) {
            return descriptors;
        }
        Field[] fields = beanClass.getDeclaredFields();
        if (fields == null) {
            descriptors = new SimplePropertyDescriptor[]{};
        } else {
            descriptors = new SimplePropertyDescriptor[fields.length];
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                SimplePropertyDescriptor simplePropertyDescriptor = new SimplePropertyDescriptor();
                simplePropertyDescriptor.setName(field.getName());
                simplePropertyDescriptor.setPropertyType(field.getType());
                try {
                    Method readMethod = beanClass.getMethod("get" + GenericsUtil.capitalize(field.getName()), new Class[0]);
                    simplePropertyDescriptor.setReadMethod(readMethod);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                descriptors[i] = simplePropertyDescriptor;
                ++i;
            }
        }
        descriptorsCache.put(beanClass, descriptors);
        return descriptors;
    }
}

