/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.concurrent;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import java.util.List;
import java.util.Random;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import org.jaxen.JaxenException;

public class AvoidConcurrentCompetitionRandomRule
extends AbstractAliRule {
    private static final String XPATH_TPL = "//StatementExpression/PrimaryExpression/PrimaryPrefix/Name[starts-with(@Image,'%s.')]";
    private static final String MATH_RANDOM_METHOD = ".random";
    private static final String MESSAGE_KEY_PREFIX = "java.concurrent.AvoidConcurrentCompetitionRandomRule";

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        ASTExtendsList extendsList = (ASTExtendsList)node.getFirstChildOfType(ASTExtendsList.class);
        if (extendsList == null) {
            return super.visit(node, data);
        }
        if (!this.hasThread(extendsList)) {
            return super.visit(node, data);
        }
        List methodDeclarations = node.findDescendantsOfType(ASTMethodDeclaration.class);
        if (methodDeclarations == null || methodDeclarations.isEmpty()) {
            return super.visit(node, data);
        }
        this.checkMathRandom(methodDeclarations, data);
        List fieldDeclarations = node.findDescendantsOfType(ASTFieldDeclaration.class);
        if (fieldDeclarations == null || fieldDeclarations.isEmpty()) {
            return super.visit(node, data);
        }
        for (ASTFieldDeclaration fieldDeclaration : fieldDeclarations) {
            if (fieldDeclaration.getType() != Random.class || !fieldDeclaration.isStatic()) continue;
            this.checkRandom(fieldDeclaration, methodDeclarations, data);
        }
        return super.visit(node, data);
    }

    private void checkMathRandom(List<ASTMethodDeclaration> methodDeclarations, Object data) {
        for (ASTMethodDeclaration methodDeclaration : methodDeclarations) {
            List primaryPrefixes = methodDeclaration.findDescendantsOfType(ASTPrimaryPrefix.class);
            if (primaryPrefixes == null || primaryPrefixes.isEmpty()) continue;
            for (ASTPrimaryPrefix primaryPrefix : primaryPrefixes) {
                ASTName name;
                if (primaryPrefix.getType() != Math.class || (name = (ASTName)primaryPrefix.getFirstChildOfType(ASTName.class)) == null || name.getImage() == null || !name.getImage().endsWith(MATH_RANDOM_METHOD)) continue;
                this.addViolationWithMessage(data, (Node)primaryPrefix, "java.concurrent.AvoidConcurrentCompetitionRandomRule.violation.msg.math.random");
            }
        }
    }

    private void checkRandom(ASTFieldDeclaration fieldDeclaration, List<ASTMethodDeclaration> methodDeclarations, Object data) {
        for (ASTMethodDeclaration methodDeclaration : methodDeclarations) {
            try {
                List nodes = methodDeclaration.findChildNodesWithXPath(String.format(XPATH_TPL, fieldDeclaration.getVariableName()));
                if (nodes == null || nodes.isEmpty()) continue;
                for (Node rvNode : nodes) {
                    this.addViolationWithMessage(data, rvNode, "java.concurrent.AvoidConcurrentCompetitionRandomRule.violation.msg.random", new Object[]{rvNode.getImage()});
                }
            }
            catch (JaxenException jaxenException) {
            }
        }
    }

    private boolean hasThread(ASTExtendsList extendsList) {
        List typeList = extendsList.findChildrenOfType(ASTClassOrInterfaceType.class);
        if (typeList == null || typeList.isEmpty()) {
            return false;
        }
        for (ASTClassOrInterfaceType type : typeList) {
            if (type.getType() != Thread.class) continue;
            return true;
        }
        return false;
    }
}

