/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.exception;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValuePair;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import org.jaxen.JaxenException;

public class TransactionMustHaveRollbackRule
extends AbstractAliRule {
    private static final String TRANSACTIONAL_ANNOTATION_NAME = "Transactional";
    private static final String TRANSACTIONAL_FULL_NAME = "org.springframework.transaction.annotation.Transactional";
    private static final String ROLLBACK_PREFIX = "rollback";
    private static final String PROPAGATION_NOT_SUPPORTED = "Propagation.NOT_SUPPORTED";
    private static final String XPATH_FOR_ROLLBACK = "//StatementExpression/PrimaryExpression/PrimaryPrefix/Name[ends-with(@Image,'rollback')]";
    private static final String MESSAGE_KEY_PREFIX = "java.exception.TransactionMustHaveRollbackRule.violation.msg";

    public Object visit(ASTAnnotation node, Object data) {
        boolean noTransactional;
        ASTName name = (ASTName)node.getFirstDescendantOfType(ASTName.class);
        boolean bl = noTransactional = name == null || !TRANSACTIONAL_ANNOTATION_NAME.equals(name.getImage()) || TRANSACTIONAL_FULL_NAME.equals(name.getImage());
        if (noTransactional) {
            return super.visit(node, data);
        }
        List memberValuePairList = node.findDescendantsOfType(ASTMemberValuePair.class);
        if (this.shouldSkip(memberValuePairList)) {
            return super.visit(node, data);
        }
        ASTClassOrInterfaceDeclaration classOrInterfaceDeclaration = this.getSiblingForType(node, ASTClassOrInterfaceDeclaration.class);
        if (classOrInterfaceDeclaration != null) {
            this.addViolationWithMessage(data, (Node)node, "java.exception.TransactionMustHaveRollbackRule.violation.msg.simple");
            return super.visit(node, data);
        }
        ASTMethodDeclaration methodDeclaration = this.getSiblingForType(node, ASTMethodDeclaration.class);
        if (methodDeclaration == null) {
            return super.visit(node, data);
        }
        try {
            List nodes = methodDeclaration.findChildNodesWithXPath(XPATH_FOR_ROLLBACK);
            if (nodes != null && !nodes.isEmpty()) {
                return super.visit(node, data);
            }
            this.addViolationWithMessage(data, (Node)methodDeclaration, MESSAGE_KEY_PREFIX, new Object[]{methodDeclaration.getMethodName()});
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        return super.visit(node, data);
    }

    private boolean shouldSkip(List<ASTMemberValuePair> memberValuePairList) {
        for (ASTMemberValuePair pair : memberValuePairList) {
            if (pair.getImage() == null) continue;
            if (pair.getImage().startsWith(ROLLBACK_PREFIX)) {
                return true;
            }
            ASTName name = (ASTName)pair.getFirstDescendantOfType(ASTName.class);
            if (name == null || !PROPAGATION_NOT_SUPPORTED.equals(name.getImage())) continue;
            return true;
        }
        return false;
    }

    private <T> T getSiblingForType(ASTAnnotation node, Class<T> clz) {
        Node parent = node.jjtGetParent();
        int num = parent.jjtGetNumChildren();
        for (int i = 0; i < num; ++i) {
            Node child = parent.jjtGetChild(i);
            if (clz.isAssignableFrom(child.getClass())) {
                return clz.cast(child);
            }
            if (child instanceof ASTAnnotation) continue;
            return null;
        }
        return null;
    }
}

