/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.flowcontrol;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;

public class NeedBraceRule
extends AbstractAliRule {
    private static final String STATEMENT_BLOCK = "Statement/Block";
    private static final String MESSAGE_KEY = "java.flowcontrol.NeedBraceRule.violation.msg";

    public Object visit(ASTIfStatement node, Object data) {
        if (!node.hasDescendantMatchingXPath(STATEMENT_BLOCK)) {
            this.addViolationWithMessage(data, (Node)node, MESSAGE_KEY, new Object[]{node.jjtGetFirstToken().toString()});
        }
        if (node.hasElse()) {
            ASTStatement elseStms = (ASTStatement)node.findChildrenOfType(ASTStatement.class).get(1);
            if (!elseStms.hasDecendantOfAnyType(new Class[]{ASTBlock.class, ASTIfStatement.class})) {
                this.addViolationWithMessage(data, (Node)elseStms, MESSAGE_KEY, new Object[]{"else"});
            }
        }
        return super.visit(node, data);
    }

    public Object visit(ASTForStatement node, Object data) {
        if (!node.hasDescendantMatchingXPath(STATEMENT_BLOCK)) {
            this.addViolationWithMessage(data, (Node)node, MESSAGE_KEY, new Object[]{"for"});
        }
        return super.visit(node, data);
    }

    public Object visit(ASTWhileStatement node, Object data) {
        if (!node.hasDescendantMatchingXPath(STATEMENT_BLOCK)) {
            this.addViolationWithMessage(data, (Node)node, MESSAGE_KEY, new Object[]{"while"});
        }
        return super.visit(node, data);
    }
}

