/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.util;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class ViolationUtils {
    public static void addViolationWithPrecisePosition(AbstractRule rule, Node node, Object data) {
        ViolationUtils.addViolationWithPrecisePosition(rule, node, data, null);
    }

    public static void addViolationWithPrecisePosition(AbstractRule rule, Node node, Object data, String message) {
        if (node instanceof ASTFieldDeclaration) {
            ASTVariableDeclaratorId variableDeclaratorId = (ASTVariableDeclaratorId)node.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
            ViolationUtils.addViolation(rule, (Node)variableDeclaratorId, data, message);
            return;
        }
        if (node instanceof ASTMethodDeclaration) {
            ASTMethodDeclarator declarator = (ASTMethodDeclarator)node.getFirstChildOfType(ASTMethodDeclarator.class);
            ViolationUtils.addViolation(rule, (Node)declarator, data, message);
            return;
        }
        ViolationUtils.addViolation(rule, node, data, message);
    }

    private static void addViolation(AbstractRule rule, Node node, Object data, String message) {
        if (message == null) {
            rule.addViolation(data, node);
        } else {
            rule.addViolationWithMessage(data, node, message);
        }
    }
}

