/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.concurrent;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.rule.util.NodeUtils;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessTypeNode;
import net.sourceforge.pmd.lang.java.ast.Token;

public class AvoidManuallyCreateThreadRule
extends AbstractAliRule {
    private static final String METHOD_NEW_THREAD = "newThread";

    public Object visit(ASTAllocationExpression node, Object data) {
        boolean isThreadFactory;
        if (node.getType() != Thread.class) {
            return super.visit(node, data);
        }
        if (this.isAddShutdownHook(node) || this.isInStaticInitializer(node)) {
            return super.visit(node, data);
        }
        if (node.getFirstParentOfType(ASTLambdaExpression.class) != null) {
            return super.visit(node, data);
        }
        ASTFieldDeclaration fieldDeclaration = (ASTFieldDeclaration)node.getFirstParentOfType(ASTFieldDeclaration.class);
        if (fieldDeclaration != null && NodeUtils.getNodeType((AbstractJavaAccessTypeNode)fieldDeclaration) == Thread.class) {
            return this.addViolationAndReturn(node, data);
        }
        if (node.getDataFlowNode() == null && node.getFirstParentOfType(ASTLambdaExpression.class) != null) {
            if (fieldDeclaration == null || NodeUtils.getNodeType((AbstractJavaAccessTypeNode)fieldDeclaration) != ThreadFactory.class) {
                return this.addViolationAndReturn(node, data);
            }
            return super.visit(node, data);
        }
        if (this.isInNewThreadMethod(node)) {
            return super.visit(node, data);
        }
        boolean bl = isThreadFactory = (this.checkForNamingClass(node) || this.threadFactoryVariable(node)) && this.isInPrimaryOrProtectedMethod(node);
        if (isThreadFactory) {
            return super.visit(node, data);
        }
        return this.addViolationAndReturn(node, data);
    }

    private boolean isAddShutdownHook(ASTAllocationExpression node) {
        ASTBlockStatement blockStatement = (ASTBlockStatement)node.getFirstParentOfType(ASTBlockStatement.class);
        if (blockStatement == null) {
            return false;
        }
        Token token = (Token)blockStatement.jjtGetFirstToken();
        return Runtime.class.getSimpleName().equals(token.image);
    }

    private boolean isInStaticInitializer(ASTAllocationExpression node) {
        ASTInitializer initializer = (ASTInitializer)node.getFirstParentOfType(ASTInitializer.class);
        return initializer != null && initializer.isStatic();
    }

    private boolean threadFactoryVariable(ASTAllocationExpression node) {
        ASTMethodDeclaration methodDeclaration = (ASTMethodDeclaration)node.getFirstParentOfType(ASTMethodDeclaration.class);
        if (methodDeclaration == null) {
            return false;
        }
        ASTVariableDeclarator variableDeclarator = (ASTVariableDeclarator)methodDeclaration.getFirstParentOfType(ASTVariableDeclarator.class);
        return variableDeclarator != null && variableDeclarator.getType() == ThreadFactory.class;
    }

    private boolean isInNewThreadMethod(ASTAllocationExpression node) {
        ASTMethodDeclaration methodDeclaration = (ASTMethodDeclaration)node.getFirstParentOfType(ASTMethodDeclaration.class);
        if (methodDeclaration == null) {
            return false;
        }
        if (!this.returnThread(methodDeclaration)) {
            return false;
        }
        if (!METHOD_NEW_THREAD.equals(methodDeclaration.getMethodName())) {
            return false;
        }
        List parameters = ((ASTFormalParameters)methodDeclaration.getFirstDescendantOfType(ASTFormalParameters.class)).findChildrenOfType(ASTFormalParameter.class);
        return parameters.size() == 1 && ((ASTType)((ASTFormalParameter)parameters.get(0)).getFirstChildOfType(ASTType.class)).getType() == Runnable.class;
    }

    private boolean isInPrimaryOrProtectedMethod(ASTAllocationExpression node) {
        ASTMethodDeclaration methodDeclaration = (ASTMethodDeclaration)node.getFirstParentOfType(ASTMethodDeclaration.class);
        return methodDeclaration != null && this.returnThread(methodDeclaration) && (methodDeclaration.isPrivate() || methodDeclaration.isProtected());
    }

    private boolean returnThread(ASTMethodDeclaration methodDeclaration) {
        ASTResultType resultType = (ASTResultType)methodDeclaration.getFirstChildOfType(ASTResultType.class);
        ASTType type = (ASTType)resultType.getFirstChildOfType(ASTType.class);
        return type != null && type.getType() == Thread.class;
    }

    private Object addViolationAndReturn(ASTAllocationExpression node, Object data) {
        this.addViolationWithMessage(data, (Node)node, "java.concurrent.AvoidManuallyCreateThreadRule.violation.msg");
        return super.visit(node, data);
    }

    private boolean checkForNamingClass(ASTAllocationExpression node) {
        ASTClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        if (classOrInterfaceDeclaration == null) {
            return false;
        }
        ASTImplementsList implementsList = (ASTImplementsList)classOrInterfaceDeclaration.getFirstChildOfType(ASTImplementsList.class);
        if (implementsList == null) {
            return false;
        }
        List interfaceTypes = implementsList.findChildrenOfType(ASTClassOrInterfaceType.class);
        for (ASTClassOrInterfaceType type : interfaceTypes) {
            if (type.getType() != ThreadFactory.class) continue;
            return true;
        }
        return false;
    }
}

