/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.concurrent;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J3\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004*\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/alibaba/p3c/pmd/lang/java/rule/concurrent/LockShouldWithTryFinallyRule;", "Lcom/alibaba/p3c/pmd/lang/java/rule/AbstractAliRule;", "()V", "isLock", "", "Lnet/sourceforge/pmd/lang/java/ast/ASTStatementExpression;", "(Lnet/sourceforge/pmd/lang/java/ast/ASTStatementExpression;)Z", "addLockViolation", "", "data", "", "lockExpression", "checkBlock", "block", "Lnet/sourceforge/pmd/lang/java/ast/ASTBlock;", "checkTryStatement", "tryStatement", "Lnet/sourceforge/pmd/lang/java/ast/ASTTryStatement;", "findNodeByXpath", "T", "statement", "Lnet/sourceforge/pmd/lang/java/ast/AbstractJavaNode;", "xpath", "", "clazz", "Ljava/lang/Class;", "(Lnet/sourceforge/pmd/lang/java/ast/AbstractJavaNode;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getExpressName", "statementExpression", "visit", "node", "Companion", "p3c-pmd"})
public class LockShouldWithTryFinallyRule
extends AbstractAliRule {
    private static final String XPATH_LOCK_STATEMENT = "Statement/StatementExpression";
    private static final String XPATH_UNLOCK_STATEMENT = "Block/BlockStatement/Statement/StatementExpression";
    private static final String XPATH_TRY_STATEMENT = "Statement/TryStatement";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Object visit(@NotNull ASTBlock node, @NotNull Object data) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.checkBlock(node, data);
        return super.visit(node, data);
    }

    private final void checkBlock(ASTBlock block, Object data) {
        block7: {
            List statements = block.findChildrenOfType(ASTBlockStatement.class);
            Collection collection = statements;
            boolean bl = false;
            boolean bl2 = false;
            if (collection == null || collection.isEmpty()) {
                return;
            }
            ASTStatementExpression lockExpression = null;
            for (ASTBlockStatement statement : statements) {
                boolean lockMethod;
                boolean bl3;
                ASTStatementExpression expression;
                if (lockExpression != null) {
                    ASTBlockStatement aSTBlockStatement = statement;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTBlockStatement, (String)"statement");
                    ASTTryStatement tryStatement = this.findNodeByXpath((AbstractJavaNode)aSTBlockStatement, XPATH_TRY_STATEMENT, ASTTryStatement.class);
                    if (!this.checkTryStatement(tryStatement)) {
                        this.addLockViolation(data, lockExpression);
                    }
                    lockExpression = null;
                    continue;
                }
                ASTBlockStatement aSTBlockStatement = statement;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTBlockStatement, (String)"statement");
                if (this.findNodeByXpath((AbstractJavaNode)aSTBlockStatement, XPATH_LOCK_STATEMENT, ASTStatementExpression.class) == null) {
                    continue;
                }
                if (!this.isLock(expression)) continue;
                ASTName astName = (ASTName)expression.getFirstDescendantOfType(ASTName.class);
                Object object = astName;
                if (object != null && (object = object.getImage()) != null) {
                    Object object2 = object;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object it = object2;
                    boolean bl6 = false;
                    bl3 = StringsKt.endsWith$default((String)it, (String)".lock", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)".lockInterruptibly", (boolean)false, (int)2, null);
                } else {
                    bl3 = lockMethod = false;
                }
                if (!lockMethod) continue;
                lockExpression = expression;
            }
            ASTStatementExpression aSTStatementExpression = lockExpression;
            if (aSTStatementExpression == null) break block7;
            ASTStatementExpression aSTStatementExpression2 = aSTStatementExpression;
            boolean bl7 = false;
            boolean bl8 = false;
            ASTStatementExpression it = aSTStatementExpression2;
            boolean bl9 = false;
            this.addLockViolation(data, it);
        }
    }

    private final void addLockViolation(Object data, ASTStatementExpression lockExpression) {
        this.addViolationWithMessage(data, (Node)lockExpression, "java.concurrent.LockShouldWithTryFinallyRule.violation.msg", new Object[]{this.getExpressName(lockExpression)});
    }

    private final boolean checkTryStatement(ASTTryStatement tryStatement) {
        if (tryStatement == null) {
            return false;
        }
        ASTFinallyStatement aSTFinallyStatement = (ASTFinallyStatement)tryStatement.getFirstChildOfType(ASTFinallyStatement.class);
        if (aSTFinallyStatement == null) {
            return false;
        }
        ASTFinallyStatement finallyStatement = aSTFinallyStatement;
        ASTStatementExpression aSTStatementExpression = this.findNodeByXpath((AbstractJavaNode)finallyStatement, XPATH_UNLOCK_STATEMENT, ASTStatementExpression.class);
        if (aSTStatementExpression == null) {
            return false;
        }
        ASTStatementExpression statementExpression = aSTStatementExpression;
        if (!this.isLock(statementExpression)) {
            return false;
        }
        ASTName aSTName = (ASTName)statementExpression.getFirstDescendantOfType(ASTName.class);
        if (aSTName == null) {
            return false;
        }
        ASTName astName = aSTName;
        String string = astName.getImage();
        return string != null ? StringsKt.endsWith$default((String)string, (String)".unlock", (boolean)false, (int)2, null) : false;
    }

    private final <T> T findNodeByXpath(AbstractJavaNode statement, String xpath, Class<T> clazz) {
        List nodes = statement.findChildNodesWithXPath(xpath);
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        Node node = (Node)nodes.get(0);
        return !clazz.isAssignableFrom(node.getClass()) ? null : (T)clazz.cast(node);
    }

    private final String getExpressName(ASTStatementExpression statementExpression) {
        ASTName name;
        ASTName aSTName = name = (ASTName)statementExpression.getFirstDescendantOfType(ASTName.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTName, (String)"name");
        String string = aSTName.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.image");
        return string;
    }

    private final boolean isLock(@Nullable ASTStatementExpression $this$isLock) {
        boolean bl;
        Object object = $this$isLock;
        if (object != null && (object = object.getType()) != null) {
            Object object2 = object;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object2;
            boolean bl4 = false;
            bl = Lock.class.isAssignableFrom((Class<?>)it);
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/alibaba/p3c/pmd/lang/java/rule/concurrent/LockShouldWithTryFinallyRule$Companion;", "", "()V", "XPATH_LOCK_STATEMENT", "", "XPATH_TRY_STATEMENT", "XPATH_UNLOCK_STATEMENT", "p3c-pmd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

