/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.spring.boot;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.alibaba.dubbo.spring.boot.DubboAutoConfiguration;
import com.alibaba.dubbo.spring.boot.DubboProperties;
import com.alibaba.dubbo.spring.boot.annotation.EnableDubboConfiguration;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Service.class})
@ConditionalOnBean(annotation={EnableDubboConfiguration.class})
@AutoConfigureAfter(value={DubboAutoConfiguration.class})
@EnableConfigurationProperties(value={DubboProperties.class})
public class DubboProviderAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DubboProperties properties;
    @Autowired
    private ApplicationConfig applicationConfig;
    @Autowired(required=false)
    private RegistryConfig registryConfig;
    @Autowired(required=false)
    private MonitorConfig monitorConfig;

    @PostConstruct
    public void init() throws Exception {
        Map beans = this.applicationContext.getBeansWithAnnotation(Service.class);
        for (Map.Entry entry : beans.entrySet()) {
            this.initProviderBean((String)entry.getKey(), entry.getValue());
        }
    }

    private void initProviderBean(String beanName, Object bean) throws Exception {
        String[] registrys;
        String group;
        String version;
        Class<?>[] interfaces;
        Service service = (Service)this.applicationContext.findAnnotationOnBean(beanName, Service.class);
        ServiceBean serviceConfig = new ServiceBean(service);
        if (!(service.interfaceClass() != null && service.interfaceClass() != Void.TYPE || service.interfaceName() != null && !"".equals(service.interfaceName()) || (interfaces = bean.getClass().getInterfaces()).length != 1)) {
            serviceConfig.setInterface(interfaces[0]);
        }
        if (((version = service.version()) == null || "".equals(version)) && (version = this.properties.getVersion()) != null && !"".equals(version)) {
            serviceConfig.setVersion(version);
        }
        if (((group = service.group()) == null || "".equals(group)) && (group = this.properties.getGroup()) != null && !"".equals(group)) {
            serviceConfig.setGroup(group);
        }
        if ((registrys = service.registry()) != null && registrys.length > 0) {
            ArrayList<RegistryConfig> registrieList = new ArrayList<RegistryConfig>();
            for (String registry : registrys) {
                RegistryConfig registryConfig = new RegistryConfig();
                registryConfig.setAddress(registry);
                registrieList.add(registryConfig);
            }
            serviceConfig.setRegistries(registrieList);
        } else {
            serviceConfig.setRegistry(this.registryConfig);
        }
        if (this.monitorConfig != null) {
            serviceConfig.setMonitor(this.monitorConfig);
        }
        if (this.properties.getProtocols().isEmpty()) {
            ProtocolConfig protocolConfig = new ProtocolConfig();
            protocolConfig.setName(this.properties.getProtocol());
            protocolConfig.setPort(Integer.valueOf(this.properties.getPort()));
            protocolConfig.setThreads(Integer.valueOf(this.properties.getThreads()));
            serviceConfig.setProtocol(protocolConfig);
        } else {
            ArrayList<ProtocolConfig> protocolConfigList = new ArrayList<ProtocolConfig>();
            String[] protocols = service.protocol();
            if (protocols != null && protocols.length > 0) {
                Map<String, ProtocolConfig> protocolMap = this.properties.getProtocols();
                for (String protocol : protocols) {
                    ProtocolConfig protocolConfig = protocolMap.get(protocol);
                    if (protocolConfig == null) {
                        throw new NullPointerException("beanName=" + beanName + ", protocol=" + protocol + " not found in protocols");
                    }
                    protocolConfigList.add(protocolConfig);
                }
            } else {
                protocolConfigList.addAll(this.properties.getProtocols().values());
            }
            serviceConfig.setProtocols(protocolConfigList);
        }
        serviceConfig.setApplicationContext(this.applicationContext);
        serviceConfig.setApplication(this.applicationConfig);
        serviceConfig.afterPropertiesSet();
        serviceConfig.setRef(bean);
        serviceConfig.export();
    }
}

